/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.handler;

import dev.amble.ait.api.tardis.KeyedTardisComponent;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.api.tardis.TardisTickable;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;
import dev.amble.ait.core.tardis.util.TardisUtil;
import dev.amble.ait.data.Exclude;
import dev.amble.ait.data.Loyalty;
import dev.amble.ait.data.properties.bool.BoolProperty;
import dev.amble.ait.data.properties.bool.BoolValue;
import dev.drtheo.queue.api.ActionQueue;
import java.util.ArrayDeque;
import java.util.Optional;
import java.util.Queue;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1541;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.server.MinecraftServer;

public class ServerAlarmHandler
extends KeyedTardisComponent
implements TardisTickable {
    @Exclude
    public static final int CLOISTER_LENGTH_TICKS = 60;
    @Exclude
    private int soundCounter = 0;
    @Exclude
    private Queue<Alarm> alarms;
    @Exclude
    private Alarm currentAlarm;
    private static final BoolProperty ENABLED = new BoolProperty("enabled", false);
    private static final BoolProperty HOSTILE_PRESENCE = new BoolProperty("hostile_presence", true);
    private final BoolValue enabled = ENABLED.create(this);
    private final BoolValue hostilePresence = HOSTILE_PRESENCE.create(this);

    public ServerAlarmHandler() {
        super(TardisComponent.Id.ALARMS);
    }

    @Override
    public void onLoaded() {
        this.enabled.of(this, ENABLED);
        this.hostilePresence.of(this, HOSTILE_PRESENCE);
    }

    @Override
    public void postInit(TardisComponent.InitContext ctx) {
        super.postInit(ctx);
        if (this.isServer()) {
            this.alarms = new ArrayDeque<Alarm>();
        }
    }

    @Deprecated(forRemoval=true, since="1.3.0")
    public BoolValue enabled() {
        return this.enabled;
    }

    public boolean isEnabled() {
        return (Boolean)this.enabled.get();
    }

    public void enable() {
        this.enabled.set(true);
    }

    public Alarm enable(Alarm cause) {
        this.tryStart(cause);
        return cause;
    }

    public Alarm enable(class_2561 cause) {
        return this.enable(() -> Optional.ofNullable(cause));
    }

    public void disable() {
        this.enabled.set(false);
        this.currentAlarm = null;
    }

    public BoolValue hostilePresence() {
        return this.hostilePresence;
    }

    public void toggle() {
        if (((Boolean)this.enabled.get()).booleanValue()) {
            this.disable();
        } else {
            this.enable();
        }
    }

    private boolean isDoorOpen() {
        return this.tardis.door().isOpen();
    }

    private void tryStart(Alarm alarm) {
        if (this.currentAlarm == null || alarm.priority() > this.currentAlarm.priority()) {
            this.currentAlarm = alarm;
            return;
        }
        this.alarms.add(alarm);
    }

    @Override
    public void tick(MinecraftServer server) {
        if (server.method_3780() % 20 == 0 && !((Boolean)this.enabled().get()).booleanValue() && ((Boolean)this.hostilePresence().get()).booleanValue()) {
            for (class_1297 entity : TardisUtil.getEntitiesInInterior(this.tardis, 200)) {
                if (!(entity instanceof class_1541 || entity instanceof class_1588 && !entity.method_16914())) {
                    if (!(entity instanceof class_3222)) continue;
                    class_3222 player2 = (class_3222)entity;
                    if (this.tardis.loyalty().get((class_1657)player2).level() != Loyalty.Type.REJECT.level) continue;
                }
                this.tardis.alarm().enable(AlarmType.HOSTILE_PRESENCE);
            }
            return;
        }
        if (!((Boolean)this.enabled().get()).booleanValue()) {
            if (this.currentAlarm != null) {
                this.enable();
            }
            return;
        }
        if (this.tardis.travel().getState() == TravelHandlerBase.State.FLIGHT) {
            return;
        }
        ++this.soundCounter;
        if (this.soundCounter >= 60) {
            this.soundCounter = 0;
            float volume = this.isDoorOpen() ? 1.0f : 0.3f;
            float pitch = this.isDoorOpen() ? 1.0f : 0.2f;
            this.tardis.travel().position().getWorld().method_8396(null, this.tardis.travel().position().getPos(), AITSounds.CLOISTER, class_3419.field_15256, volume, pitch);
            if (this.currentAlarm != null) {
                this.tardis.asServer().world().method_18456().forEach(player -> this.currentAlarm.sendMessage((class_3222)player));
            }
        }
        if (this.currentAlarm != null && this.currentAlarm.tick()) {
            this.currentAlarm = null;
            if (!this.alarms.isEmpty()) {
                this.currentAlarm = this.alarms.poll();
            }
        }
    }

    public static interface Alarm {
        default public boolean tick() {
            return false;
        }

        default public int priority() {
            return 0;
        }

        default public void sendMessage(class_3222 player) {
            this.getAlarmText().ifPresent(text -> player.method_7353(text, true));
        }

        public Optional<class_2561> getAlarmText();
    }

    public static enum AlarmType implements Alarm
    {
        CRASHING,
        HOSTILE_PRESENCE,
        HAIL_MARY("tardis.message.protocol_813.travel");

        private final String translation;

        private AlarmType() {
            this.translation = "tardis.message.alarm." + this.name().toLowerCase();
        }

        private AlarmType(String translation) {
            this.translation = translation;
        }

        @Override
        public Optional<class_2561> getAlarmText() {
            return Optional.of(class_2561.method_43471((String)this.translation).method_27692(class_124.field_1061));
        }
    }

    public static class Countdown
    implements Alarm {
        private final String translation;
        private final ActionQueue onFinished;
        private int ticks;

        public Countdown(String translation, int ticks) {
            this.translation = translation;
            this.ticks = ticks;
            this.onFinished = new ActionQueue();
        }

        @Override
        public int priority() {
            return 1;
        }

        public ActionQueue onFinished() {
            return this.onFinished;
        }

        public Countdown thenRun(Runnable action) {
            this.onFinished.thenRun(action);
            return this;
        }

        public Countdown thenRun(ActionQueue action) {
            this.onFinished.thenRun(action);
            return this;
        }

        @Override
        public boolean tick() {
            if (this.ticks > 0) {
                --this.ticks;
                return false;
            }
            this.onFinished.execute();
            return true;
        }

        @Override
        public Optional<class_2561> getAlarmText() {
            if (this.translation == null) {
                return Optional.empty();
            }
            return Optional.of(class_2561.method_43469((String)this.translation, (Object[])new Object[]{Math.ceil((float)this.ticks / 20.0f)}).method_27692(class_124.field_1061));
        }

        public static class Builder {
            private String translation;
            private int ticks;

            public Builder message(String translation) {
                this.translation = translation;
                return this;
            }

            public Builder ticks(int ticks) {
                if (ticks <= 0) {
                    throw new IllegalArgumentException("Ticks must be greater than 0");
                }
                this.ticks = ticks;
                return this;
            }

            public Builder bellTolls(int count) {
                if (count <= 0) {
                    throw new IllegalArgumentException("Bell tolls must be greater than 0");
                }
                return this.ticks(count * 60);
            }

            public Countdown thenRun(Runnable action) {
                return this.build().thenRun(action);
            }

            public Countdown thenRun(ActionQueue action) {
                return this.build().thenRun(action);
            }

            public Countdown build() {
                return new Countdown(this.translation, this.ticks);
            }
        }
    }
}

