/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.handler;

import dev.amble.ait.api.tardis.KeyedTardisComponent;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.api.tardis.TardisEvents;
import dev.amble.ait.api.tardis.TardisTickable;
import dev.amble.ait.core.AITItems;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.item.SiegeTardisItem;
import dev.amble.ait.core.tardis.manager.ServerTardisManager;
import dev.amble.ait.core.tardis.util.TardisUtil;
import dev.amble.ait.data.properties.Property;
import dev.amble.ait.data.properties.Value;
import dev.amble.ait.data.properties.bool.BoolProperty;
import dev.amble.ait.data.properties.bool.BoolValue;
import java.util.Objects;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.server.MinecraftServer;

public class SiegeHandler
extends KeyedTardisComponent
implements TardisTickable {
    public static final class_2960 DEFAULT_TEXTURRE = new class_2960("ait", "textures/blockentities/exteriors/siege_mode/siege_mode.png");
    public static final class_2960 BRICK_TEXTURE = new class_2960("ait", "textures/blockentities/exteriors/siege_mode/siege_mode_brick.png");
    public static final class_2960 COMPANION_TEXTURE = new class_2960("ait", "textures/blockentities/exteriors/siege_mode/companion_cube.png");
    public static final class_2960 APERTURE_TEXTURE = new class_2960("ait", "textures/blockentities/exteriors/siege_mode/weighted_cube.png");
    private static final Property<UUID> HELD_KEY = new Property<UUID>(Property.UUID, "siege_held_uuid");
    private static final Property<class_2960> TEXTURE = new Property<class_2960>(Property.IDENTIFIER, "texture", DEFAULT_TEXTURRE);
    private static final BoolProperty ACTIVE = new BoolProperty("siege_mode", false);
    private final Value<UUID> heldKey = HELD_KEY.create((UUID)((Object)this));
    private final BoolValue active = ACTIVE.create(this);
    private final Value<class_2960> texture = TEXTURE.create((class_2960)this);
    private int siegeTime;

    public SiegeHandler() {
        super(TardisComponent.Id.SIEGE);
    }

    @Override
    public void onLoaded() {
        this.active.of(this, ACTIVE);
        this.heldKey.of(this, HELD_KEY);
        this.texture.of(this, TEXTURE);
        UUID held = this.getHeldPlayerUUID();
        if (held != null && held.getMostSignificantBits() == 0L && held.getLeastSignificantBits() == 0L) {
            this.setSiegeBeingHeld(null);
        }
    }

    public boolean isActive() {
        return (Boolean)this.active.get();
    }

    public boolean isSiegeBeingHeld() {
        return this.isActive() && this.heldKey.get() != null;
    }

    public UUID getHeldPlayerUUID() {
        return this.heldKey.get();
    }

    public void setSiegeBeingHeld(UUID playerId) {
        if (playerId != null) {
            this.tardis.door().closeDoors();
            this.tardis.door().setLocked(true);
            this.tardis.alarm().enable();
        }
        this.heldKey.set(playerId);
    }

    public void setActive(boolean siege) {
        class_3414 sound;
        if (this.tardis.getFuel() <= 500.0) {
            return;
        }
        if (siege) {
            sound = AITSounds.SIEGE_ENABLE;
            this.tardis.door().closeDoors();
            this.tardis.door().setLocked(true);
            this.tardis.door().setDeadlocked(true);
            this.tardis.fuel().disablePower();
            TardisUtil.giveEffectToInteriorPlayers(this.tardis.asServer(), new class_1293(class_1294.field_5916, 100, 0, false, false));
        } else {
            sound = AITSounds.SIEGE_DISABLE;
            this.tardis.door().setDeadlocked(false);
            this.tardis.door().setLocked(false);
            this.tardis.alarm().disable();
            if (this.tardis.getExterior().findExteriorBlock().isEmpty()) {
                this.tardis.travel().placeExterior(false);
            }
            this.siegeTime = 0;
        }
        this.tardis.getDesktop().playSoundAtEveryConsole(sound, class_3419.field_15245, 3.0f, 1.0f);
        this.tardis.removeFuel(500.0 * (double)this.tardis.travel().instability());
        this.active.set(siege);
        ((TardisEvents.Siege)TardisEvents.TOGGLE_SIEGE.invoker()).onSiege(this.tardis, siege);
    }

    @Override
    public void tick(MinecraftServer server) {
        if (!((Boolean)this.active.get()).booleanValue()) {
            return;
        }
        ++this.siegeTime;
        if (server.method_3780() % 10 == 0) {
            return;
        }
        boolean freeze = this.siegeTime > 1200 && !this.isSiegeBeingHeld() && !this.tardis.subsystems().lifeSupport().isEnabled();
        this.tardis.asServer().world().method_18456().forEach(player -> {
            if (!player.method_5805() || !player.method_32316()) {
                return;
            }
            if (freeze) {
                this.freeze((class_3222)player);
            } else {
                this.unfreeze((class_3222)player);
            }
        });
    }

    private void freeze(class_3222 player) {
        int m = player.method_32312();
        if (m < 0) {
            player.method_32317(5);
        }
        player.method_32317(Math.min(player.method_32315(), m + 5));
    }

    private void unfreeze(class_3222 player) {
        if (player.method_32312() > player.method_32315()) {
            player.method_32317(0);
        }
    }

    public Value<class_2960> texture() {
        return this.texture;
    }

    static {
        TardisEvents.DEMAT.register(tardis -> tardis.siege().isActive() ? TardisEvents.Interaction.FAIL : TardisEvents.Interaction.PASS);
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            class_3222 player = handler.method_32311();
            ServerTardisManager.getInstance().forEach(tardis -> {
                if (!tardis.siege().isActive()) {
                    return;
                }
                if (!Objects.equals(tardis.siege().getHeldPlayerUUID(), player.method_5667())) {
                    return;
                }
                for (class_1799 itemStack : player.method_31548().field_7547) {
                    if (!itemStack.method_31574((class_1792)AITItems.SIEGE_ITEM) || !tardis.getUuid().equals(SiegeTardisItem.getTardisIdStatic(itemStack))) continue;
                    player.method_31548().method_5447(player.method_31548().method_7395(itemStack), class_1802.field_8162.method_7854());
                }
                SiegeTardisItem.placeTardis(tardis, SiegeTardisItem.fromEntity((class_1297)player));
            });
        });
    }
}

