/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.handler;

import dev.amble.ait.AITMod;
import dev.amble.ait.api.ArtronHolderItem;
import dev.amble.ait.api.tardis.KeyedTardisComponent;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.api.tardis.TardisEvents;
import dev.amble.ait.api.tardis.TardisTickable;
import dev.amble.ait.core.blockentities.ConsoleBlockEntity;
import dev.amble.ait.core.item.SonicItem;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.handler.TardisCrashHandler;
import dev.amble.ait.core.tardis.manager.ServerTardisManager;
import dev.amble.ait.data.properties.Property;
import dev.amble.ait.data.properties.Value;
import dev.amble.ait.registry.impl.SonicRegistry;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import dev.amble.lib.register.unlockable.Unlockable;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;

public class SonicHandler
extends KeyedTardisComponent
implements ArtronHolderItem,
TardisTickable {
    public static final class_2960 CHANGE_SONIC = AITMod.id("change_sonic");
    private static final Property<class_1799> EXTERIOR_SONIC = new Property<class_1799>(Property.ITEM_STACK, "exterior_sonic");
    private final Value<class_1799> exteriorSonic = EXTERIOR_SONIC.create((class_1799)this);

    public SonicHandler() {
        super(TardisComponent.Id.SONIC);
    }

    @Override
    public void onLoaded() {
        this.exteriorSonic.of(this, EXTERIOR_SONIC);
    }

    public class_1799 getExteriorSonic() {
        return this.exteriorSonic.get();
    }

    public void insertExteriorSonic(class_1799 sonic) {
        SonicHandler.insertAnySonic(this.exteriorSonic, sonic, stack -> SonicHandler.spawnItem(this.tardis.travel().position(), stack));
    }

    public class_1799 takeExteriorSonic() {
        return SonicHandler.takeAnySonic(this.exteriorSonic);
    }

    private static class_1799 takeAnySonic(Value<class_1799> value) {
        class_1799 result = value.get();
        value.set((class_1799)null);
        return result;
    }

    private static void insertAnySonic(Value<class_1799> value, class_1799 sonic, Consumer<class_1799> spawner) {
        value.flatMap(stack -> {
            if (stack != null) {
                spawner.accept((class_1799)stack);
            }
            return sonic;
        });
    }

    public static void spawnItem(class_1937 world, class_2338 pos, class_1799 sonic) {
        class_1542 entity = new class_1542(world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), sonic);
        world.method_8649((class_1297)entity);
    }

    public static void spawnItem(CachedDirectedGlobalPos cached, class_1799 sonic) {
        SonicHandler.spawnItem((class_1937)cached.getWorld(), cached.getPos(), sonic);
    }

    @Override
    public double getMaxFuel(class_1799 stack) {
        return 1000.0;
    }

    @Override
    public void tick(MinecraftServer server) {
        if (server.method_3780() % 10 != 0) {
            return;
        }
        class_1799 exteriorSonic = this.exteriorSonic.get();
        if (exteriorSonic != null) {
            ServerTardis tardis = this.tardis.asServer();
            TardisCrashHandler crash = tardis.crash();
            boolean isToxic = crash.isToxic();
            boolean isUnstable = crash.isUnstable();
            int repairTicks = crash.getRepairTicks();
            if (!isToxic && !isUnstable) {
                return;
            }
            crash.setRepairTicks(repairTicks <= 0 ? 0 : repairTicks - 5);
            this.removeFuel(10.0, exteriorSonic);
        }
    }

    static {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CHANGE_SONIC, (ServerPlayNetworking.PlayChannelHandler)ServerTardisManager.receiveTardis((tardis, server, player, handler, buf, responseSender) -> {
            class_2960 id = buf.method_10810();
            class_2338 pos = buf.method_10811();
            server.execute(() -> {
                if (!tardis.isUnlocked((Unlockable)SonicRegistry.getInstance().get(id))) {
                    return;
                }
                class_2586 patt0$temp = tardis.world().method_8321(pos);
                if (!(patt0$temp instanceof ConsoleBlockEntity)) {
                    return;
                }
                ConsoleBlockEntity consoleBlockEntity = (ConsoleBlockEntity)patt0$temp;
                SonicItem.setSchema(consoleBlockEntity.getSonicScrewdriver(), id);
            });
        }));
        TardisEvents.DEMAT.register(tardis -> tardis.sonic().getExteriorSonic() != null ? TardisEvents.Interaction.FAIL : TardisEvents.Interaction.PASS);
    }
}

