/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.handler;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.KeyedTardisComponent;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.core.sounds.flight.FlightSound;
import dev.amble.ait.core.sounds.flight.FlightSoundRegistry;
import dev.amble.ait.core.tardis.vortex.reference.VortexReference;
import dev.amble.ait.core.tardis.vortex.reference.VortexReferenceRegistry;
import dev.amble.ait.core.util.Lazy;
import dev.amble.ait.data.Exclude;
import dev.amble.ait.data.properties.Property;
import dev.amble.ait.data.properties.Value;
import dev.amble.ait.data.properties.bool.BoolProperty;
import dev.amble.ait.data.properties.bool.BoolValue;
import dev.amble.ait.data.properties.dbl.DoubleProperty;
import dev.amble.ait.data.properties.dbl.DoubleValue;
import dev.amble.ait.registry.impl.DesktopRegistry;
import dev.amble.lib.register.unlockable.Unlockable;
import dev.amble.lib.util.ServerLifecycleHooks;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.DateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.TimeZone;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_5321;
import org.joml.Vector3f;

public class StatsHandler
extends KeyedTardisComponent {
    private static final class_2960 NAME_PATH = AITMod.id("tardis_names.json");
    private static List<String> NAME_CACHE;
    private static final Property<String> NAME;
    private static final Property<String> PLAYER_CREATOR_NAME;
    private static final Property<Long> DATE;
    private static final Property<String> DATE_TIME_ZONE;
    private static final Property<class_5321<class_1937>> SKYBOX;
    private static final Property<class_2350> SKYBOX_DIRECTION;
    private static final Property<HashSet<String>> UNLOCKS;
    private static final Property<class_2960> FLIGHT_FX;
    private static final Property<class_2960> VORTEX_FX;
    private static final BoolProperty SECURITY;
    private static final BoolProperty HAIL_MARY;
    private static final BoolProperty RECEIVE_CALLS;
    private static final DoubleProperty TARDIS_X_SCALE;
    private static final DoubleProperty TARDIS_Y_SCALE;
    private static final DoubleProperty TARDIS_Z_SCALE;
    private final Value<String> tardisName = NAME.create((String)((Object)this));
    private final Value<String> playerCreatorName = PLAYER_CREATOR_NAME.create((String)((Object)this));
    private final Value<Long> dateCreated = DATE.create((Long)((Object)this));
    private final Value<String> dateTimeZone = DATE_TIME_ZONE.create((String)((Object)this));
    private final Value<class_5321<class_1937>> skybox = SKYBOX.create((class_5321<class_1937>)this);
    private final Value<class_2350> skyboxDirection = SKYBOX_DIRECTION.create((class_2350)this);
    private final Value<HashSet<String>> unlocks = UNLOCKS.create((HashSet<String>)((Object)this));
    private final BoolValue security = SECURITY.create(this);
    private final BoolValue hailMary = HAIL_MARY.create(this);
    private final BoolValue receiveCalls = RECEIVE_CALLS.create(this);
    private final Value<class_2960> flightId = FLIGHT_FX.create((class_2960)this);
    private final Value<class_2960> vortexId = VORTEX_FX.create((class_2960)this);
    private final DoubleValue tardisXScale = TARDIS_X_SCALE.create(this);
    private final DoubleValue tardisYScale = TARDIS_Y_SCALE.create(this);
    private final DoubleValue tardisZScale = TARDIS_Z_SCALE.create(this);
    @Exclude
    private Lazy<FlightSound> flightFxCache;
    @Exclude
    private Lazy<VortexReference> vortexFxCache;

    public StatsHandler() {
        super(TardisComponent.Id.STATS);
    }

    @Override
    public void onCreate() {
        this.markDateCreated();
        this.setName("Type 50 TT Capsule");
        this.setXScale(1.0);
        this.setYScale(1.0);
        this.setZScale(1.0);
    }

    @Override
    public void onLoaded() {
        this.skybox.of(this, SKYBOX);
        this.skyboxDirection.of(this, SKYBOX_DIRECTION);
        this.unlocks.of(this, UNLOCKS);
        this.tardisName.of(this, NAME);
        this.playerCreatorName.of(this, PLAYER_CREATOR_NAME);
        this.dateCreated.of(this, DATE);
        this.dateTimeZone.of(this, DATE_TIME_ZONE);
        this.security.of(this, SECURITY);
        this.hailMary.of(this, HAIL_MARY);
        this.receiveCalls.of(this, RECEIVE_CALLS);
        this.flightId.of(this, FLIGHT_FX);
        this.vortexId.of(this, VORTEX_FX);
        this.tardisXScale.of(this, TARDIS_X_SCALE);
        this.tardisYScale.of(this, TARDIS_Y_SCALE);
        this.tardisZScale.of(this, TARDIS_Z_SCALE);
        this.vortexId.addListener(id -> {
            if (this.vortexFxCache != null) {
                this.vortexFxCache.invalidate();
            } else {
                this.getVortexEffects();
            }
        });
        this.flightId.addListener(id -> {
            if (this.flightFxCache != null) {
                this.flightFxCache.invalidate();
            } else {
                this.getFlightEffects();
            }
        });
        Iterator it = DesktopRegistry.getInstance().iterator();
        while (it.hasNext()) {
            this.unlock((Unlockable)it.next(), false);
        }
    }

    public boolean isUnlocked(Unlockable unlockable) {
        return this.unlocks.get().contains(unlockable.id().toString());
    }

    public void unlock(Unlockable unlockable) {
        this.unlock(unlockable, true);
    }

    private void unlock(Unlockable unlockable, boolean sync) {
        this.unlocks.flatMap(strings -> {
            strings.add(unlockable.id().toString());
            return strings;
        }, sync);
    }

    public Value<class_5321<class_1937>> skybox() {
        return this.skybox;
    }

    public Value<class_2350> skyboxDirection() {
        return this.skyboxDirection;
    }

    public String getName() {
        String name = this.tardisName.get();
        if (name == null) {
            name = StatsHandler.getRandomName();
            this.setName(name);
        }
        return name;
    }

    public BoolValue security() {
        return this.security;
    }

    public BoolValue hailMary() {
        return this.hailMary;
    }

    public BoolValue receiveCalls() {
        return this.receiveCalls;
    }

    public String getPlayerCreatorName() {
        String name = this.playerCreatorName.get();
        if (name == null) {
            name = StatsHandler.getRandomName();
            this.setPlayerCreatorName(name);
        }
        return name;
    }

    public void setName(String name) {
        this.tardisName.set(name);
    }

    public void setPlayerCreatorName(String name) {
        this.playerCreatorName.set(name);
    }

    public static String getRandomName() {
        if (StatsHandler.shouldGenerateNames()) {
            StatsHandler.loadNames();
        }
        if (NAME_CACHE == null) {
            return "";
        }
        return NAME_CACHE.get(AITMod.RANDOM.nextInt(NAME_CACHE.size()));
    }

    public static boolean shouldGenerateNames() {
        return NAME_CACHE == null || NAME_CACHE.isEmpty();
    }

    private static void loadNames() {
        if (NAME_CACHE == null) {
            NAME_CACHE = new ArrayList<String>();
        }
        NAME_CACHE.clear();
        try {
            Optional resource = ServerLifecycleHooks.get().method_34864().method_14486(NAME_PATH);
            if (resource.isEmpty()) {
                AITMod.LOGGER.error("ERROR in tardis_names.json:");
                AITMod.LOGGER.error("Missing Resource");
                return;
            }
            InputStream stream = ((class_3298)resource.get()).method_14482();
            JsonArray list = JsonParser.parseReader((Reader)new InputStreamReader(stream)).getAsJsonArray();
            for (JsonElement element : list) {
                NAME_CACHE.add(element.getAsString());
            }
        }
        catch (IOException e) {
            AITMod.LOGGER.error("ERROR in tardis_names.json", (Throwable)e);
        }
    }

    public Date getDateCreated() {
        if (this.dateCreated.get() == null) {
            AITMod.LOGGER.error("{} was missing creation date! Resetting to now", (Object)this.tardis.getUuid().toString());
            this.markDateCreated();
        }
        try {
            Instant instant = Instant.ofEpochSecond(this.dateCreated.get());
            TimeZone timeZone = TimeZone.getTimeZone(this.dateTimeZone.get());
            Calendar calendar = Calendar.getInstance(timeZone);
            calendar.setTimeInMillis(instant.toEpochMilli());
            return calendar.getTime();
        }
        catch (Exception e) {
            AITMod.LOGGER.error("Error parsing creation date for {}", (Object)this.tardis.getUuid().toString(), (Object)e);
            return Date.from(Instant.now());
        }
    }

    private float getXScale() {
        double v = (Double)this.tardisXScale.get();
        return (float)v;
    }

    private float getYScale() {
        double v = (Double)this.tardisYScale.get();
        return (float)v;
    }

    private float getZScale() {
        double v = (Double)this.tardisZScale.get();
        return (float)v;
    }

    public Vector3f getScale() {
        return new Vector3f(this.getXScale(), this.getYScale(), this.getZScale());
    }

    public void setXScale(double scale) {
        this.tardisXScale.set(scale);
    }

    public void setYScale(double scale) {
        this.tardisYScale.set(scale);
    }

    public void setZScale(double scale) {
        this.tardisZScale.set(scale);
    }

    public void setScale(double x, double y, double z) {
        this.setXScale(x);
        this.setYScale(y);
        this.setZScale(z);
    }

    public String getCreationString() {
        return DateFormat.getDateTimeInstance(1, 3).format(this.getDateCreated());
    }

    public void markDateCreated() {
        this.dateCreated.set(Instant.now().getEpochSecond());
        this.dateTimeZone.set(DateFormat.getTimeInstance(1).getTimeZone().getID());
    }

    public void markPlayerCreatorName() {
        this.playerCreatorName.set(this.getPlayerCreatorName());
    }

    public FlightSound getFlightEffects() {
        if (this.flightFxCache == null) {
            this.flightFxCache = new Lazy<FlightSound>(this::createFlightEffectsCache);
        }
        return this.flightFxCache.get();
    }

    private FlightSound createFlightEffectsCache() {
        return (FlightSound)FlightSoundRegistry.getInstance().getOrFallback(this.flightId.get());
    }

    public VortexReference getVortexEffects() {
        if (this.vortexFxCache == null) {
            this.vortexFxCache = new Lazy<VortexReference>(this::createVortexEffectsCache);
        }
        return this.vortexFxCache.get();
    }

    private VortexReference createVortexEffectsCache() {
        return (VortexReference)VortexReferenceRegistry.getInstance().getOrFallback(this.vortexId.get());
    }

    public void setVortexEffects(VortexReference current) {
        this.vortexId.set(current.id());
        if (this.vortexFxCache != null) {
            this.vortexFxCache.invalidate();
        }
    }

    public void setFlightEffects(FlightSound current) {
        this.flightId.set(current.id());
        if (this.flightFxCache != null) {
            this.flightFxCache.invalidate();
        }
    }

    static {
        NAME = new Property<String>(Property.STR, "name", "");
        PLAYER_CREATOR_NAME = new Property<String>(Property.STR, "player_creator_name", "");
        DATE = new Property<Long>(Property.LONG, "date", 0L);
        DATE_TIME_ZONE = new Property<String>(Property.STR, "date_time_zone", "");
        SKYBOX = new Property<class_5321>(Property.WORLD_KEY, "skybox", class_1937.field_25181);
        SKYBOX_DIRECTION = new Property<class_2350>(Property.DIRECTION, "skybox_direction", class_2350.field_11043);
        UNLOCKS = new Property(Property.STR_SET, "unlocks", new HashSet());
        FLIGHT_FX = new Property<class_2960>(Property.IDENTIFIER, "flight_fx", new class_2960(""));
        VORTEX_FX = new Property<class_2960>(Property.IDENTIFIER, "vortex_fx", new class_2960(""));
        SECURITY = new BoolProperty("security", false);
        HAIL_MARY = new BoolProperty("hail_mary", false);
        RECEIVE_CALLS = new BoolProperty("receive_calls", true);
        TARDIS_X_SCALE = new DoubleProperty("tardis_x_scale", 1.0);
        TARDIS_Y_SCALE = new DoubleProperty("tardis_y_scale", 1.0);
        TARDIS_Z_SCALE = new DoubleProperty("tardis_z_scale", 1.0);
    }
}

