/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.handler;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.KeyedTardisComponent;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.api.tardis.TardisEvents;
import dev.amble.ait.api.tardis.TardisTickable;
import dev.amble.ait.core.engine.DurableSubSystem;
import dev.amble.ait.core.engine.SubSystem;
import dev.amble.ait.core.engine.impl.ChameleonCircuit;
import dev.amble.ait.core.engine.impl.DematCircuit;
import dev.amble.ait.core.engine.impl.EmergencyPower;
import dev.amble.ait.core.engine.impl.EngineSystem;
import dev.amble.ait.core.engine.impl.LifeSupportCircuit;
import dev.amble.ait.core.engine.impl.ShieldsCircuit;
import dev.amble.ait.core.engine.impl.Stabilisers;
import dev.amble.ait.core.engine.registry.SubSystemRegistry;
import dev.amble.ait.data.Exclude;
import dev.amble.ait.data.enummap.ConcurrentEnumMap;
import dev.amble.lib.util.ArrayIterator;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class SubSystemHandler
extends KeyedTardisComponent
implements TardisTickable,
Iterable<SubSystem> {
    @Exclude
    private final ConcurrentEnumMap<SubSystem.IdLike, SubSystem> systems = new ConcurrentEnumMap(SubSystemRegistry::values, SubSystem[]::new);

    public SubSystemHandler() {
        super(TardisComponent.Id.SUBSYSTEM);
    }

    @Override
    public void onCreate() {
        SubSystemRegistry.getInstance().fill(this::create);
    }

    @Override
    protected void onInit(TardisComponent.InitContext ctx) {
        super.onInit(ctx);
        this.forEach((Consumer<? super SubSystem>)((Consumer<SubSystem>)component -> SubSystem.init(component, this.tardis, ctx)));
    }

    public <T extends SubSystem> T get(SubSystem.IdLike id) {
        return (T)this.systems.get(id);
    }

    public SubSystem add(SubSystem system) {
        this.systems.put(system.getId(), system);
        this.sync();
        return system;
    }

    @Override
    @NotNull
    public Iterator<SubSystem> iterator() {
        return new ArrayIterator<SubSystem>((SubSystem[])this.systems.getValues());
    }

    @Override
    public void forEach(Consumer<? super SubSystem> consumer) {
        for (SubSystem system : (SubSystem[])this.systems.getValues()) {
            consumer.accept(system);
        }
    }

    private void create(SubSystem subSystem) {
        this.set(subSystem);
        if (this.tardis != null) {
            SubSystem.init(subSystem, this.tardis, TardisComponent.InitContext.createdAt(this.tardis.travel().position()));
        }
    }

    public boolean isEnabled() {
        for (SubSystem i : this) {
            if (i.isEnabled()) continue;
            return false;
        }
        return true;
    }

    public int count() {
        return this.systems.size();
    }

    @Override
    public void tick(MinecraftServer server) {
        for (SubSystem next : this) {
            next.tick();
        }
    }

    public void repairAll() {
        AITMod.LOGGER.info("Repairing all subsystems for {}", (Object)this.tardis);
        for (SubSystem next : this) {
            if (next instanceof DurableSubSystem) {
                DurableSubSystem durable = (DurableSubSystem)next;
                durable.setDurability(1250.0f);
            }
            next.setEnabled(true);
        }
    }

    public EngineSystem engine() {
        return (EngineSystem)this.get(SubSystem.Id.ENGINE);
    }

    public DematCircuit demat() {
        return (DematCircuit)this.get(SubSystem.Id.DEMAT);
    }

    public LifeSupportCircuit lifeSupport() {
        return (LifeSupportCircuit)this.get(SubSystem.Id.LIFE_SUPPORT);
    }

    public ShieldsCircuit shields() {
        return (ShieldsCircuit)this.get(SubSystem.Id.SHIELDS);
    }

    public EmergencyPower emergency() {
        return (EmergencyPower)this.get(SubSystem.Id.EMERGENCY_POWER);
    }

    public Stabilisers stabilisers() {
        return (Stabilisers)this.get(SubSystem.Id.STABILISERS);
    }

    public ChameleonCircuit chameleon() {
        return (ChameleonCircuit)this.get(SubSystem.Id.CHAMELEON);
    }

    @ApiStatus.Internal
    public <T extends SubSystem> void set(T t) {
        this.systems.put(t.getId(), t);
    }

    public static Object serializer() {
        return new Serializer();
    }

    static {
        TardisEvents.OUT_OF_FUEL.register(tardis -> tardis.fuel().disablePower());
        TardisEvents.LANDED.register(tardis -> {
            if (tardis.travel().autopilot() && tardis.travel().isCrashing()) {
                tardis.travel().autopilot(false);
            }
        });
    }

    static class Serializer
    implements JsonSerializer<SubSystemHandler>,
    JsonDeserializer<SubSystemHandler> {
        Serializer() {
        }

        public SubSystemHandler deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            SubSystemHandler manager = new SubSystemHandler();
            Map map = json.getAsJsonObject().asMap();
            SubSystemRegistry registry = SubSystemRegistry.getInstance();
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                JsonElement element = (JsonElement)entry.getValue();
                SubSystem.IdLike id = registry.get(key);
                if (id == null) {
                    AITMod.LOGGER.error("Can't find a subsystem id with name '{}'!", (Object)key);
                    continue;
                }
                try {
                    manager.set((SubSystem)context.deserialize(element, id.clazz()));
                }
                catch (Throwable e) {
                    AITMod.LOGGER.error("Failed to deserialize subsystem {}", (Object)id, (Object)e);
                }
            }
            for (int i = 0; i < manager.systems.size(); ++i) {
                if (manager.systems.get(i) != null) continue;
                SubSystem.IdLike id = registry.get(i);
                AITMod.LOGGER.debug("Appending new subsystem {}", (Object)id);
                manager.set(id.create());
            }
            return manager;
        }

        public JsonElement serialize(SubSystemHandler manager, Type type, JsonSerializationContext context) {
            JsonObject result = new JsonObject();
            manager.forEach((Consumer<? super SubSystem>)((Consumer<SubSystem>)component -> {
                SubSystem.IdLike idLike = component.getId();
                if (idLike == null) {
                    AITMod.LOGGER.error("Id was null for {}", component.getClass());
                    return;
                }
                result.add(idLike.name(), context.serialize(component));
            }));
            return result;
        }
    }
}

