/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.handler;

import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.KeyedTardisComponent;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.api.tardis.TardisTickable;
import dev.amble.ait.core.AITTags;
import dev.amble.ait.core.tardis.handler.DoorHandler;
import dev.amble.ait.core.tardis.util.TardisUtil;
import dev.amble.ait.data.properties.Property;
import dev.amble.ait.data.properties.Value;
import dev.amble.ait.data.properties.integer.IntProperty;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5743;
import net.minecraft.server.MinecraftServer;
import org.joml.Vector3f;

public class TardisCrashHandler
extends KeyedTardisComponent
implements TardisTickable {
    public static final Integer UNSTABLE_TICK_START_THRESHOLD = 2400;
    public static final Integer MAX_REPAIR_TICKS = 7000;
    private static final Property<State> STATE_PROPERTY = Property.forEnum("state", State.class, State.NORMAL);
    private static final IntProperty TARDIS_REPAIR_TICKS_PROPERTY = new IntProperty("repair_ticks", 0);
    private final Value<State> state = STATE_PROPERTY.create((State)((Object)this));
    private final Value<Integer> repairTicks = TARDIS_REPAIR_TICKS_PROPERTY.create(this);

    public boolean isToxic() {
        return this.getState() == State.TOXIC;
    }

    public boolean isUnstable() {
        return this.getState() == State.UNSTABLE;
    }

    public boolean isNormal() {
        return this.getState() == State.NORMAL;
    }

    @Override
    public void onLoaded() {
        this.state.of(this, STATE_PROPERTY);
        this.repairTicks.of(this, TARDIS_REPAIR_TICKS_PROPERTY);
    }

    @Override
    public void tick(MinecraftServer server) {
        if (this.tardis.isGrowth()) {
            return;
        }
        State state = this.state.get();
        int repairTicks = this.repairTicks.get();
        if (repairTicks <= 0) {
            if (state == State.NORMAL) {
                return;
            }
            this.state.set(State.NORMAL);
            this.tardis().alarm().disable();
            return;
        }
        repairTicks = this.tardis.isRefueling() ? repairTicks - 10 : repairTicks - 1;
        this.setRepairTicks(repairTicks);
        if (state == State.TOXIC && this.tardis.sonic().getExteriorSonic() == null) {
            this.tardis().alarm().enable();
        }
        if (repairTicks < UNSTABLE_TICK_START_THRESHOLD && state != State.UNSTABLE) {
            state = State.UNSTABLE;
            this.state.set(state);
        }
        CachedDirectedGlobalPos exteriorPosition = this.tardis.travel().position();
        class_3218 exteriorWorld = exteriorPosition.getWorld();
        DoorHandler door = this.tardis.door();
        door.setDoorParticles((class_2394)(state != State.NORMAL ? class_2398.field_17430 : null));
        if (state != State.TOXIC) {
            return;
        }
        exteriorWorld.method_14199((class_2394)new class_5743(new Vector3f(0.75f, 0.85f, 0.75f), new Vector3f(0.15f, 0.25f, 0.15f), 3.0f), exteriorPosition.getPos().method_46558().field_1352, (double)((float)exteriorPosition.getPos().method_10264() + 0.1f), exteriorPosition.getPos().method_46558().field_1350, 1, 0.05, 0.75, 0.05, 0.01);
        if (server.method_3780() % 40 != 0) {
            return;
        }
        if (TardisUtil.isInteriorEmpty(this.tardis.asServer())) {
            return;
        }
        int loyaltySubAmount = AITMod.RANDOM.nextInt(10, 25);
        for (class_3222 serverPlayerEntity : this.tardis.asServer().world().method_18456()) {
            class_1799 stack = serverPlayerEntity.method_6118(class_1304.field_6169);
            if (stack.method_31573(AITTags.Items.FULL_RESPIRATORS) || stack.method_31573(AITTags.Items.HALF_RESPIRATORS)) continue;
            serverPlayerEntity.method_5643(exteriorWorld.method_48963().method_48831(), 3.0f);
            serverPlayerEntity.method_6092(new class_1293(class_1294.field_5903, 100, 3, true, false, false));
            serverPlayerEntity.method_6092(new class_1293(class_1294.field_5911, 100, 5, true, false, false));
            this.tardis.loyalty().get((class_1657)serverPlayerEntity).subtract(loyaltySubAmount);
        }
    }

    public TardisCrashHandler() {
        super(TardisComponent.Id.CRASH_DATA);
    }

    public State getState() {
        if (this.state.get() == null) {
            return State.NORMAL;
        }
        return this.state.get();
    }

    public void setState(State tardisState) {
        this.state.set(tardisState);
    }

    public Integer getRepairTicks() {
        return this.repairTicks.get();
    }

    public int getRepairTicksAsSeconds() {
        return this.getRepairTicks() / 20;
    }

    public void setRepairTicks(Integer ticks) {
        if (ticks > MAX_REPAIR_TICKS) {
            this.setRepairTicks(MAX_REPAIR_TICKS);
            return;
        }
        this.repairTicks.set(ticks);
    }

    public void addRepairTicks(Integer ticks) {
        this.repairTicks.set(this.getRepairTicks() + ticks);
    }

    public static enum State {
        NORMAL,
        UNSTABLE,
        TOXIC;

    }
}

