/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.handler;

import dev.amble.ait.api.tardis.KeyedTardisComponent;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.core.item.WaypointItem;
import dev.amble.ait.core.world.TardisServerWorld;
import dev.amble.ait.data.Waypoint;
import dev.amble.ait.data.properties.bool.BoolProperty;
import dev.amble.ait.data.properties.bool.BoolValue;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_5321;

public class WaypointHandler
extends KeyedTardisComponent {
    public static final BoolProperty HAS_CARTRIDGE = new BoolProperty("has_cartridge", false);
    private final BoolValue hasCartridge = HAS_CARTRIDGE.create(this);
    private Waypoint current;

    public WaypointHandler() {
        super(TardisComponent.Id.WAYPOINTS);
    }

    @Override
    public void onLoaded() {
        this.hasCartridge.of(this, HAS_CARTRIDGE);
    }

    public boolean hasCartridge() {
        return (Boolean)this.hasCartridge.get();
    }

    public void setHasCartridge() {
        this.hasCartridge.set(true);
    }

    private void clearCartridge() {
        this.hasCartridge.set(false);
    }

    public Optional<Waypoint> set(Waypoint var, class_2338 console, boolean spawnItem) {
        Optional<Waypoint> prev = Optional.ofNullable(this.current);
        if (spawnItem && this.current != null) {
            this.spawnItem(console, prev.get());
        }
        this.current = var;
        return prev;
    }

    public Waypoint get() {
        return this.current;
    }

    public boolean hasWaypoint() {
        return this.current != null;
    }

    public void clear(class_2338 console, boolean spawnItem) {
        this.set(null, console, spawnItem);
        this.clearCartridge();
    }

    public boolean loadWaypoint() {
        if (!this.hasWaypoint()) {
            return false;
        }
        CachedDirectedGlobalPos cachedPos = this.get().getPos();
        if (cachedPos == null || !this.hasWaypoint()) {
            return false;
        }
        if (cachedPos.getWorld() instanceof TardisServerWorld) {
            cachedPos = CachedDirectedGlobalPos.create((class_5321<class_1937>)TardisServerWorld.field_25179, cachedPos.getPos(), cachedPos.getRotation());
        }
        this.tardis.travel().destination(cachedPos);
        return true;
    }

    public void spawnItem(class_2338 console) {
        if (!this.hasWaypoint()) {
            return;
        }
        this.spawnItem(console, this.get());
        this.clear(console, false);
    }

    public void spawnItem(class_2338 console, Waypoint waypoint) {
        if (!this.hasCartridge()) {
            return;
        }
        class_1542 entity = new class_1542((class_1937)this.tardis.asServer().world(), (double)console.method_10263(), (double)console.method_10264(), (double)console.method_10260(), WaypointHandler.createWaypointItem(waypoint));
        this.tardis.asServer().world().method_8649((class_1297)entity);
    }

    public static class_1799 createWaypointItem(Waypoint waypoint) {
        return WaypointItem.create(waypoint);
    }
}

