/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.handler.distress;

import dev.amble.ait.api.tardis.link.v2.TardisRef;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.item.HypercubeItem;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.manager.ServerTardisManager;
import dev.amble.ait.core.tardis.util.TardisUtil;
import dev.amble.ait.core.util.TextUtil;
import dev.amble.ait.core.world.TardisServerWorld;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import dev.amble.lib.util.ServerLifecycleHooks;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.class_7718;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public record DistressCall(Sender sender, String message, int lifetime, int creationTime, boolean isSourceCall) {
    private static final int DEFAULT_LIFETIME = 2400;

    private static DistressCall createTardis(UUID tardis, String message, MinecraftServer server, int lifetime, boolean isSourceCall) {
        return new DistressCall(new TardisSender(tardis), message, lifetime, server.method_3780(), isSourceCall);
    }

    private static DistressCall createTardis(UUID tardis, String message, boolean isSourceCall) {
        return DistressCall.createTardis(tardis, message, ServerLifecycleHooks.get(), 2400, isSourceCall);
    }

    public static DistressCall create(Tardis tardis, String message, boolean isSourceCall) {
        return DistressCall.createTardis(tardis.getUuid(), message, isSourceCall);
    }

    private static DistressCall createPlayer(UUID player, String message, MinecraftServer server, int lifetime, boolean isSourceCall) {
        return new DistressCall(new PlayerSender(player), message, lifetime, server.method_3780(), isSourceCall);
    }

    public static DistressCall create(class_1657 player, String message, boolean isSourceCall) {
        return DistressCall.createPlayer(player.method_5667(), message, ServerLifecycleHooks.get(), 2400, isSourceCall);
    }

    public static DistressCall copyForSend(DistressCall call, int ticks) {
        return new DistressCall(call.sender(), call.message(), call.lifetime(), ticks, false);
    }

    public void summon(Tardis tardis, @Nullable class_1799 held) {
        CachedDirectedGlobalPos target = this.sender().position();
        tardis.travel().destination(target, true);
        tardis.getDesktop().playSoundAtEveryConsole(AITSounds.WAYPOINT_ACTIVATE);
        this.sender().playSoundAt(AITSounds.WAYPOINT_ACTIVATE);
        if (held != null && held.method_7909() instanceof HypercubeItem) {
            held.method_7939(0);
        }
    }

    public boolean isValid(int ticks) {
        return this.creationTime + this.lifetime > ticks;
    }

    private boolean isValid(MinecraftServer server) {
        return this.isValid(server.method_3780());
    }

    public boolean isValid() {
        return this.isValid(ServerLifecycleHooks.get());
    }

    public int getTimeLeft(int ticks) {
        if (this.isSourceCall()) {
            return this.lifetime;
        }
        int time = this.creationTime + this.lifetime - ticks;
        return Math.max(time, 0);
    }

    private int getTimeLeft(MinecraftServer server) {
        return this.getTimeLeft(server.method_3780());
    }

    public int getTimeLeft() {
        return this.getTimeLeft(ServerLifecycleHooks.get());
    }

    public boolean canSend(UUID source) {
        return this.isSourceCall() && this.isSource(source) && this.sender().canSend();
    }

    public boolean send(UUID source, @Nullable class_1799 held) {
        Sender sender = this.sender();
        if (!this.canSend(source)) {
            sender.playSoundAt(AITSounds.GROAN, 1.1f);
            return false;
        }
        this.send();
        if (held != null && held.method_7909() instanceof HypercubeItem) {
            held.method_7939(0);
        }
        sender.playSoundAt(AITSounds.BWEEP, 0.75f);
        return true;
    }

    private void send() {
        CompletableFuture<Void> future = CompletableFuture.supplyAsync(() -> {
            ServerTardisManager.getInstance().forEach(this::send);
            return null;
        });
    }

    private void send(ServerTardis target) {
        if (this.isSource(target.getUuid())) {
            return;
        }
        if (!((Boolean)target.stats().receiveCalls().get()).booleanValue()) {
            return;
        }
        TardisServerWorld world = target.world();
        class_243 pos = TardisUtil.offsetInteriorDoorPosition(target);
        class_1799 created = HypercubeItem.create(DistressCall.copyForSend(this, world.method_8503().method_3780()));
        class_1542 entity = new class_1542((class_1937)world, pos.method_10216(), pos.method_10214(), pos.method_10215(), created);
        world.method_8649((class_1297)entity);
        world.method_8396(null, class_2338.method_49638((class_2374)pos), AITSounds.DING, class_3419.field_15248, 1.0f, 1.0f);
    }

    public boolean isSource(UUID uuid) {
        return uuid.equals(this.sender().getUuid());
    }

    public class_2487 toNbt() {
        class_2487 data = new class_2487();
        data.method_10566("Sender", (class_2520)this.sender.toNbt());
        data.method_10582("Message", this.message);
        data.method_10569("Lifetime", this.lifetime);
        data.method_10569("CreationTime", this.creationTime);
        data.method_10556("IsSourceCall", this.isSourceCall);
        return data;
    }

    private static DistressCall fromNbt(Sender send, class_2487 data, int ticks) {
        return new DistressCall(send, data.method_10558("Message"), data.method_10550("Lifetime"), Math.min(ticks, data.method_10550("CreationTime")), data.method_10577("IsSourceCall"));
    }

    public static DistressCall fromNbt(class_2487 data, int ticks) {
        class_2487 sender = data.method_10562("Sender");
        if (sender.method_10545("Tardis")) {
            return DistressCall.fromTardisNbt(data, ticks);
        }
        if (sender.method_10545("Player")) {
            return DistressCall.fromPlayerNbt(data, ticks);
        }
        throw new IllegalStateException();
    }

    public static DistressCall fromTardisNbt(class_2487 data, int ticks) {
        return DistressCall.fromNbt(new TardisSender(data.method_10562("Sender").method_25926("Tardis")), data, ticks);
    }

    public static DistressCall fromPlayerNbt(class_2487 data, int ticks) {
        return DistressCall.fromNbt(new PlayerSender(data.method_10562("Sender").method_25926("Player")), data, ticks);
    }

    public static interface Sender {
        public class_2487 toNbt();

        public UUID getUuid();

        public CachedDirectedGlobalPos position();

        public class_2561 getTooltip();

        public void playSoundAt(class_3414 var1, float var2);

        default public void playSoundAt(class_3414 event) {
            this.playSoundAt(event, 1.0f);
        }

        public boolean canSend();
    }

    public static class TardisSender
    implements Sender {
        private final UUID id;
        private final TardisRef ref;

        public TardisSender(UUID id) {
            this.id = id;
            this.ref = TardisRef.createAs((class_1937)ServerLifecycleHooks.get().method_30002(), this.getUuid());
        }

        public TardisSender(Tardis tardis) {
            this(tardis.getUuid());
        }

        public TardisRef tardis() {
            return this.ref;
        }

        @Override
        public class_2487 toNbt() {
            class_2487 data = new class_2487();
            data.method_25927("Tardis", this.id);
            return data;
        }

        @Override
        public UUID getUuid() {
            return this.id;
        }

        @Override
        public CachedDirectedGlobalPos position() {
            if (this.tardis().isEmpty()) {
                return null;
            }
            return this.tardis().get().travel().position();
        }

        @Override
        public class_2561 getTooltip() {
            return TextUtil.forTardis(this.tardis().getId());
        }

        @Override
        public void playSoundAt(class_3414 event, float pitch) {
            if (this.tardis().isEmpty()) {
                return;
            }
            this.tardis().get().getDesktop().playSoundAtEveryConsole(event, class_3419.field_15245, 1.0f, pitch);
        }

        @Override
        public boolean canSend() {
            return this.tardis().isPresent() && this.tardis().get().travel().isLanded();
        }
    }

    public static class PlayerSender
    implements Sender {
        private final UUID id;
        private class_1657 playerCache;

        public PlayerSender(UUID id) {
            this.id = id;
        }

        public PlayerSender(class_1657 player) {
            this(player.method_5667());
        }

        @Override
        public class_2487 toNbt() {
            class_2487 data = new class_2487();
            data.method_25927("Player", this.id);
            return data;
        }

        @Override
        public UUID getUuid() {
            return this.id;
        }

        @Override
        public CachedDirectedGlobalPos position() {
            if (this.player() == null) {
                return CachedDirectedGlobalPos.create(ServerLifecycleHooks.get().method_30002(), class_2338.field_10980, (byte)0);
            }
            class_1937 class_19372 = this.player().method_37908();
            if (class_19372 instanceof TardisServerWorld) {
                TardisServerWorld tardisWorld = (TardisServerWorld)class_19372;
                return tardisWorld.getTardis().travel().position();
            }
            return CachedDirectedGlobalPos.create((class_3218)this.player().method_37908(), this.player().method_24515(), (byte)class_7718.method_45479((float)this.player().method_36454()));
        }

        @Override
        public class_2561 getTooltip() {
            class_5250 text = this.player() == null ? class_2561.method_43470((String)"???") : this.player().method_5476().method_27661();
            return text.method_27695(new class_124[]{class_124.field_1067, class_124.field_1060});
        }

        @Override
        public void playSoundAt(class_3414 event, float pitch) {
            this.position().getWorld().method_8396(null, this.position().getPos(), event, class_3419.field_15248, 1.0f, pitch);
        }

        @Override
        public boolean canSend() {
            return true;
        }

        public class_1657 player() {
            if (this.playerCache == null) {
                this.playerCache = this.findPlayer();
            }
            return this.playerCache;
        }

        private class_1657 findPlayer() {
            if (ServerLifecycleHooks.isServer()) {
                return ServerLifecycleHooks.get().method_3760().method_14602(this.getUuid());
            }
            return this.findClientPlayer();
        }

        @Environment(value=EnvType.CLIENT)
        private class_1657 findClientPlayer() {
            return class_310.method_1551().field_1687.method_18470(this.getUuid());
        }
    }
}

