/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.handler.mood;

import dev.amble.ait.AITMod;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.handler.mood.TardisMood;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_2960;

public interface MoodDictatedEvent {
    default public class_2960 id() {
        return AITMod.id("mood_dictated_event");
    }

    public void execute(ServerTardis var1);

    public int getCost();

    public Set<TardisMood.Moods> getMoodsList();

    public TardisMood.Alignment getMoodTypeCompatibility();

    public static class Builder
    implements MoodDictatedEvent {
        private final class_2960 id;
        private final ExecuteMoodEvent execute;
        private final int cost;
        private final Set<TardisMood.Moods> moodsList;
        private final TardisMood.Alignment alignmentCompatibility;

        public Builder(class_2960 id, ExecuteMoodEvent execute, int cost, TardisMood.Alignment alignment, TardisMood.Moods ... moods) {
            this.id = id;
            this.execute = execute;
            this.cost = cost;
            this.moodsList = new HashSet<TardisMood.Moods>(List.of(moods));
            this.alignmentCompatibility = alignment;
        }

        public static MoodDictatedEvent create(class_2960 id, ExecuteMoodEvent execute, int cost, TardisMood.Alignment alignment, TardisMood.Moods ... moods) {
            return new Builder(id, execute, cost, alignment, moods);
        }

        @Override
        public class_2960 id() {
            return this.id;
        }

        @Override
        public int getCost() {
            return this.cost;
        }

        @Override
        public void execute(ServerTardis tardis) {
            this.execute.run(tardis);
        }

        @Override
        public Set<TardisMood.Moods> getMoodsList() {
            return this.moodsList;
        }

        @Override
        public TardisMood.Alignment getMoodTypeCompatibility() {
            return this.alignmentCompatibility;
        }

        public static interface ExecuteMoodEvent {
            public void run(ServerTardis var1);
        }
    }
}

