/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.handler.mood;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;

public record TardisMood(Moods moods, Alignment alignment, int weight) {
    public static final Codec<TardisMood> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("mood").forGetter(tardismood -> Optional.of(tardismood.moods.toString())), (App)Codec.STRING.optionalFieldOf("type").forGetter(tardismood -> Optional.of(tardismood.moods.alignment().toString())), (App)Codec.INT.optionalFieldOf("weight").forGetter(tardisMood -> Optional.of(tardisMood.weight))).apply((Applicative)instance, TardisMood::deserialize));

    public static TardisMood deserialize(Moods mood, Optional<Integer> weight) {
        return new TardisMood(mood, mood.alignment(), weight.orElse(mood.weight()));
    }

    public static TardisMood deserialize(Optional<String> mood, Optional<String> type, Optional<Integer> level) {
        return TardisMood.deserialize(type.map(Moods::valueOf).orElse(null), level);
    }

    public static enum Moods {
        ANGRY(0, Alignment.NEGATIVE),
        HATEFUL(0, Alignment.NEGATIVE),
        FEARFUL(0, Alignment.NEGATIVE),
        DEPRESSED(0, Alignment.NEGATIVE),
        HURT(0, Alignment.NEGATIVE),
        UPSET(0, Alignment.NEGATIVE),
        FRUSTRATED(0, Alignment.NEGATIVE),
        JEALOUS(0, Alignment.NEGATIVE),
        DISAPPOINTED(0, Alignment.NEGATIVE),
        ANXIOUS(0, Alignment.NEGATIVE),
        TOLERANT(0, Alignment.NEUTRAL, -20),
        BORED(0, Alignment.NEUTRAL, -20),
        IMPASSIVE(0, Alignment.NEUTRAL, -20),
        CALM(0, Alignment.NEUTRAL, 20),
        MANIC(0, Alignment.NEUTRAL, -20),
        CURIOUS(0, Alignment.NEUTRAL, 20),
        LONELY(0, Alignment.NEUTRAL, -20),
        INDIFFERENT(0, Alignment.NEUTRAL, 0),
        MEDIOCRE(0, Alignment.NEUTRAL, 0),
        TIRED(0, Alignment.NEUTRAL, 10),
        HAPPY(0, Alignment.POSITIVE),
        EXCITED(0, Alignment.POSITIVE),
        COOPERATIVE(0, Alignment.POSITIVE),
        HOPEFUL(0, Alignment.POSITIVE),
        GRATEFUL(0, Alignment.POSITIVE),
        ENTHUSIASTIC(0, Alignment.POSITIVE),
        RELIEVED(0, Alignment.POSITIVE),
        CONTENT(0, Alignment.POSITIVE),
        OPTIMISTIC(0, Alignment.POSITIVE),
        JOYFUL(0, Alignment.POSITIVE);

        public static final Moods[] VALUES;
        public final int weight;
        public final Alignment type;
        public final int swayWeight;

        private Moods(int weight, Alignment type, int swayWeight) {
            this.weight = weight;
            this.type = type;
            this.swayWeight = swayWeight;
        }

        private Moods(int weight, Alignment type) {
            this(weight, type, 0);
        }

        public int weight() {
            return this.weight;
        }

        public Alignment alignment() {
            return this.type;
        }

        public int swayWeight() {
            return this.swayWeight;
        }

        static {
            VALUES = Moods.values();
        }
    }

    public static enum Alignment {
        POSITIVE,
        NEUTRAL,
        NEGATIVE;

    }
}

