/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.handler.permissions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import dev.amble.ait.core.tardis.handler.permissions.PermissionLike;
import dev.amble.ait.core.tardis.handler.permissions.PermissionWrapper;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;

public record Permission(String name, Permission parent, Map<String, Permission> children) implements PermissionLike
{
    public static final Permission LOOKUP = Permission.withChildren("tardis", null, base -> Permission.withChildren("use", base, USE.CONSOLE, USE.TRAVEL, USE.LINK), base -> Permission.withChildren("modify", base, MODIFY.PLACE, MODIFY.BREAK, MODIFY.INTERACT, MODIFY.CONTAINER, MODIFY.DESKTOP, MODIFY.EXTERIOR), base -> Permission.withChildren("special", base, SPECIAL.CLOAK, SPECIAL.SNAP));

    public static void collect(Collection<String> result, Permission root) {
        for (Permission permission : root.children.values()) {
            if (permission.children == null || permission.children.isEmpty()) {
                result.add(permission.getId());
                continue;
            }
            Permission.collect(result, permission);
        }
    }

    public static Collection<String> collect() {
        HashSet<String> result = new HashSet<String>();
        Permission.collect(result, LOOKUP);
        return result;
    }

    @SafeVarargs
    public static Permission withChildren(String name, Permission parent, Function<Permission, Permission> ... children) {
        Permission base = new Permission(name, parent, new HashMap<String, Permission>());
        for (Function<Permission, Permission> func : children) {
            Permission child = func.apply(base);
            base.children.put(child.name(), child);
        }
        return base;
    }

    public static Permission withChildren(String name, Permission parent, PermissionWrapper ... children) {
        Permission base = new Permission(name, parent, new HashMap<String, Permission>());
        for (PermissionWrapper wrapper : children) {
            wrapper.construct(base, null);
            base.children.put(wrapper.getName(), wrapper.get());
        }
        return base;
    }

    @Override
    public String getId() {
        Object base = "";
        if (this.parent != null) {
            base = this.parent.getId() + ".";
        }
        return (String)base + this.name;
    }

    public static Permission from(String id) {
        String[] parts = id.split("\\.");
        Permission node = LOOKUP;
        for (int i = 1; i < parts.length; ++i) {
            node = node.children.get(parts[i]);
            if (node != null) continue;
            return null;
        }
        return node;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof PermissionWrapper) {
            PermissionWrapper wrapper = (PermissionWrapper)obj;
            return wrapper.equals(this);
        }
        if (obj instanceof Permission) {
            Permission other = (Permission)obj;
            return this == other;
        }
        return false;
    }

    @Override
    public String toString() {
        return this.getId();
    }

    @Override
    public int hashCode() {
        return this.getId().hashCode();
    }

    public static Object serializer() {
        return new Serializer();
    }

    private static class Serializer
    implements JsonDeserializer<PermissionLike>,
    JsonSerializer<PermissionLike> {
        private Serializer() {
        }

        public PermissionLike deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Permission.from(json.getAsString());
        }

        public JsonElement serialize(PermissionLike permission, Type type, JsonSerializationContext jsonSerializationContext) {
            return new JsonPrimitive(permission.getId());
        }
    }

    public static interface SPECIAL {
        public static final PermissionWrapper CLOAK = new PermissionWrapper("cloak");
        public static final PermissionWrapper SNAP = new PermissionWrapper("snap");
    }

    public static interface MODIFY {
        public static final PermissionWrapper PLACE = new PermissionWrapper("place");
        public static final PermissionWrapper BREAK = new PermissionWrapper("break");
        public static final PermissionWrapper INTERACT = new PermissionWrapper("break");
        public static final PermissionWrapper CONTAINER = new PermissionWrapper("container");
        public static final PermissionWrapper DESKTOP = new PermissionWrapper("desktop");
        public static final PermissionWrapper EXTERIOR = new PermissionWrapper("exterior");
    }

    public static interface USE {
        public static final PermissionWrapper CONSOLE = new PermissionWrapper("console");
        public static final PermissionWrapper TRAVEL = new PermissionWrapper("travel");
        public static final PermissionWrapper LINK = new PermissionWrapper("link");
    }
}

