/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.handler.travel;

import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.client.tardis.manager.ClientTardisManager;
import dev.amble.ait.core.tardis.animation.v2.AnimationHolder;
import dev.amble.ait.core.tardis.animation.v2.TardisAnimation;
import dev.amble.ait.core.tardis.animation.v2.TardisAnimationMap;
import dev.amble.ait.core.tardis.animation.v2.datapack.TardisAnimationRegistry;
import dev.amble.ait.core.tardis.handler.travel.ProgressiveTravelHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;
import dev.amble.ait.data.Exclude;
import dev.amble.ait.data.properties.Property;
import dev.amble.ait.data.properties.Value;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public abstract class AnimatedTravelHandler
extends ProgressiveTravelHandler {
    private static final Property<class_2960> DEMAT_FX = new Property<class_2960>(Property.IDENTIFIER, "demat_fx", TardisAnimationRegistry.DEFAULT_DEMAT);
    private static final Property<class_2960> MAT_FX = new Property<class_2960>(Property.IDENTIFIER, "mat_fx", TardisAnimationRegistry.DEFAULT_MAT);
    private final Value<class_2960> dematId = DEMAT_FX.create((class_2960)this);
    private final Value<class_2960> matId = MAT_FX.create((class_2960)this);
    @Exclude
    private boolean isAnimationInvalidated;
    @Exclude
    private AnimationHolder animations;

    @Environment(value=EnvType.CLIENT)
    public static void initClient() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)AnimationHolder.UPDATE_PACKET, (client, handler, buf, responseSender) -> {
            TravelHandlerBase.State state = (TravelHandlerBase.State)buf.method_10818(TravelHandlerBase.State.class);
            class_2960 id = buf.method_10810();
            UUID uuid = buf.method_10790();
            ClientTardisManager.getInstance().getTardis(uuid, tardis -> {
                if (state == TravelHandlerBase.State.LANDED) {
                    tardis.travel().setTemporaryAnimation(id);
                    return;
                }
                tardis.travel().getAnimations().onStateChange(state);
            });
        });
    }

    public AnimatedTravelHandler(TardisComponent.Id id) {
        super(id);
    }

    @Override
    public void postInit(TardisComponent.InitContext ctx) {
        super.postInit(ctx);
        this.dematId.addListener(id -> this.invalidateAnimations());
        this.matId.addListener(id -> this.invalidateAnimations());
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.dematId.of(this, DEMAT_FX);
        this.matId.of(this, MAT_FX);
    }

    @Override
    public void tick(MinecraftServer server) {
        super.tick(server);
        TravelHandlerBase.State state = this.getState();
        if (this.shouldTickAnimation()) {
            this.tickAnimationProgress(server, state);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void tick(class_310 client) {
        super.tick(client);
        if (this.shouldTickAnimation()) {
            this.getAnimations().tick(client);
        }
    }

    protected void tickAnimationProgress(MinecraftServer server, TravelHandlerBase.State state) {
        if (!this.getAnimations().isRunning() && this.isAnimationInvalidated) {
            this.animations = null;
        }
        this.getAnimations().tick(server);
        if (state == TravelHandlerBase.State.LANDED) {
            return;
        }
        if (!this.getAnimations().isAged()) {
            return;
        }
        AnimatedTravelHandler animatedTravelHandler = this;
        if (animatedTravelHandler instanceof TravelHandler) {
            TravelHandler handler = (TravelHandler)animatedTravelHandler;
            state.finish(handler);
        }
    }

    private void invalidateAnimations() {
        if (this.getState().animated()) {
            if (this.getState() == TravelHandlerBase.State.LANDED && !this.getAnimations().isRunning()) {
                this.animations = null;
                return;
            }
            this.isAnimationInvalidated = true;
            return;
        }
        this.animations = null;
    }

    public float getAlpha() {
        return this.getAlpha(0.0f);
    }

    public Vector3f getScale() {
        return this.getScale(0.0f);
    }

    public Vector3f getAnimationPosition() {
        return this.getAnimationPosition(0.0f);
    }

    public Vector3f getAnimationRotation() {
        return this.getAnimationRotation(0.0f);
    }

    public float getAlpha(float delta) {
        return this.getAnimations().getAlpha(delta);
    }

    public Vector3f getScale(float delta) {
        return this.getAnimations().getScale(delta);
    }

    public Vector3f getAnimationPosition(float delta) {
        return this.getAnimations().getPosition(delta);
    }

    public Vector3f getAnimationRotation(float delta) {
        return this.getAnimations().getRotation(delta);
    }

    public boolean isHitboxShown() {
        return this.getAlpha() > 0.5f && this.getScale().equals(1.0f, 1.0f, 1.0f) && this.getAnimationPosition().equals(0.0f, 0.0f, 0.0f) && this.getAnimationRotation().equals(0.0f, 0.0f, 0.0f);
    }

    public AnimationHolder getAnimations() {
        if (this.animations == null) {
            this.animations = this.tardis() != null ? new AnimationHolder(this.tardis()) : new AnimationHolder(new TardisAnimationMap());
            this.animations.onStateChange(this.getState());
        }
        return this.animations;
    }

    @Nullable
    public class_2960 getAnimationIdFor(TravelHandlerBase.State state) {
        return switch (state) {
            default -> throw new IncompatibleClassChangeError();
            case TravelHandlerBase.State.LANDED, TravelHandlerBase.State.FLIGHT -> null;
            case TravelHandlerBase.State.DEMAT -> this.dematId.get();
            case TravelHandlerBase.State.MAT -> this.matId.get();
        };
    }

    protected TardisAnimation getAnimationFor(TravelHandlerBase.State state) {
        return (TardisAnimation)TardisAnimationRegistry.getInstance().getOrFallback(this.getAnimationIdFor(state));
    }

    public void setAnimationFor(TravelHandlerBase.State state, class_2960 id) {
        switch (state) {
            case DEMAT: {
                this.dematId.set(id);
                break;
            }
            case MAT: {
                this.matId.set(id);
            }
        }
        this.invalidateAnimations();
    }

    public boolean setTemporaryAnimation(class_2960 animId) {
        TardisAnimation anim = (TardisAnimation)TardisAnimationRegistry.getInstance().getOrFallback(animId);
        return this.getAnimations().setAnimation(anim);
    }

    @Override
    protected void setState(TravelHandlerBase.State state) {
        super.setState(state);
        this.getAnimations().onStateChange(state);
    }

    public void onAnimationComplete(Runnable runnable) {
        this.getAnimations().onDone().thenRun(runnable);
    }

    public abstract boolean shouldTickAnimation();

    static {
        if (EnvType.CLIENT == FabricLoader.getInstance().getEnvironmentType()) {
            AnimatedTravelHandler.initClient();
        }
    }
}

