/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.handler.travel;

import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.TardisEvents;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.TardisDesktop;
import dev.amble.ait.core.tardis.handler.ServerAlarmHandler;
import dev.amble.ait.core.tardis.handler.TardisCrashHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;
import dev.amble.ait.core.world.TardisServerWorld;
import dev.amble.ait.data.properties.bool.BoolValue;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import dev.drtheo.queue.api.ActionQueue;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface CrashableTardisTravel {
    public Tardis tardis();

    public TravelHandlerBase.State getState();

    public void resetHammerUses();

    public int getHammerUses();

    public boolean isCrashing();

    public void setCrashing(boolean var1);

    public int speed();

    public void speed(int var1);

    public BoolValue antigravs();

    public Optional<ActionQueue> forceRemat();

    public CachedDirectedGlobalPos position();

    public CachedDirectedGlobalPos getProgress();

    public void destination(CachedDirectedGlobalPos var1);

    default public void crash() {
        if (this.getState() != TravelHandlerBase.State.FLIGHT || this.isCrashing()) {
            return;
        }
        Tardis tardis = this.tardis();
        int power = this.speed() + this.getHammerUses() + 1;
        if (tardis.sequence().hasActiveSequence()) {
            tardis.sequence().setActiveSequence(null, true);
        }
        TardisServerWorld world = tardis.asServer().world();
        tardis.getDesktop().getConsolePos().forEach(console -> this.startCrashEffects(tardis, (class_2338)console));
        Random random = AITMod.RANDOM;
        for (class_3222 player : world.method_18456()) {
            float xVel = random.nextFloat(-2.0f, 3.0f);
            float yVel = random.nextFloat(-1.0f, 2.0f);
            float zVel = random.nextFloat(-2.0f, 3.0f);
            player.method_18800((double)(xVel * (float)power), (double)(yVel * (float)power), (double)(zVel * (float)power));
            player.method_6092(new class_1293(class_1294.field_5919, 40 * power, 1, true, false, false));
            player.method_6092(new class_1293(class_1294.field_5911, 40 * power, 1, true, false, false));
            player.method_6092(new class_1293(class_1294.field_5916, 40 * power, 2, true, false, false));
            int damage = (int)Math.round(0.5 * (double)power);
            player.method_5643(world.method_48963().method_48830(), (float)damage);
        }
        tardis.door().setLocked(true);
        tardis.alarm().enable(ServerAlarmHandler.AlarmType.CRASHING);
        this.antigravs().set(false);
        this.speed(0);
        tardis.removeFuel(700 * power);
        this.resetHammerUses();
        this.setCrashing(true);
        this.forceRemat();
        int repairTicks = 1200 * power;
        tardis.crash().setRepairTicks(repairTicks);
        if (repairTicks > TardisCrashHandler.UNSTABLE_TICK_START_THRESHOLD) {
            tardis.crash().setState(TardisCrashHandler.State.TOXIC);
        } else {
            tardis.crash().setState(TardisCrashHandler.State.UNSTABLE);
        }
        ((TardisEvents.Crash)TardisEvents.CRASH.invoker()).onCrash(tardis);
    }

    default public void startCrashEffects(Tardis tardis, class_2338 console) {
        TardisServerWorld world = tardis.asServer().world();
        TardisDesktop.playSoundAtConsole((class_1937)world, console, class_3417.field_15152, class_3419.field_15245, 3.0f, 1.0f);
    }
}

