/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.handler.travel;

import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.api.tardis.TardisEvents;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.control.sequences.SequenceHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;
import dev.amble.ait.core.tardis.handler.travel.TravelUtil;
import dev.amble.ait.data.properties.bool.BoolProperty;
import dev.amble.ait.data.properties.bool.BoolValue;
import dev.amble.ait.data.properties.integer.IntProperty;
import dev.amble.ait.data.properties.integer.IntValue;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.server.MinecraftServer;

public abstract class ProgressiveTravelHandler
extends TravelHandlerBase {
    private static final class_5819 random = class_5819.method_43047();
    private static final IntProperty FLIGHT_TICKS = new IntProperty("flight_ticks");
    private static final IntProperty TARGET_TICKS = new IntProperty("target_ticks");
    private static final BoolProperty HANDBRAKE = new BoolProperty("handbrake", true);
    private static final BoolProperty AUTOPILOT = new BoolProperty("autopilot", false);
    private final IntValue flightTicks = FLIGHT_TICKS.create(this);
    private final IntValue targetTicks = TARGET_TICKS.create(this);
    protected final BoolValue handbrake = HANDBRAKE.create(this);
    protected final BoolValue autopilot = AUTOPILOT.create(this);

    public ProgressiveTravelHandler(TardisComponent.Id id) {
        super(id);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.flightTicks.of(this, FLIGHT_TICKS);
        this.targetTicks.of(this, TARGET_TICKS);
        this.handbrake.of(this, HANDBRAKE);
        this.autopilot.of(this, AUTOPILOT);
    }

    private boolean isInFlight() {
        return this.getState() == TravelHandlerBase.State.FLIGHT || this.getState() == TravelHandlerBase.State.MAT;
    }

    private boolean isFlightTicking() {
        return this.tardis.travel().getState() == TravelHandlerBase.State.FLIGHT && this.getTargetTicks() != 0;
    }

    public boolean hasFinishedFlight() {
        return this.getFlightTicks() >= this.getTargetTicks() || this.getTargetTicks() == 0 || this.tardis.travel().isCrashing();
    }

    @Override
    public void forceDestination(CachedDirectedGlobalPos cached) {
        super.forceDestination(cached);
        this.recalculate();
    }

    public void increaseFlightTime(int ticks) {
        this.setTargetTicks(this.getTargetTicks() + ticks);
    }

    public void decreaseFlightTime(int ticks) {
        this.setTargetTicks(this.getTargetTicks() - ticks);
    }

    public int getDurationAsPercentage() {
        if (this.getTargetTicks() == 0 || this.getFlightTicks() == 0) {
            return this.getState() == TravelHandlerBase.State.DEMAT ? 0 : 100;
        }
        int target = this.getTargetTicks();
        int flightTicksClamped = class_3532.method_15340((int)this.getFlightTicks(), (int)1, (int)target);
        int percentage = flightTicksClamped * 100 / target;
        return Math.max(0, percentage);
    }

    public CachedDirectedGlobalPos getProgress() {
        return TravelUtil.getPositionFromPercentage(this.position(), this.destination(), this.getDurationAsPercentage());
    }

    public void recalculate() {
        this.setTargetTicks(TravelUtil.getFlightDuration(this.position(), this.destination()));
        this.setFlightTicks(this.isInFlight() ? class_3532.method_15340((int)this.getFlightTicks(), (int)0, (int)this.getTargetTicks()) : 0);
    }

    protected void startFlight() {
        this.setFlightTicks(0);
        this.setTargetTicks(TravelUtil.getFlightDuration(this.position(), this.destination()));
    }

    protected void resetFlight() {
        this.setFlightTicks(0);
        this.setTargetTicks(0);
    }

    public int getFlightTicks() {
        return (Integer)this.flightTicks.get();
    }

    public void setFlightTicks(int ticks) {
        this.flightTicks.set(ticks);
    }

    public int getTargetTicks() {
        return (Integer)this.targetTicks.get();
    }

    protected void setTargetTicks(int ticks) {
        this.targetTicks.set(ticks);
    }

    public void handbrake(boolean value) {
        this.handbrake.set(value);
    }

    public boolean handbrake() {
        return (Boolean)this.handbrake.get();
    }

    public boolean autopilot() {
        return (Boolean)this.autopilot.get();
    }

    public void autopilot(boolean value) {
        this.autopilot.set(value);
        int speed = (Integer)this.speed.get();
        int expectedSpeed = this.clampSpeed(speed);
        if (expectedSpeed != speed) {
            this.speed.set(expectedSpeed);
        }
    }

    public void increaseSpeed() {
        this.speed((Integer)this.speed.get() + 1);
    }

    public void decreaseSpeed() {
        if (this.getState() == TravelHandlerBase.State.LANDED && (Integer)this.speed.get() == 1) {
            this.tardis.getDesktop().playSoundAtEveryConsole(AITSounds.THROTTLE_SNAP, class_3419.field_15256);
        }
        this.speed((Integer)this.speed.get() - 1);
    }

    @Override
    protected int clampSpeed(int value) {
        int max;
        int n = max = this.autopilot() ? 1 : (Integer)this.maxSpeed.get();
        if (!this.tardis.subsystems().stabilisers().isEnabled()) {
            max = 3;
        }
        return class_3532.method_15340((int)value, (int)0, (int)max);
    }

    @Override
    public void tick(MinecraftServer server) {
        super.tick(server);
        if ((this.getTargetTicks() > 0 || this.getFlightTicks() > 0) && this.getState() == TravelHandlerBase.State.LANDED) {
            this.recalculate();
        }
        if (this.isInFlight() && !this.isCrashing() && this.getTargetTicks() == 0 && this.getFlightTicks() < this.getTargetTicks()) {
            this.recalculate();
        }
        if (server.method_3780() % 2 == 0 && !this.tardis().flight().isFlying()) {
            this.triggerSequencingDuringFlight(this.tardis);
        }
        if (!this.isFlightTicking()) {
            return;
        }
        if (this.hasFinishedFlight()) {
            boolean shouldRemat;
            this.tardis.getDesktop().playSoundAtEveryConsole(class_3417.field_19167);
            this.resetFlight();
            boolean bl = shouldRemat = ((TardisEvents.FinishFlight)TardisEvents.FINISH_FLIGHT.invoker()).onFinish(this.tardis.asServer()) == TardisEvents.Interaction.SUCCESS;
            if (shouldRemat) {
                this.tardis.travel().rematerialize();
            }
            return;
        }
        if (server.method_3780() % ((Integer)this.maxSpeed.get() - this.speed() + 1) == 0) {
            this.setFlightTicks(this.getFlightTicks() + AITMod.CONFIG.travelPerTick + this.instability() - 1);
        }
    }

    public void triggerSequencingDuringFlight(Tardis tardis) {
        SequenceHandler sequences = tardis.sequence();
        if (!(((Boolean)this.autopilot.get()).booleanValue() || this.getDurationAsPercentage() >= 100 || this.getState() != TravelHandlerBase.State.FLIGHT || sequences.hasActiveSequence() || this.position().equals((Object)this.destination()) || this.getTargetTicks() <= 100 || random.method_39332(0, 110 / (this.speed() == 0 ? 1 : this.speed())) != 7)) {
            sequences.triggerRandomSequence(true);
        }
    }
}

