/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.handler.travel;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import dev.amble.ait.api.tardis.KeyedTardisComponent;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.api.tardis.TardisTickable;
import dev.amble.ait.core.tardis.handler.TardisCrashHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandler;
import dev.amble.ait.core.util.SafePosSearch;
import dev.amble.ait.core.util.WorldUtil;
import dev.amble.ait.data.Exclude;
import dev.amble.ait.data.enummap.Ordered;
import dev.amble.ait.data.properties.Property;
import dev.amble.ait.data.properties.Value;
import dev.amble.ait.data.properties.bool.BoolProperty;
import dev.amble.ait.data.properties.bool.BoolValue;
import dev.amble.ait.data.properties.integer.IntProperty;
import dev.amble.ait.data.properties.integer.IntValue;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2338;
import net.minecraft.class_2784;
import net.minecraft.class_3532;
import net.minecraft.class_5699;
import net.minecraft.server.MinecraftServer;

public abstract class TravelHandlerBase
extends KeyedTardisComponent
implements TardisTickable {
    private static final Property<State> STATE = Property.forEnum("state", State.class, State.LANDED);
    private static final BoolProperty LEAVE_BEHIND = new BoolProperty("leave_behind", false);
    private static final Property<CachedDirectedGlobalPos> POSITION = new Property<CachedDirectedGlobalPos>(Property.CDIRECTED_GLOBAL_POS, "position", (CachedDirectedGlobalPos)null);
    private static final Property<CachedDirectedGlobalPos> DESTINATION = new Property<CachedDirectedGlobalPos>(Property.CDIRECTED_GLOBAL_POS, "destination", (CachedDirectedGlobalPos)null);
    private static final Property<CachedDirectedGlobalPos> PREVIOUS_POSITION = new Property<CachedDirectedGlobalPos>(Property.CDIRECTED_GLOBAL_POS, "previous_position", (CachedDirectedGlobalPos)null);
    private static final BoolProperty CRASHING = new BoolProperty("crashing", false);
    private static final BoolProperty ANTIGRAVS = new BoolProperty("antigravs", false);
    private static final IntProperty SPEED = new IntProperty("speed", 0);
    private static final IntProperty MAX_SPEED = new IntProperty("max_speed", 7);
    private static final Property<SafePosSearch.Kind> VGROUND_SEARCH = Property.forEnum("vground_search", SafePosSearch.Kind.class, SafePosSearch.Kind.CEILING);
    private static final BoolProperty HGROUND_SEARCH = new BoolProperty("hground_search", true);
    protected final Value<State> state = STATE.create((State)((Object)this));
    protected final Value<CachedDirectedGlobalPos> position = POSITION.create((CachedDirectedGlobalPos)((Object)this));
    protected final Value<CachedDirectedGlobalPos> destination = DESTINATION.create((CachedDirectedGlobalPos)((Object)this));
    protected final Value<CachedDirectedGlobalPos> previousPosition = PREVIOUS_POSITION.create((CachedDirectedGlobalPos)((Object)this));
    private final BoolValue leaveBehind = LEAVE_BEHIND.create(this);
    protected final BoolValue crashing = CRASHING.create(this);
    protected final BoolValue antigravs = ANTIGRAVS.create(this);
    protected final IntValue speed = SPEED.create(this);
    protected final IntValue maxSpeed = MAX_SPEED.create(this);
    protected final Value<SafePosSearch.Kind> vGroundSearch = VGROUND_SEARCH.create((SafePosSearch.Kind)((Object)this));
    protected final BoolValue hGroundSearch = HGROUND_SEARCH.create(this);
    @Exclude(strategy=Exclude.Strategy.NETWORK)
    protected int hammerUses = 0;

    public TravelHandlerBase(TardisComponent.Id id) {
        super(id);
    }

    @Override
    public void onLoaded() {
        this.state.of(this, STATE);
        this.position.of(this, POSITION);
        this.destination.of(this, DESTINATION);
        this.previousPosition.of(this, PREVIOUS_POSITION);
        this.leaveBehind.of(this, LEAVE_BEHIND);
        this.speed.of(this, SPEED);
        this.maxSpeed.of(this, MAX_SPEED);
        this.crashing.of(this, CRASHING);
        this.antigravs.of(this, ANTIGRAVS);
        this.vGroundSearch.of(this, VGROUND_SEARCH);
        this.hGroundSearch.of(this, HGROUND_SEARCH);
        this.hammerUses = Math.max(this.hammerUses, 1);
    }

    @Override
    public void postInit(TardisComponent.InitContext ctx) {
        if (this.isClient()) {
            return;
        }
        MinecraftServer current = TravelHandlerBase.server();
        this.position.ifPresent(cached -> cached.init(current), false);
        this.destination.ifPresent(cached -> cached.init(current), false);
        this.previousPosition.ifPresent(cached -> cached.init(current), false);
    }

    @Override
    public void tick(MinecraftServer server) {
        TardisCrashHandler crash = this.tardis.crash();
        if (crash.getState() != TardisCrashHandler.State.NORMAL) {
            crash.addRepairTicks(2 * this.speed());
        }
        if (server.method_3780() % 200 == 0 && this.hammerUses > 0) {
            --this.hammerUses;
        }
    }

    public BoolValue leaveBehind() {
        return this.leaveBehind;
    }

    public void speed(int value) {
        this.speed.set(this.clampSpeed(value));
    }

    public int speed() {
        return (Integer)this.speed.get();
    }

    protected int clampSpeed(int value) {
        return class_3532.method_15340((int)value, (int)0, (int)((Integer)this.maxSpeed.get()));
    }

    public IntValue maxSpeed() {
        return this.maxSpeed;
    }

    public State getState() {
        return this.state.get();
    }

    protected void setState(State state) {
        this.state.set(state);
    }

    public CachedDirectedGlobalPos position() {
        return this.position.get();
    }

    public BoolValue antigravs() {
        return this.antigravs;
    }

    public boolean isCrashing() {
        return (Boolean)this.crashing.get();
    }

    public void setCrashing(boolean crashing) {
        this.crashing.set(crashing);
    }

    public int getHammerUses() {
        return this.hammerUses;
    }

    public int instability() {
        return this.getHammerUses() + 1;
    }

    public void useHammer() {
        ++this.hammerUses;
    }

    public void resetHammerUses() {
        this.hammerUses = 0;
    }

    public void forcePosition(CachedDirectedGlobalPos cached) {
        cached.init(TravelHandlerBase.server());
        this.previousPosition.set((CachedDirectedGlobalPos)((Object)this.position));
        this.position.set(cached);
    }

    public void forcePosition(Function<CachedDirectedGlobalPos, CachedDirectedGlobalPos> position) {
        this.forcePosition(position.apply(this.position()));
    }

    public CachedDirectedGlobalPos destination() {
        return this.destination.get();
    }

    public void destination(CachedDirectedGlobalPos cached) {
        this.destination(cached, false);
    }

    public void destination(CachedDirectedGlobalPos cached, boolean force) {
        if (!force && this.destination().equals((Object)cached)) {
            return;
        }
        cached.init(TravelHandlerBase.server());
        class_2338 pos = cached.getPos();
        class_2784 targetBorder = new class_2784();
        targetBorder.method_11969(cached.getWorld().method_8621().method_11965() - 3.0);
        cached = targetBorder.method_11952(pos) ? cached : cached.pos(targetBorder.method_39538((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()));
        this.forceDestination(cached);
    }

    public void forceDestination(CachedDirectedGlobalPos cached) {
        cached.init(TravelHandlerBase.server());
        this.destination.set(cached);
    }

    public void destination(Function<CachedDirectedGlobalPos, CachedDirectedGlobalPos> position) {
        this.destination(position.apply(this.destination()));
    }

    public void forceDestination(Function<CachedDirectedGlobalPos, CachedDirectedGlobalPos> position) {
        this.forceDestination(position.apply(this.destination()));
    }

    public CachedDirectedGlobalPos previousPosition() {
        return this.previousPosition.get();
    }

    public BoolValue horizontalSearch() {
        return this.hGroundSearch;
    }

    public Value<SafePosSearch.Kind> verticalSearch() {
        return this.vGroundSearch;
    }

    protected static MinecraftServer server() {
        return WorldUtil.getOverworld().method_8503();
    }

    public static enum State implements Ordered
    {
        LANDED(null),
        DEMAT(TravelHandler::finishDemat),
        FLIGHT(null, false),
        MAT(TravelHandler::finishRemat);

        public static final Codec<State> CODEC;
        private final boolean animated;
        private final Consumer<TravelHandler> finish;

        private State(Consumer<TravelHandler> finish) {
            this(finish, true);
        }

        private State(Consumer<TravelHandler> finish, boolean animated) {
            this.animated = animated;
            this.finish = finish;
        }

        public boolean animated() {
            return this.animated;
        }

        public void finish(TravelHandler handler) {
            if (this.finish == null) {
                return;
            }
            this.finish.accept(handler);
        }

        @Override
        public int index() {
            return this.ordinal();
        }

        static {
            CODEC = class_5699.field_41759.flatXmap(s -> {
                try {
                    return DataResult.success((Object)State.valueOf(s.toUpperCase()));
                }
                catch (Exception e) {
                    return DataResult.error(() -> "Invalid state: " + s + "! | " + e.getMessage());
                }
            }, var -> DataResult.success((Object)var.toString()));
        }
    }
}

