/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.manager;

import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.KeyedTardisComponent;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.api.tardis.TardisEvents;
import dev.amble.ait.api.tardis.WorldWithTardis;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.manager.TardisBuilder;
import dev.amble.ait.core.tardis.manager.old.DeprecatedServerTardisManager;
import dev.amble.ait.core.tardis.util.NetworkUtil;
import dev.amble.ait.data.properties.Value;
import dev.amble.ait.registry.impl.TardisComponentRegistry;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1923;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class ServerTardisManager
extends DeprecatedServerTardisManager {
    private static ServerTardisManager instance;
    private final Set<ServerTardis> delta = new HashSet<ServerTardis>();

    public static void init() {
        instance = new ServerTardisManager();
    }

    private ServerTardisManager() {
        TardisEvents.SYNC_TARDIS.register((Object)WorldWithTardis.forSync((player, tardisSet) -> {
            if (this.fileManager.isLocked()) {
                return;
            }
            if (AITMod.CONFIG.sendBulk && tardisSet.size() >= 8) {
                this.sendTardisBulk(player, tardisSet);
                return;
            }
            this.sendTardisAll(player, tardisSet);
        }));
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> this.sendTardisAll(handler.method_32311(), NetworkUtil.findLinkedItems(handler.method_32311())));
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            if (this.fileManager.isLocked()) {
                return;
            }
            for (ServerTardis tardis : this.delta) {
                if (ServerTardisManager.isInvalid(tardis) || !tardis.hasDelta()) continue;
                class_2540 buf = this.prepareSendDelta(tardis);
                tardis.consumeDelta(component -> this.writeComponent((TardisComponent)component, buf));
                NetworkUtil.getSubscribedPlayers(tardis).forEach((? super T watching) -> ServerPlayNetworking.send((class_3222)watching, (class_2960)SEND_COMPONENT, (class_2540)buf));
            }
            this.delta.clear();
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SEND_PROPERTY, (server, player, networkHandler, buf, response) -> {
            UUID tardisId = buf.method_10790();
            ServerTardis tardis = this.demandTardis(server, tardisId);
            if (tardis == null) {
                return;
            }
            TardisComponent.IdLike componentId = TardisComponentRegistry.getInstance().get(buf.method_19772());
            Object patt0$temp = tardis.handler(componentId);
            if (!(patt0$temp instanceof KeyedTardisComponent)) {
                return;
            }
            KeyedTardisComponent keyed = (KeyedTardisComponent)patt0$temp;
            String propertyId = buf.method_19772();
            ((Value)keyed.getPropertyData().get(propertyId)).read(buf);
        });
    }

    @Override
    public ServerTardis create(TardisBuilder builder) {
        if (this.isFull()) {
            return null;
        }
        ServerTardis result = super.create(builder);
        this.sendTardisAll(Set.of(result));
        return result;
    }

    private void sendTardis(class_3222 player, class_2540 data) {
        ServerPlayNetworking.send((class_3222)player, (class_2960)SEND, (class_2540)data);
    }

    private void writeSend(ServerTardis tardis, class_2540 buf) {
        buf.method_10797(tardis.getUuid());
        buf.method_10814(this.networkGson.toJson((Object)tardis, ServerTardis.class));
    }

    private void writeComponent(TardisComponent component, class_2540 buf) {
        String rawId = TardisComponentRegistry.getInstance().get(component);
        buf.method_10814(rawId);
        buf.method_10814(this.networkGson.toJson((Object)component));
    }

    private class_2540 prepareSend(ServerTardis tardis) {
        class_2540 data = PacketByteBufs.create();
        this.writeSend(tardis, data);
        return data;
    }

    private class_2540 prepareSendDelta(ServerTardis tardis) {
        class_2540 data = PacketByteBufs.create();
        data.method_10797(tardis.getUuid());
        data.writeShort(tardis.getDeltaSize());
        return data;
    }

    protected void sendTardisBulk(class_3222 player, Set<ServerTardis> set) {
        class_2540 data = PacketByteBufs.create();
        data.writeInt(set.size());
        for (ServerTardis tardis : set) {
            if (ServerTardisManager.isInvalid(tardis)) continue;
            this.writeSend(tardis, data);
        }
        ServerPlayNetworking.send((class_3222)player, (class_2960)SEND_BULK, (class_2540)data);
    }

    protected void sendTardisAll(class_3222 player, Set<ServerTardis> set) {
        for (ServerTardis tardis : set) {
            if (ServerTardisManager.isInvalid(tardis)) continue;
            ((TardisEvents.SendTardis)TardisEvents.SEND_TARDIS.invoker()).send(tardis, player);
            this.sendTardis(player, this.prepareSend(tardis));
        }
    }

    protected void sendTardisAll(Set<ServerTardis> set) {
        for (ServerTardis tardis : set) {
            if (ServerTardisManager.isInvalid(tardis)) continue;
            class_2540 buf = this.prepareSend(tardis);
            NetworkUtil.getSubscribedPlayers(tardis).forEach((? super T watching) -> {
                ((TardisEvents.SendTardis)TardisEvents.SEND_TARDIS.invoker()).send(tardis, (class_3222)watching);
                this.sendTardis((class_3222)watching, buf);
            });
        }
    }

    public void mark(class_3218 world, ServerTardis tardis, class_1923 chunk) {
        ((WorldWithTardis)world).ait$lookup().put(chunk, tardis);
        NetworkUtil.getSubscribedPlayers(tardis).forEach((? super T player) -> ((TardisEvents.SyncTardis)TardisEvents.SYNC_TARDIS.invoker()).sync((class_3222)player, chunk));
    }

    public void unmark(class_3218 world, ServerTardis tardis, class_1923 chunk) {
        ((WorldWithTardis)world).ait$withLookup(lookup -> lookup.remove(chunk, tardis));
    }

    @Override
    public void markComponentDirty(TardisComponent component) {
        if (this.fileManager.isLocked()) {
            return;
        }
        Tardis tardis = component.tardis();
        if (!(tardis instanceof ServerTardis)) {
            return;
        }
        ServerTardis tardis2 = (ServerTardis)tardis;
        if (ServerTardisManager.isInvalid(tardis2)) {
            return;
        }
        tardis2.markDirty(component);
        this.delta.add(tardis2);
    }

    @Override
    public void markPropertyDirty(ServerTardis tardis, Value<?> value) {
        this.markComponentDirty(value.getHolder());
    }

    @Override
    public void reset() {
        this.delta.clear();
        super.reset();
    }

    public boolean isFull() {
        int max = AITMod.CONFIG.maxTardises;
        return max > 0 && this.lookup.size() >= max;
    }

    private static boolean isInvalid(ServerTardis tardis) {
        return tardis == null || tardis.isRemoved();
    }

    public static ServerTardisManager getInstance() {
        return instance;
    }

    private /* synthetic */ void lambda$new$2(class_3222 player, Set tardisSet) {
        for (ServerTardis tardis : tardisSet) {
            if (ServerTardisManager.isInvalid(tardis)) continue;
            this.sendTardisRemoval(player, tardis);
        }
    }
}

