/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.manager;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Either;
import dev.amble.ait.AITMod;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.TardisManager;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class TardisFileManager<T extends Tardis> {
    private boolean locked = false;

    public void delete(MinecraftServer server, UUID uuid) {
        try {
            Files.deleteIfExists(TardisFileManager.getSavePath(server, uuid, "json"));
        }
        catch (IOException e) {
            AITMod.LOGGER.error("Failed to delete TARDIS {}", (Object)uuid, (Object)e);
        }
    }

    private static Path getRootSavePath(Path root) {
        return root.resolve(".ait");
    }

    public static Path getRootSavePath(MinecraftServer server) {
        return TardisFileManager.getRootSavePath(server.method_27050(class_5218.field_24188));
    }

    private static Path getSavePath(MinecraftServer server, UUID uuid, String suffix) throws IOException {
        Path result = TardisFileManager.getRootSavePath(server).resolve(uuid.toString() + "." + suffix);
        Files.createDirectories(result.getParent(), new FileAttribute[0]);
        return result;
    }

    public Either<T, Exception> loadTardis(MinecraftServer server, TardisManager<T, ?> manager, UUID uuid, TardisLoader<T> function) {
        long start = System.currentTimeMillis();
        try {
            Path file = TardisFileManager.getSavePath(server, uuid, "json");
            String raw = Files.readString(file);
            JsonObject object = JsonParser.parseString((String)raw).getAsJsonObject();
            Tardis tardis = (Tardis)function.readTardis(manager.getFileGson(), object);
            AITMod.LOGGER.info("Deserialized {} in {}ms", (Object)tardis, (Object)(System.currentTimeMillis() - start));
            return Either.left((Object)tardis);
        }
        catch (Exception e) {
            AITMod.LOGGER.warn("Failed to load {}!", (Object)uuid);
            AITMod.LOGGER.warn(e.getMessage());
            return Either.right((Object)e);
        }
    }

    public void saveTardis(MinecraftServer server, TardisManager<T, ?> manager, @NotNull T tardis) {
        try {
            Path savePath = TardisFileManager.getSavePath(server, ((Tardis)tardis).getUuid(), "json");
            Files.writeString(savePath, (CharSequence)manager.getFileGson().toJson(tardis, ServerTardis.class), new OpenOption[0]);
        }
        catch (IOException e) {
            AITMod.LOGGER.warn("Couldn't save TARDIS {}", (Object)((Tardis)tardis).getUuid(), (Object)e);
        }
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public List<UUID> getTardisList(MinecraftServer server) {
        try {
            return Files.list(TardisFileManager.getRootSavePath(server)).map(path -> {
                String name = path.getFileName().toString();
                return UUID.fromString(name.substring(0, name.indexOf(46)));
            }).toList();
        }
        catch (IOException e) {
            AITMod.LOGGER.error("Failed to list TARDIS files", (Throwable)e);
            return List.of();
        }
    }

    @FunctionalInterface
    public static interface TardisLoader<T> {
        public T readTardis(Gson var1, JsonObject var2);
    }
}

