/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.manager.old;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.api.tardis.WorldWithTardis;
import dev.amble.ait.core.events.ServerCrashEvent;
import dev.amble.ait.core.events.WorldSaveEvent;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.TardisManager;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;
import dev.amble.ait.core.tardis.manager.ServerTardisManager;
import dev.amble.ait.core.tardis.manager.TardisBuilder;
import dev.amble.ait.core.tardis.manager.TardisFileManager;
import dev.amble.ait.core.tardis.util.TardisUtil;
import dev.amble.ait.core.util.WorldUtil;
import dev.amble.ait.core.world.TardisServerWorld;
import dev.amble.ait.data.Exclude;
import dev.amble.ait.data.TardisMap;
import dev.amble.ait.data.properties.Value;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import dev.drtheo.multidim.MultiDim;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DeprecatedServerTardisManager
extends TardisManager<ServerTardis, MinecraftServer>
implements TardisFileManager.TardisLoader<ServerTardis> {
    protected final TardisMap.Optional<ServerTardis> lookup = new TardisMap.Optional();
    protected final TardisFileManager<ServerTardis> fileManager = new TardisFileManager();

    public DeprecatedServerTardisManager() {
        this.fileManager.setLocked(true);
        ServerLifecycleEvents.SERVER_STARTED.register(server -> this.fileManager.setLocked(false));
        ServerLifecycleEvents.SERVER_STOPPING.register(this::saveAndReset);
        ServerCrashEvent.EVENT.register((server, report) -> this.reset());
        WorldSaveEvent.EVENT.register(world -> {
            if (world == WorldUtil.getOverworld()) {
                this.save(world.method_8503(), false);
            }
        });
        ServerTickEvents.START_SERVER_TICK.register(server -> this.forEach((ServerTardis tardis) -> {
            if (tardis.isRemoved() || !tardis.shouldTick()) {
                return;
            }
            tardis.tick(server);
        }));
    }

    @Override
    protected GsonBuilder createGsonBuilder(Exclude.Strategy strategy) {
        return super.createGsonBuilder(strategy).registerTypeAdapter(Tardis.class, ServerTardis.creator());
    }

    public ServerTardis create(TardisBuilder builder) {
        Objects.requireNonNull(builder);
        ServerTardis tardis = builder.build();
        this.lookup.put(tardis);
        return tardis;
    }

    protected void sendTardisRemoval(MinecraftServer server, ServerTardis tardis) {
        if (tardis == null) {
            return;
        }
        class_2540 data = PacketByteBufs.create();
        data.method_10797(tardis.getUuid());
        for (class_3222 player : server.method_3760().method_14571()) {
            this.sendTardisRemoval(player, data);
        }
    }

    protected void sendTardisRemoval(class_3222 player, ServerTardis tardis) {
        class_2540 data = PacketByteBufs.create();
        data.method_10797(tardis.getUuid());
        this.sendTardisRemoval(player, data);
    }

    protected void sendTardisRemoval(class_3222 player, class_2540 data) {
        ServerPlayNetworking.send((class_3222)player, (class_2960)REMOVE, (class_2540)data);
    }

    public abstract void markComponentDirty(TardisComponent var1);

    public abstract void markPropertyDirty(ServerTardis var1, Value<?> var2);

    @Override
    @Nullable
    public ServerTardis demandTardis(@NotNull MinecraftServer server, @NotNull UUID uuid) {
        Objects.requireNonNull(uuid);
        if (this.fileManager.isLocked()) {
            return null;
        }
        Either<ServerTardis, Exception> either = (Either<ServerTardis, Exception>)this.lookup.get(uuid);
        if (either == null) {
            either = this.loadTardis(server, uuid);
        }
        return (ServerTardis)either.map(tardis -> tardis, o -> null);
    }

    @Override
    public void getTardis(MinecraftServer server, @NotNull UUID uuid, @NotNull Consumer<ServerTardis> consumer) {
        Objects.requireNonNull(uuid);
        Objects.requireNonNull(consumer);
        if (this.fileManager.isLocked()) {
            return;
        }
        Either<ServerTardis, Exception> either = (Either<ServerTardis, Exception>)this.lookup.get(uuid);
        if (either == null) {
            either = this.loadTardis(server, uuid);
        }
        either.ifLeft(consumer);
    }

    @Override
    public TardisMap.Optional<ServerTardis> lookup() {
        return this.lookup;
    }

    @Override
    public void forEach(Consumer<ServerTardis> consumer) {
        this.lookup.forEach((? super K uuid, ? super V either) -> either.ifLeft(consumer));
    }

    @NotNull
    public Either<ServerTardis, Exception> loadTardis(MinecraftServer server, UUID uuid) {
        Either<ServerTardis, Exception> result = this.fileManager.loadTardis(server, this, uuid, this);
        this.lookup.put(uuid, result);
        return result;
    }

    public void loadAll(MinecraftServer server, @Nullable Consumer<ServerTardis> consumer) {
        for (UUID id : this.fileManager.getTardisList(server)) {
            this.getTardis(server, id, consumer);
        }
    }

    public void remove(MinecraftServer server, ServerTardis tardis) {
        Objects.requireNonNull(tardis);
        tardis.door().closeDoors();
        tardis.setRemoved(true);
        CachedDirectedGlobalPos exteriorPos = tardis.travel().position();
        if (exteriorPos != null) {
            if (tardis.hasWorld()) {
                tardis.world().method_18456().forEach((? super T player) -> TardisUtil.teleportOutside(tardis, (class_1297)player));
            }
            class_3218 world = exteriorPos.getWorld();
            class_2338 pos = exteriorPos.getPos();
            world.method_8650(pos, false);
            world.method_8544(pos);
        }
        MultiDim.get((MinecraftServer)server).queueRemove(TardisServerWorld.keyForTardis(tardis));
        this.sendTardisRemoval(server, tardis);
        this.lookup.remove(tardis.getUuid());
        this.fileManager.delete(server, tardis.getUuid());
    }

    private void save(MinecraftServer server, boolean close) {
        if (close) {
            this.fileManager.setLocked(true);
        }
        this.forEach((ServerTardis tardis) -> {
            if (tardis == null) {
                return;
            }
            if (close) {
                TravelHandlerBase.State state = tardis.travel().getState();
                if (state == TravelHandlerBase.State.DEMAT) {
                    tardis.travel().finishDemat();
                } else if (state == TravelHandlerBase.State.MAT) {
                    tardis.travel().finishRemat();
                }
            }
            this.fileManager.saveTardis(server, this, (ServerTardis)tardis);
        });
        if (!close) {
            return;
        }
        for (class_3218 world : server.method_3738()) {
            ((WorldWithTardis)world).ait$withLookup(HashMap::clear);
        }
    }

    private void saveAndReset(MinecraftServer server) {
        this.save(server, true);
        this.reset();
    }

    @Override
    public ServerTardis readTardis(Gson gson, JsonObject json) {
        ServerTardis tardis = (ServerTardis)gson.fromJson((JsonElement)json, ServerTardis.class);
        Tardis.init(tardis, TardisComponent.InitContext.deserialize());
        return tardis;
    }

    public static ServerPlayNetworking.PlayChannelHandler receiveTardis(Receiver receiver) {
        return (server, player, handler, buf, responseSender) -> ServerTardisManager.getInstance().getTardis(server, buf.method_10790(), (ServerTardis tardis) -> receiver.receive((ServerTardis)tardis, server, player, handler, buf, responseSender));
    }

    @FunctionalInterface
    public static interface Receiver {
        public void receive(ServerTardis var1, MinecraftServer var2, class_3222 var3, class_3244 var4, class_2540 var5, PacketSender var6);
    }
}

