/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.util;

import com.mojang.datafixers.util.Pair;
import dev.amble.ait.AITMod;
import java.text.NumberFormat;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_2338;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class AsyncLocatorUtil {
    public static ExecutorService LOCATING_EXECUTOR_SERVICE = null;

    public static void init() {
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> AsyncLocatorUtil.shutdownExecutorService());
        ServerLifecycleEvents.SERVER_STARTING.register(server -> AsyncLocatorUtil.setupExecutorService());
    }

    public static void setupExecutorService() {
        AsyncLocatorUtil.shutdownExecutorService();
        int threads = Runtime.getRuntime().availableProcessors() / 2;
        AITMod.LOGGER.trace("Starting locating executor service with thread pool size of {}", (Object)threads);
        if (threads <= 0 && !AITMod.CONFIG.disableSafeguards) {
            AITMod.LOGGER.error("Failed to start locating executor service: thread pool size is 0 or less - {}. Available Processors {}", (Object)threads, (Object)Runtime.getRuntime().availableProcessors());
            return;
        }
        LOCATING_EXECUTOR_SERVICE = Executors.newCachedThreadPool(new ThreadFactory(){
            private static final AtomicInteger poolNum = new AtomicInteger(1);
            private final AtomicInteger threadNum = new AtomicInteger(1);
            private final String namePrefix = "ait-" + poolNum.getAndIncrement() + "-thread-";

            @Override
            public Thread newThread(@NotNull Runnable r) {
                return new Thread(r, this.namePrefix + this.threadNum.getAndIncrement());
            }
        });
    }

    public static void shutdownExecutorService() {
        if (LOCATING_EXECUTOR_SERVICE != null) {
            AITMod.LOGGER.trace("Shutting down locating executor service");
            LOCATING_EXECUTOR_SERVICE.shutdown();
        }
    }

    public static LocateTask<class_2338> locate(class_3218 level, class_6862<class_3195> structureTag, class_2338 pos, int searchRadius, boolean skipKnownStructures) {
        AITMod.LOGGER.trace("Creating locate task for {} in {} around {} within {} chunks", new Object[]{structureTag, level, pos, searchRadius});
        CompletableFuture completableFuture = new CompletableFuture();
        Future<?> future = LOCATING_EXECUTOR_SERVICE.submit(() -> AsyncLocatorUtil.doLocateLevel(completableFuture, level, structureTag, pos, searchRadius, skipKnownStructures));
        return new LocateTask<class_2338>(level.method_8503(), completableFuture, future);
    }

    public static LocateTask<Pair<class_2338, class_6880<class_3195>>> locate(class_3218 level, class_6885<class_3195> structureSet, class_2338 pos, int searchRadius, boolean skipKnownStructures) {
        AITMod.LOGGER.trace("Creating locate task for {} in {} around {} within {} chunks", new Object[]{structureSet, level, pos, searchRadius});
        CompletableFuture completableFuture = new CompletableFuture();
        Future<?> future = LOCATING_EXECUTOR_SERVICE.submit(() -> AsyncLocatorUtil.doLocateChunkGenerator(completableFuture, level, structureSet, pos, searchRadius, skipKnownStructures));
        return new LocateTask<Pair<class_2338, class_6880<class_3195>>>(level.method_8503(), completableFuture, future);
    }

    private static void doLocateLevel(CompletableFuture<class_2338> completableFuture, class_3218 level, class_6862<class_3195> structureTag, class_2338 pos, int searchRadius, boolean skipExistingChunks) {
        AITMod.LOGGER.trace("Trying to locate {} in {} around {} within {} chunks", new Object[]{structureTag, level, pos, searchRadius});
        long start = System.nanoTime();
        class_2338 foundPos = level.method_8487(structureTag, pos, searchRadius, skipExistingChunks);
        String time = NumberFormat.getNumberInstance().format(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
        if (foundPos == null) {
            AITMod.LOGGER.trace("No {} found (took {}ms)", structureTag, (Object)time);
        } else {
            AITMod.LOGGER.trace("Found {} at {} (took {}ms)", new Object[]{structureTag, foundPos, time});
        }
        completableFuture.complete(foundPos);
    }

    private static void doLocateChunkGenerator(CompletableFuture<Pair<class_2338, class_6880<class_3195>>> completableFuture, class_3218 level, class_6885<class_3195> structureSet, class_2338 pos, int searchRadius, boolean skipExistingChunks) {
        AITMod.LOGGER.info("Trying to locate {} in {} around {} within {} chunks", new Object[]{structureSet, level, pos, searchRadius});
        long start = System.nanoTime();
        Pair foundPair = level.method_14178().method_12129().method_12103(level, structureSet, pos, searchRadius, skipExistingChunks);
        String time = NumberFormat.getNumberInstance().format(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
        if (foundPair == null) {
            AITMod.LOGGER.trace("No {} found (took {}ms)", structureSet, (Object)time);
        } else {
            AITMod.LOGGER.trace("Found {} at {} (took {}ms)", new Object[]{((class_3195)((class_6880)foundPair.getSecond()).comp_349()).getClass().getSimpleName(), foundPair.getFirst(), time});
        }
        completableFuture.complete((Pair<class_2338, class_6880<class_3195>>)foundPair);
    }

    public record LocateTask<T>(MinecraftServer server, CompletableFuture<T> completableFuture, Future<?> taskFuture) {
        public LocateTask<T> then(Consumer<T> action) {
            this.completableFuture.thenAccept((Consumer)action);
            return this;
        }

        public LocateTask<T> thenOnServerThread(Consumer<T> action) {
            this.completableFuture.thenAccept(pos -> this.server.method_20493(() -> action.accept(pos)));
            return this;
        }

        public void cancel() {
            this.taskFuture.cancel(true);
            this.completableFuture.cancel(false);
        }
    }
}

