/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.util;

import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.core.tardis.manager.TardisBuilder;
import dev.amble.ait.data.hum.Hum;
import dev.amble.ait.data.schema.console.ConsoleVariantSchema;
import dev.amble.ait.data.schema.desktop.TardisDesktopSchema;
import dev.amble.ait.data.schema.exterior.ExteriorVariantSchema;
import dev.amble.ait.registry.impl.DesktopRegistry;
import dev.amble.ait.registry.impl.HumRegistry;
import dev.amble.ait.registry.impl.console.variant.ConsoleVariantRegistry;
import dev.amble.ait.registry.impl.exterior.ExteriorVariantRegistry;
import java.util.Objects;
import net.minecraft.class_2960;
import org.apache.commons.lang3.NotImplementedException;

public enum DefaultThemes {
    CORAL("coral", "exterior/police_box/coral", "coral", "console/coral"),
    PRIME("accursed", "exterior/capsule/default", "prime", "console/hartnell"),
    TOYOTA("toyota", "exterior/police_box/default", "toyota", "console/toyota"),
    RENAISSANCE("renaissance", "exterior/police_box/renaissance", "renaissance", "todo"),
    WAR(AITMod.id("war"), new class_2960("frooploof", "coral_war"), AITMod.id("coral"), AITMod.id("console/coral")),
    CRYSTALLINE("crystalline", "exterior/police_box/renaissance", "renaissance", "console/crystalline");

    private final class_2960 desktop;
    private final class_2960 exterior;
    private final class_2960 hum;
    private final class_2960 console;

    private DefaultThemes(String desktop, String exterior, String hum, String console) {
        this(AITMod.id(desktop), AITMod.id(exterior), AITMod.id(hum), AITMod.id(console));
    }

    private DefaultThemes(class_2960 desktop, class_2960 exterior, class_2960 hum, class_2960 console) {
        this.desktop = desktop;
        this.exterior = exterior;
        this.hum = hum;
        this.console = console;
    }

    public TardisDesktopSchema desktop() {
        return (TardisDesktopSchema)DesktopRegistry.getInstance().get(this.desktop);
    }

    public ExteriorVariantSchema exterior() {
        return (ExteriorVariantSchema)ExteriorVariantRegistry.getInstance().get(this.exterior);
    }

    public Hum hum() {
        return (Hum)HumRegistry.getInstance().get(this.hum);
    }

    public ConsoleVariantSchema console() {
        if (Objects.equals(this.console.method_12832(), "todo")) {
            throw new NotImplementedException("DefaultThemes.console() is not implemented for " + String.valueOf((Object)this));
        }
        return (ConsoleVariantSchema)ConsoleVariantRegistry.getInstance().get(this.console);
    }

    public TardisBuilder apply(TardisBuilder builder) {
        builder.exterior(this.exterior());
        builder.desktop(this.desktop());
        builder.with(TardisComponent.Id.HUM, handler -> handler.set(this.hum()));
        return builder;
    }

    public static DefaultThemes getRandom() {
        return DefaultThemes.values()[(int)(Math.random() * (double)DefaultThemes.values().length)];
    }
}

