/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.util;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.link.LinkableItem;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import dev.amble.lib.util.ServerLifecycleHooks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2767;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import org.slf4j.Logger;

public class NetworkUtil {
    public static <T> void send(class_3222 player, class_2540 buf, class_2960 id, Codec<T> codec, T t) {
        DataResult result = codec.encodeStart((DynamicOps)class_2509.field_11560, t);
        class_2520 nbt = (class_2520)result.resultOrPartial(arg_0 -> ((Logger)AITMod.LOGGER).error(arg_0)).orElseThrow();
        buf.method_10794((class_2487)nbt);
        NetworkUtil.send(player, id, buf);
    }

    public static void send(class_3222 player, class_2960 id, class_2540 buf) {
        if (player == null) {
            return;
        }
        ServerPlayNetworking.send((class_3222)player, (class_2960)id, (class_2540)buf);
    }

    public static <T> T receive(Codec<T> codec, class_2540 buf) {
        return (T)((Pair)codec.decode((DynamicOps)class_2509.field_11560, (Object)buf.method_10798()).resultOrPartial(arg_0 -> ((Logger)AITMod.LOGGER).error(arg_0)).orElseThrow()).getFirst();
    }

    public static void sendToInterior(ServerTardis tardis, class_2960 id, class_2540 buf) {
        if (!tardis.hasWorld()) {
            return;
        }
        for (class_3222 player : tardis.world().method_18456()) {
            NetworkUtil.send(player, id, buf);
        }
    }

    public static Collection<class_3222> getLinkedPlayers(ServerTardis tardis) {
        ArrayList<class_3222> players = new ArrayList<class_3222>();
        for (class_3222 player : ServerLifecycleHooks.get().method_3760().method_14571()) {
            if (!NetworkUtil.hasLinkedItem(tardis, player)) continue;
            players.add(player);
        }
        return players;
    }

    public static boolean hasLinkedItem(Tardis tardis, class_3222 player) {
        for (class_1799 stack : player.method_31548().field_7547) {
            if (stack.method_7960() || !(stack.method_7909() instanceof LinkableItem) || !LinkableItem.isOfStatic(stack, tardis)) continue;
            return true;
        }
        return false;
    }

    public static Set<ServerTardis> findLinkedItems(class_3222 player) {
        HashSet<ServerTardis> ids = new HashSet<ServerTardis>();
        for (class_1799 stack : player.method_31548().field_7547) {
            LinkableItem item;
            Tardis tardis;
            class_1792 class_17922;
            if (stack.method_7960() || !((class_17922 = stack.method_7909()) instanceof LinkableItem) || (tardis = (item = (LinkableItem)class_17922).getTardis(player.method_37908(), stack)) == null) continue;
            ids.add(tardis.asServer());
        }
        return ids;
    }

    public static Stream<class_3222> getSubscribedPlayers(ServerTardis tardis) {
        Stream<class_3222> result = tardis.hasWorld() ? tardis.world().method_18456().stream() : Stream.empty();
        CachedDirectedGlobalPos exteriorPos = tardis.travel().position();
        if (exteriorPos == null || exteriorPos.getWorld() == null) {
            return result;
        }
        class_1923 chunkPos = new class_1923(exteriorPos.getPos());
        return Stream.concat(result, PlayerLookup.tracking((class_3218)exteriorPos.getWorld(), (class_1923)chunkPos).stream());
    }

    public static void playSound(class_5321<class_1937> worldKey, class_2338 pos, class_2960 soundId, class_3419 category, float volume) {
        if (!ServerLifecycleHooks.isServer()) {
            return;
        }
        class_6880 soundEntry = class_6880.method_40223((Object)class_3414.method_47908((class_2960)soundId));
        long seed = ServerLifecycleHooks.get().method_30002().method_8409().method_43055();
        ServerLifecycleHooks.get().method_3760().method_14605(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), volume > 1.0f ? (double)(16.0f * volume) : 16.0, worldKey, (class_2596)new class_2767(soundEntry, category, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), volume, 1.0f, seed));
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean canClientSendPackets() {
        return class_310.method_1551().method_1562() != null;
    }
}

