/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.util;

import dev.amble.ait.AITMod;
import dev.amble.ait.api.ExtraPushableEntity;
import dev.amble.ait.api.tardis.TardisEvents;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.AITTags;
import dev.amble.ait.core.blockentities.DoorBlockEntity;
import dev.amble.ait.core.entities.FlightTardisEntity;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.TardisDesktop;
import dev.amble.ait.core.tardis.handler.FuelHandler;
import dev.amble.ait.core.tardis.manager.ServerTardisManager;
import dev.amble.ait.core.tardis.util.NetworkUtil;
import dev.amble.ait.core.util.WorldUtil;
import dev.amble.ait.core.world.TardisServerWorld;
import dev.amble.ait.data.Loyalty;
import dev.amble.ait.mixin.lookup.EntityTrackingSectionAccessor;
import dev.amble.ait.mixin.lookup.SectionedEntityCacheAccessor;
import dev.amble.ait.mixin.lookup.SimpleEntityLookupAccessor;
import dev.amble.ait.mixin.lookup.WorldInvoker;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import dev.amble.lib.data.DirectedBlockPos;
import dev.amble.lib.util.ServerLifecycleHooks;
import dev.amble.lib.util.TeleportUtil;
import dev.drtheo.scheduler.api.TimeUnit;
import dev.drtheo.scheduler.api.common.Scheduler;
import dev.drtheo.scheduler.api.common.TaskStage;
import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1541;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2743;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4076;
import net.minecraft.class_5362;
import net.minecraft.class_5568;
import net.minecraft.class_5572;
import net.minecraft.class_5575;
import net.minecraft.class_7718;
import net.minecraft.class_7927;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class TardisUtil {
    public static final class_2960 REGION_LANDING_CODE = AITMod.id("region_landing_code");
    public static final class_2960 SNAP = AITMod.id("snap");
    public static final class_2960 FLYING_SPEED = AITMod.id("flying_speed");
    public static final class_2960 TOGGLE_ANTIGRAVS = AITMod.id("toggle_antigravs");
    public static final class_2960 FIND_PLAYER = AITMod.id("find_player");
    public static final class_5362 EXPLOSION_BEHAVIOR = new class_5362(){

        public boolean method_29554(class_1927 explosion, class_1922 world, class_2338 pos, class_2680 state, float power) {
            MinecraftServer server = ServerLifecycleHooks.get();
            if (server == null) {
                return false;
            }
            if (!server.method_3767().method_8355(AITMod.TARDIS_GRIEFING)) {
                return false;
            }
            return super.method_29554(explosion, world, pos, state, power);
        }
    };

    public static boolean doCreateFire(class_1937 world) {
        return world.method_8450().method_8355(AITMod.TARDIS_FIRE_GRIEFING);
    }

    public static void init() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SNAP, (server, player, handler, buf, responseSender) -> {
            UUID uuid = buf.method_10790();
            ServerTardisManager.getInstance().getTardis(server, uuid, tardis -> {
                class_2338 pos;
                Loyalty loyalty = tardis.loyalty().get((class_1657)player);
                if (tardis.flight().isFlying()) {
                    server.execute(() -> {
                        if (!player.method_5715()) {
                            tardis.door().interactAllDoors(player.method_51469(), null, player, true);
                        } else {
                            tardis.door().interactToggleLock(player);
                        }
                    });
                    return;
                }
                if (!loyalty.isOf(Loyalty.Type.PILOT)) {
                    return;
                }
                player.method_37908().method_8396(null, player.method_24515(), AITSounds.SNAP, class_3419.field_15248, 4.0f, 1.0f);
                class_2338 exteriorPos = tardis.travel().position().getPos();
                class_2338 class_23382 = pos = TardisServerWorld.isTardisDimension(player.method_51469()) ? tardis.getDesktop().getDoorPos().getPos() : exteriorPos;
                if (player.method_5649((double)exteriorPos.method_10263(), (double)exteriorPos.method_10264(), (double)exteriorPos.method_10260()) > 200.0 && tardis.hasWorld() && player.method_37908() != tardis.world()) {
                    return;
                }
                server.execute(() -> {
                    if (!player.method_5715()) {
                        tardis.door().interact(player.method_51469(), null, player);
                    } else {
                        boolean isLocked = tardis.door().locked();
                        tardis.door().interactToggleLock(player);
                        player.method_37908().method_8396(null, pos, isLocked ? AITSounds.REMOTE_UNLOCK : AITSounds.REMOTE_LOCK, class_3419.field_15245, 1.0f, 1.0f);
                    }
                });
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)FLYING_SPEED, (server, player, handler, buf, responseSender) -> {
            UUID uuid = buf.method_10790();
            String direction = buf.method_19772();
            ServerTardisManager.getInstance().getTardis(server, uuid, tardis -> {
                if (!tardis.flight().isFlying()) {
                    return;
                }
                switch (direction) {
                    case "up": {
                        tardis.travel().increaseSpeed();
                        break;
                    }
                    case "down": {
                        tardis.travel().decreaseSpeed();
                    }
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)TOGGLE_ANTIGRAVS, (server, player, handler, buf, responseSender) -> {
            UUID uuid = buf.method_10790();
            ServerTardisManager.getInstance().getTardis(server, uuid, tardis -> {
                if (!tardis.flight().isFlying()) {
                    return;
                }
                tardis.travel().antigravs().toggle();
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)FIND_PLAYER, (server, currentPlayer, handler, buf, responseSender) -> {
            UUID tardisId = buf.method_10790();
            UUID playerUuid = buf.method_10790();
            ServerTardisManager.getInstance().getTardis(server, tardisId, tardis -> {
                class_3222 serverPlayer = server.method_3760().method_14602(playerUuid);
                if (serverPlayer == null) {
                    tardis.getDesktop().playSoundAtEveryConsole(class_3417.field_37347, class_3419.field_15245, 3.0f, 1.0f);
                    return;
                }
                tardis.travel().forceDestination(CachedDirectedGlobalPos.create((class_3218)serverPlayer.method_37908(), serverPlayer.method_24515(), (byte)class_7718.method_45479((float)serverPlayer.method_43078())));
                tardis.getDesktop().playSoundAtEveryConsole(class_3417.field_26980, class_3419.field_15245, 3.0f, 1.0f);
            });
        });
    }

    public static boolean inBox(class_238 a, class_238 b) {
        return a.field_1323 < b.field_1320 && a.field_1320 > b.field_1323 && a.field_1321 < b.field_1324 && a.field_1324 > b.field_1321;
    }

    public static class_243 offsetInteriorDoorPosition(Tardis tardis) {
        return TardisUtil.offsetInteriorDoorPosition(tardis.getDesktop());
    }

    public static class_243 offsetInteriorDoorPosition(TardisDesktop desktop) {
        return TardisUtil.offsetInteriorDoorPos(desktop.getDoorPos());
    }

    public static class_243 offsetDoorPosition(class_243 pos, byte rotation) {
        return switch (rotation) {
            case 1, 2, 3 -> new class_243(pos.method_10216() + (double)1.1f, pos.method_10214(), pos.method_10215() - 0.5);
            case 4 -> new class_243(pos.method_10216() + 1.5, pos.method_10214(), pos.method_10215() + 0.5);
            case 5, 6, 7 -> new class_243(pos.method_10216() + 1.5, pos.method_10214(), pos.method_10215() + (double)1.1f);
            case 8 -> new class_243(pos.method_10216() + 0.5, pos.method_10214(), pos.method_10215() + 1.5);
            case 9, 10, 11 -> new class_243(pos.method_10216(), pos.method_10214(), pos.method_10215() + 1.5);
            case 12 -> new class_243(pos.method_10216() - 0.5, pos.method_10214(), pos.method_10215() + 0.5);
            case 13, 14, 15 -> new class_243(pos.method_10216() - (double)0.3f, pos.method_10214(), pos.method_10215() - 0.5);
            default -> new class_243(pos.method_10216() + 0.5, pos.method_10214(), pos.method_10215() - 0.5);
        };
    }

    public static class_243 offsetDoorPosition(DirectedBlockPos directed) {
        return TardisUtil.offsetDoorPosition(new class_243((double)directed.getPos().method_10263(), (double)directed.getPos().method_10264(), (double)directed.getPos().method_10260()), directed.getRotation());
    }

    public static class_243 offsetInteriorDoorPos(DirectedBlockPos directed) {
        class_2338 pos = directed.getPos();
        return switch (directed.getRotation()) {
            case 4 -> new class_243((double)((float)pos.method_10263() + 0.4f), (double)pos.method_10264(), (double)((float)pos.method_10260() + 0.5f));
            case 8 -> new class_243((double)((float)pos.method_10263() + 0.5f), (double)pos.method_10264(), (double)((float)pos.method_10260() + 0.4f));
            case 12 -> new class_243((double)((float)pos.method_10263() + 0.6f), (double)pos.method_10264(), (double)((float)pos.method_10260() + 0.5f));
            default -> new class_243((double)((float)pos.method_10263() + 0.5f), (double)pos.method_10264(), (double)((float)pos.method_10260() + 0.6f));
        };
    }

    public static class_243 offsetPos(DirectedBlockPos directed, float value) {
        class_2338 pos = directed.getPos();
        return new class_243((double)pos.method_10263() + (double)value * (double)directed.getVector().method_10263(), (double)pos.method_10264() + (double)value * (double)directed.getVector().method_10264(), (double)pos.method_10260() + (double)value * (double)directed.getVector().method_10260());
    }

    public static void teleportOutside(Tardis tardis, class_1297 entity) {
        ((TardisEvents.LeaveTardis)TardisEvents.LEAVE_TARDIS.invoker()).onLeave(tardis, entity);
        TardisUtil.teleportWithDoorOffset(tardis.travel().position().getWorld(), entity, tardis.travel().position().toPos());
    }

    public static void dropOutside(Tardis tardis, class_1297 entity) {
        ((TardisEvents.LeaveTardis)TardisEvents.LEAVE_TARDIS.invoker()).onLeave(tardis, entity);
        if (!(entity instanceof class_1309)) {
            return;
        }
        class_1309 living = (class_1309)entity;
        CachedDirectedGlobalPos percentageOfDestination = tardis.travel().getProgress();
        Scheduler scheduler = Scheduler.get();
        class_3218 vortexWorld = WorldUtil.getTimeVortex();
        if (vortexWorld == null) {
            return;
        }
        TeleportUtil.teleport((class_1309)living, (class_3218)vortexWorld, (class_243)new class_243((double)vortexWorld.method_8409().method_39332(0, 256), 0.0, (double)vortexWorld.method_8409().method_39332(0, 256)), (float)living.method_43078());
        scheduler.runTaskLater(() -> {
            if (living.method_37908() == vortexWorld) {
                TeleportUtil.teleport((class_1309)living, (class_3218)tardis.travel().destination().getWorld(), (class_243)percentageOfDestination.getPos().method_46558(), (float)living.method_43078());
            }
        }, TaskStage.END_SERVER_TICK, TimeUnit.SECONDS, 4L);
    }

    public static void teleportInside(ServerTardis tardis, class_1297 entity) {
        ((TardisEvents.EnterTardis)TardisEvents.ENTER_TARDIS.invoker()).onEnter(tardis, entity);
        TardisUtil.teleportWithDoorOffset((class_3218)tardis.world(), entity, tardis.getDesktop().getDoorPos());
    }

    public static void teleportToInteriorPosition(ServerTardis tardis, class_1297 entity, class_2338 pos) {
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            ((TardisEvents.EnterTardis)TardisEvents.ENTER_TARDIS.invoker()).onEnter(tardis, entity);
            WorldUtil.teleportToWorld(player, (class_3218)tardis.world(), new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()), entity.method_36454(), player.method_36455());
            player.field_13987.method_14364((class_2596)new class_2743((class_1297)player));
        }
    }

    private static void teleportWithDoorOffset(class_3218 world, class_1297 entity, DirectedBlockPos directed) {
        ExtraPushableEntity pushable;
        if (!AITMod.CONFIG.tntCanTeleportThroughDoors && entity instanceof class_1541) {
            return;
        }
        if (entity instanceof ExtraPushableEntity && (pushable = (ExtraPushableEntity)entity).ait$pushBehaviour() == TriState.FALSE) {
            return;
        }
        class_2338 pos = directed.getPos();
        boolean isDoor = world.method_8321(pos) instanceof DoorBlockEntity;
        class_243 vec = isDoor ? TardisUtil.offsetInteriorDoorPos(directed) : TardisUtil.offsetDoorPosition(directed).method_1031(0.0, 0.125, 0.0);
        world.method_8503().execute(() -> {
            ExtraPushableEntity pushable;
            if (entity.method_5854() instanceof FlightTardisEntity) {
                return;
            }
            if (entity instanceof ExtraPushableEntity) {
                pushable = (ExtraPushableEntity)entity;
                pushable.ait$setPushBehaviour(TriState.FALSE);
            }
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                WorldUtil.teleportToWorld(player, world, vec, class_7718.method_45482((int)directed.getRotation()) + (isDoor ? 0.0f : 180.0f), player.method_36455());
                player.field_13987.method_14364((class_2596)new class_2743((class_1297)player));
            } else {
                if (entity.method_5864().method_20210(AITTags.EntityTypes.BOSS)) {
                    return;
                }
                if (entity.method_37908().method_27983() == world.method_27983()) {
                    entity.method_5808(TardisUtil.offset((class_243)vec, (DirectedBlockPos)directed, (double)-0.5).field_1352, vec.field_1351, TardisUtil.offset((class_243)vec, (DirectedBlockPos)directed, (double)-0.5).field_1350, class_7718.method_45482((int)directed.getRotation()) + (isDoor ? 0.0f : 180.0f), entity.method_36455());
                } else {
                    entity.method_48105(world, TardisUtil.offset((class_243)vec, (DirectedBlockPos)directed, (double)-0.5).field_1352, vec.field_1351, TardisUtil.offset((class_243)vec, (DirectedBlockPos)directed, (double)-0.5).field_1350, Set.of(), class_7718.method_45482((int)directed.getRotation()) + (isDoor ? 0.0f : 180.0f), entity.method_36455());
                }
            }
            if (entity instanceof ExtraPushableEntity) {
                pushable = (ExtraPushableEntity)entity;
                Scheduler.get().runTaskLater(() -> pushable.ait$setPushBehaviour(TriState.DEFAULT), TaskStage.END_SERVER_TICK, TimeUnit.SECONDS, 3L);
            }
        });
    }

    public static class_243 offset(class_243 vec, DirectedBlockPos direction, double value) {
        class_2382 vec3i = direction.getVector();
        return new class_243(vec.field_1352 + value * (double)vec3i.method_10263(), vec.field_1351 + value * (double)vec3i.method_10264(), vec.field_1350 + value * (double)vec3i.method_10260());
    }

    public static void giveEffectToInteriorPlayers(ServerTardis tardis, class_1293 effect) {
        for (class_1657 player : tardis.world().method_18456()) {
            player.method_6092(effect);
        }
    }

    @Nullable
    public static class_1657 getAnyPlayerInsideInterior(class_3218 world) {
        Iterator iterator = world.method_18456().iterator();
        if (iterator.hasNext()) {
            class_1657 player = (class_1657)iterator.next();
            return player;
        }
        return null;
    }

    public static <T extends class_1297> List<T> getEntitiesInBox(Class<T> clazz, class_1937 world, class_238 box, Predicate<T> predicate) {
        return TardisUtil.fastFlatLookup(clazz, world, box, predicate);
    }

    private static <T extends class_5568> void forEachInFlatBox(SectionedEntityCacheAccessor<T> accessor, class_238 box, class_7927<class_5572<T>> consumer) {
        int j = class_4076.method_32204((double)(box.field_1323 - 2.0));
        int l = class_4076.method_32204((double)(box.field_1321 - 2.0));
        int m = class_4076.method_32204((double)(box.field_1320 + 2.0));
        int o = class_4076.method_32204((double)(box.field_1324 + 2.0));
        for (int p = j; p <= m; ++p) {
            long q = class_4076.method_18685((int)p, (int)0, (int)0);
            long r = class_4076.method_18685((int)p, (int)-1, (int)-1);
            LongBidirectionalIterator longIterator = accessor.getTrackedPositions().subSet(q, r + 1L).iterator();
            while (longIterator.hasNext()) {
                class_5572 section;
                long s = longIterator.nextLong();
                int u = class_4076.method_18690((long)s);
                if (u < l || u > o || (section = (class_5572)accessor.getTrackingSections().get(s)) == null || section.method_31761() || !section.method_31768().method_31885() || !consumer.accept((Object)section).method_47543()) continue;
                return;
            }
        }
    }

    private static <U extends T, T extends class_5568> void forEachIntersects(SectionedEntityCacheAccessor<T> cache, class_5575<T, U> filter, class_238 box, class_7927<U> consumer) {
        TardisUtil.forEachInFlatBox(cache, box, section -> {
            EntityTrackingSectionAccessor accessor = (EntityTrackingSectionAccessor)section;
            Collection collection = accessor.getCollection().method_15216(filter.method_31794());
            if (collection.isEmpty()) {
                return class_7927.class_7928.field_41283;
            }
            for (class_5568 entityLike : collection) {
                class_5568 downcast = (class_5568)filter.method_31796((Object)entityLike);
                if (downcast == null || !TardisUtil.inBox(entityLike.method_5829(), box) || !consumer.accept((Object)downcast).method_47543()) continue;
                return class_7927.class_7928.field_41284;
            }
            return class_7927.class_7928.field_41283;
        });
    }

    private static <T extends class_1297> List<T> fastFlatLookup(Class<T> clazz, class_1937 world, class_238 box, Predicate<T> predicate) {
        ArrayList result = new ArrayList();
        world.method_16107().method_39278("getEntities");
        SectionedEntityCacheAccessor cache = (SectionedEntityCacheAccessor)((SimpleEntityLookupAccessor)((WorldInvoker)world).getEntityLookup()).getCache();
        TardisUtil.forEachIntersects(cache, class_5575.method_31795(clazz), box, entity -> {
            if (predicate.test(entity)) {
                result.add(entity);
            }
            return class_7927.class_7928.field_41283;
        });
        return result;
    }

    public static List<class_1309> getLivingEntitiesInInterior(Tardis tardis, int area) {
        DirectedBlockPos directedPos = tardis.getDesktop().getDoorPos();
        if (directedPos == null) {
            return List.of();
        }
        class_2338 pos = tardis.getDesktop().getDoorPos().getPos();
        return tardis.asServer().world().method_8390(class_1309.class, new class_238(pos.method_10076(area).method_10089(area).method_10086(area), pos.method_10077(area).method_10088(area).method_10087(area)), e -> true);
    }

    public static List<class_1297> getEntitiesInInterior(Tardis tardis, int area) {
        DirectedBlockPos directedPos = tardis.getDesktop().getDoorPos();
        if (directedPos == null) {
            return List.of();
        }
        class_2338 pos = directedPos.getPos();
        return tardis.asServer().world().method_8390(class_1297.class, new class_238(pos.method_10076(area).method_10089(area).method_10086(area), pos.method_10077(area).method_10088(area).method_10087(area)), e -> true);
    }

    public static List<class_1309> getLivingEntitiesInInterior(ServerTardis tardis) {
        return TardisUtil.getLivingEntitiesInInterior(tardis, 20);
    }

    public static boolean isInteriorEmpty(ServerTardis tardis) {
        return tardis.world().method_18456().isEmpty();
    }

    public static void sendMessageToInterior(ServerTardis tardis, class_2561 text) {
        for (class_3222 player : tardis.world().method_18456()) {
            player.method_7353(text, true);
        }
    }

    public static void sendMessageToLinked(ServerTardis tardis, class_2561 message) {
        NetworkUtil.getLinkedPlayers(tardis).forEach(player -> player.method_7353(message, true));
    }

    public static Optional<class_3222> findNearestPlayer(CachedDirectedGlobalPos position) {
        class_3218 world = position.getWorld();
        class_2338 pos = position.getPos();
        class_3222 nearestPlayer = null;
        double nearestDistance = Double.MAX_VALUE;
        for (class_3222 player : world.method_18456()) {
            double distance = player.method_5649((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
            if (!(distance < nearestDistance)) continue;
            nearestDistance = distance;
            nearestPlayer = player;
        }
        return Optional.ofNullable(nearestPlayer);
    }

    public static boolean isNearTardis(class_1657 player, Tardis tardis, double radius) {
        return radius >= TardisUtil.distanceFromTardis(player, tardis);
    }

    public static double distanceFromTardis(class_1657 player, Tardis tardis) {
        class_2338 pPos = player.method_24515();
        class_2338 tPos = tardis.travel().position().getPos();
        return Math.sqrt(tPos.method_10262((class_2382)pPos));
    }

    public static double estimatedFuelCost(class_1657 player, Tardis tardis, double distance) {
        int speed = Math.max(tardis.travel().speed(), 1);
        double ticksRequired = distance / (double)speed;
        double perTick = FuelHandler.getPerTickFuelCost(speed, tardis.travel().instability());
        return perTick * ticksRequired;
    }
}

