/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.util.network.s2c;

import com.mojang.serialization.DynamicOps;
import dev.amble.ait.AITMod;
import dev.amble.ait.core.blockentities.ExteriorBlockEntity;
import dev.amble.ait.core.tardis.Tardis;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class BOTIDataS2CPacket
implements FabricPacket {
    public static final PacketType<BOTIDataS2CPacket> TYPE = PacketType.create((class_2960)AITMod.id("send_boti_data"), BOTIDataS2CPacket::new);
    private final class_2338 botiPos;
    public final class_2487 chunkData;

    public BOTIDataS2CPacket(class_2338 botiPos, class_2818 chunk, class_2338 targetPos) {
        this.botiPos = botiPos;
        this.chunkData = new class_2487();
        class_2487 blockStates = new class_2487();
        class_2487 blockEntities = new class_2487();
        class_1937 world = chunk.method_12200();
        int targetY = targetPos.method_10264();
        int baseY = targetY & 0xFFFFFFF0;
        int sectionIndex = chunk.method_31602(targetY);
        class_2826 section = chunk.method_38259(sectionIndex);
        class_1923 chunkPos = chunk.method_12004();
        try {
            int y;
            ArrayList<class_2680> paletteList = new ArrayList<class_2680>();
            HashMap<class_2680, Integer> stateToIndex = new HashMap<class_2680, Integer>();
            paletteList.add(class_2246.field_10124.method_9564());
            stateToIndex.put(class_2246.field_10124.method_9564(), 0);
            class_2680[][][] sectionStates = new class_2680[16][16][16];
            for (int y2 = 0; y2 < 16; ++y2) {
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        class_2680 state;
                        sectionStates[x][y2][z] = state = section.method_12254(x, y2, z);
                        if (state == null || state.method_26215() || stateToIndex.containsKey(state)) continue;
                        stateToIndex.put(state, paletteList.size());
                        paletteList.add(state);
                    }
                }
            }
            class_2499 palette = new class_2499();
            for (class_2680 state : paletteList) {
                class_2487 stateNbt = (class_2487)class_2680.field_24734.encodeStart((DynamicOps)class_2509.field_11560, (Object)state).result().orElseThrow(() -> new IllegalStateException("Failed to encode state " + String.valueOf(state)));
                palette.add((Object)stateNbt);
            }
            int paletteSize = palette.size();
            int bitsPerEntry = Math.max(1, (int)Math.ceil(Math.log(paletteSize) / Math.log(2.0)));
            int entriesPerLong = 64 / bitsPerEntry;
            int dataLength = (int)Math.ceil(4096.0 / (double)entriesPerLong);
            long[] data = new long[dataLength];
            for (y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        int index = y * 256 + z * 16 + x;
                        int longIndex = index / entriesPerLong;
                        int offset = index % entriesPerLong * bitsPerEntry;
                        class_2680 state = sectionStates[x][y][z];
                        int paletteIndex = stateToIndex.getOrDefault(state, 0);
                        int n = longIndex;
                        data[n] = data[n] | ((long)paletteIndex & (1L << bitsPerEntry) - 1L) << offset;
                    }
                }
            }
            for (y = 0; y < 16; ++y) {
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        class_2338 worldPos = new class_2338(chunkPos.method_8326() + x, baseY + y, chunkPos.method_8328() + z);
                        class_2586 be = chunk.method_8321(worldPos);
                        if (be == null) continue;
                        class_2487 blockEntityNbt = be.method_38242();
                        String key = x + "_" + y + "_" + z;
                        blockEntities.method_10566(key, (class_2520)blockEntityNbt);
                    }
                }
            }
            blockStates.method_10566("palette", (class_2520)palette);
            blockStates.method_10564("data", data);
            blockStates.method_10569("bitsPerEntry", bitsPerEntry);
            this.chunkData.method_10566("block_states", (class_2520)blockStates);
            if (!blockEntities.method_33133()) {
                this.chunkData.method_10566("block_entities", (class_2520)blockEntities);
            }
        }
        catch (Exception e) {
            System.out.println("Exception in packet construction: " + e.getMessage());
            AITMod.LOGGER.atTrace();
            class_2499 palette = new class_2499();
            palette.add((Object)((class_2520)class_2680.field_24734.encodeStart((DynamicOps)class_2509.field_11560, (Object)class_2246.field_10340.method_9564()).result().orElseThrow(() -> new IllegalStateException("Failed to encode stone state"))));
            long[] fullData = new long[256];
            Arrays.fill(fullData, 0L);
            blockStates.method_10566("palette", (class_2520)palette);
            blockStates.method_10564("data", fullData);
            System.out.println("Using fallback stone data due to serialization failure");
            this.chunkData.method_10566("block_states", (class_2520)blockStates);
        }
    }

    public BOTIDataS2CPacket(class_2338 botiPos, class_2487 chunkData) {
        this.botiPos = botiPos;
        this.chunkData = chunkData;
    }

    public BOTIDataS2CPacket(class_2540 buf) {
        this.botiPos = buf.method_10811();
        this.chunkData = buf.method_10798();
    }

    public void write(class_2540 buf) {
        buf.method_10807(this.botiPos);
        buf.method_10794(this.chunkData);
    }

    public PacketType<?> getType() {
        return TYPE;
    }

    public <T> boolean handle(class_746 source, PacketSender response) {
        class_310 client = class_310.method_1551();
        class_638 world = client.field_1687;
        if (world == null) {
            return false;
        }
        class_2586 exterior = world.method_8321(this.botiPos);
        if (exterior instanceof ExteriorBlockEntity) {
            ExteriorBlockEntity exteriorBlockEntity = (ExteriorBlockEntity)exterior;
            if (!exteriorBlockEntity.isLinked()) {
                return false;
            }
            Tardis tardis = exteriorBlockEntity.tardis().get();
        }
        return true;
    }
}

