/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.util;

import java.util.function.Consumer;
import java.util.function.Supplier;

public class Lazy<T> {
    private final Supplier<T> creator;
    private T value;
    private boolean cached;

    public Lazy(Supplier<T> creator) {
        this.creator = creator;
    }

    public T get() {
        if (!this.cached) {
            this.value = this.creator.get();
            this.cached = true;
        }
        return this.value;
    }

    public void invalidate() {
        this.value = null;
        this.cached = false;
    }

    public boolean isCached() {
        return this.cached;
    }

    public void ifPresent(Consumer<? super T> action) {
        if (this.cached) {
            action.accept(this.value);
        }
    }

    public void ifPresentOrElse(Consumer<? super T> action, Runnable emptyAction) {
        if (this.cached) {
            action.accept(this.value);
        } else {
            emptyAction.run();
        }
    }

    public T getOrDefault(Supplier<? extends T> supplier) {
        if (this.cached) {
            return this.value;
        }
        return supplier.get();
    }
}

