/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_2350;
import net.minecraft.class_243;

public class PortalOffsets {
    public static final Codec<PortalOffsets> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("enabled", (Object)true).forGetter(PortalOffsets::isEnabled), (App)Codec.FLOAT.optionalFieldOf("width", (Object)Float.valueOf(1.0f)).forGetter(PortalOffsets::getWidth), (App)Codec.FLOAT.optionalFieldOf("height", (Object)Float.valueOf(2.0f)).forGetter(PortalOffsets::getHeight), (App)class_243.field_38277.optionalFieldOf("offset", (Object)class_243.field_1353).forGetter(map -> map.get((byte)0)), (App)class_243.field_38277.optionalFieldOf("north", (Object)class_243.field_1353).forGetter(map -> map.get(class_2350.field_11043)), (App)class_243.field_38277.optionalFieldOf("south", (Object)class_243.field_1353).forGetter(map -> map.get(class_2350.field_11035)), (App)class_243.field_38277.optionalFieldOf("east", (Object)class_243.field_1353).forGetter(map -> map.get(class_2350.field_11034)), (App)class_243.field_38277.optionalFieldOf("west", (Object)class_243.field_1353).forGetter(map -> map.get(class_2350.field_11039)), (App)class_243.field_38277.optionalFieldOf("north_east", (Object)class_243.field_1353).forGetter(map -> map.get((byte)1)), (App)class_243.field_38277.optionalFieldOf("south_east", (Object)class_243.field_1353).forGetter(map -> map.get((byte)5)), (App)class_243.field_38277.optionalFieldOf("south_west", (Object)class_243.field_1353).forGetter(map -> map.get((byte)9)), (App)class_243.field_38277.optionalFieldOf("north_west", (Object)class_243.field_1353).forGetter(map -> map.get((byte)13))).apply((Applicative)instance, PortalOffsets::new));
    private final class_243[] lookup = new class_243[16];
    private final float width;
    private final float height;
    private boolean enabled;

    public PortalOffsets(float width, float height) {
        this.width = width;
        this.height = height;
    }

    public PortalOffsets(boolean enabled, float width, float height, class_243 position, class_243 north, class_243 south, class_243 east, class_243 west, class_243 northEast, class_243 southEast, class_243 southWest, class_243 northWest) {
        this(width, height);
        byte i;
        if (position.method_1033() != 0.0) {
            this.put(class_2350.field_11043, position);
        } else {
            this.put(class_2350.field_11043, north);
        }
        this.put(class_2350.field_11035, south);
        this.put(class_2350.field_11034, east);
        this.put(class_2350.field_11039, west);
        for (i = 1; i <= 3; i = (byte)((byte)(i + 1))) {
            this.put(i, northEast);
        }
        for (i = 5; i <= 7; i = (byte)((byte)(i + 1))) {
            this.put(i, southEast);
        }
        for (i = 9; i <= 11; i = (byte)(i + 1)) {
            this.put(i, southWest);
        }
        for (i = 13; i <= 15; i = (byte)(i + 1)) {
            this.put(i, northWest);
        }
        this.enabled = enabled;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public class_243 get(byte direction) {
        if (direction < 0 || direction > 15) {
            throw new IllegalArgumentException("Direction must be between 0 and 15, inclusive.");
        }
        return this.lookup[direction];
    }

    public class_243 get(class_2350 dir) {
        return switch (dir) {
            case class_2350.field_11043 -> this.get((byte)0);
            case class_2350.field_11035 -> this.get((byte)8);
            case class_2350.field_11034 -> this.get((byte)4);
            case class_2350.field_11039 -> this.get((byte)12);
            default -> null;
        };
    }

    public void put(byte direction, class_243 offset) {
        if (direction < 0 || direction > 15) {
            throw new IllegalArgumentException("Direction must be between 0 and 15, inclusive.");
        }
        this.lookup[direction] = offset;
    }

    public void put(class_2350 dir, class_243 offset) {
        switch (dir) {
            case field_11043: {
                this.put((byte)0, offset);
                break;
            }
            case field_11035: {
                this.put((byte)8, offset);
                break;
            }
            case field_11034: {
                this.put((byte)4, offset);
                break;
            }
            case field_11039: {
                this.put((byte)12, offset);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid direction for portal offsets: " + String.valueOf(dir));
            }
        }
    }

    public class_243 apply(class_2350 dir, class_243 pos) {
        class_243 offset = this.get(dir);
        if (offset == null) {
            return pos;
        }
        return pos.method_1019(offset);
    }

    public class_243 apply(class_243 pos, byte direction) {
        class_243 offset = this.get(direction);
        if (offset == null) {
            return pos;
        }
        return pos.method_1019(offset);
    }
}

