/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.util;

import dev.amble.lib.data.CachedDirectedGlobalPos;
import dev.drtheo.queue.api.ActionQueue;
import dev.drtheo.queue.api.util.Value;
import dev.drtheo.scheduler.api.TimeUnit;
import dev.drtheo.scheduler.api.common.TaskStage;
import java.util.function.Consumer;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class SafePosSearch {
    private static final int SAFE_RADIUS = 3;

    public static void wrapSafe(CachedDirectedGlobalPos globalPos, Kind vSearch, boolean hSearch, Consumer<CachedDirectedGlobalPos> posConsumer) {
        Value ref = new Value(null);
        ActionQueue queue = SafePosSearch.findSafe(globalPos, vSearch, hSearch, (Value<class_2338>)ref);
        if (queue != null) {
            queue.thenRun(() -> {
                CachedDirectedGlobalPos resultPos = globalPos;
                if (ref.value != null) {
                    resultPos = resultPos.pos((class_2338)ref.value);
                }
                posConsumer.accept(resultPos);
            }).execute();
        } else {
            posConsumer.accept(globalPos);
        }
    }

    @Nullable
    public static ActionQueue findSafe(CachedDirectedGlobalPos globalPos, Kind vSearch, boolean hSearch, Value<class_2338> ref) {
        class_3218 world = globalPos.getWorld();
        class_2338 pos = globalPos.getPos();
        class_2791 chunk = globalPos.getWorld().method_22350(pos);
        if (SafePosSearch.isSafe(chunk, pos)) {
            return null;
        }
        ActionQueue queue = new ActionQueue();
        if (hSearch) {
            queue = SafePosSearch.findSafeXZ(queue, ref, world, pos, 3).thenRun(() -> {
                if (ref.value != null) {
                    globalPos.pos((class_2338)ref.value);
                }
            });
        }
        return switch (vSearch.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 2 -> SafePosSearch.findSafeCeiling(queue, ref, world, pos);
            case 1 -> SafePosSearch.findSafeFloor(queue, ref, world, pos);
            case 3 -> SafePosSearch.findSafeMedian(queue, ref, world, pos);
            case 0 -> queue;
        };
    }

    private static ActionQueue findSafeCeiling(ActionQueue queue, Value<class_2338> result, class_3218 world, class_2338 original) {
        return queue.thenRun(() -> {
            if (result.value != null) {
                return;
            }
            int y = world.method_22350(original).method_12005(class_2902.class_2903.field_13203, original.method_10263() & 0xF, original.method_10260() & 0xF) + 1;
            result.value = original.method_33096(y);
        });
    }

    private static ActionQueue findSafeFloor(ActionQueue queue, Value<class_2338> result, class_3218 world, class_2338 original) {
        SafeFloorHolder holder = new SafeFloorHolder((class_1937)world, original);
        return queue.thenRunSteps(() -> {
            if (result.value != null) {
                return true;
            }
            Iter state = holder.checkAndAdvance();
            if (state == Iter.SUCCESS) {
                result.value = holder.cursor;
            }
            return state != Iter.CONTINUE;
        }, TaskStage.startWorldTick((class_3218)world), TimeUnit.TICKS, 1, 3);
    }

    private static ActionQueue findSafeMedian(ActionQueue queue, Value<class_2338> result, class_3218 world, class_2338 original) {
        SafeMedianHolder holder = new SafeMedianHolder((class_1937)world, original);
        return queue.thenRunSteps(() -> {
            if (result.value != null) {
                return true;
            }
            DoubleIter state = holder.checkAndAdvance();
            if (state == DoubleIter.SUCCESS_A) {
                result.value = holder.upCursor;
            } else if (state == DoubleIter.SUCCESS_B) {
                result.value = holder.downCursor;
            }
            return state != DoubleIter.CONTINUE;
        }, TaskStage.startWorldTick((class_3218)world), TimeUnit.TICKS, 1, 3);
    }

    private static ActionQueue findSafeXZ(ActionQueue queue, Value<class_2338> result, class_3218 world, class_2338 original, int radius) {
        class_2338.class_2339 pos = original.method_25503();
        int minX = pos.method_10263() - radius;
        int maxX = pos.method_10263() + radius;
        int minZ = pos.method_10260() - radius;
        int maxZ = pos.method_10260() + radius;
        SafeXZHolder holder = new SafeXZHolder((class_1937)world, pos, maxX, maxZ, minX, minZ);
        return queue.thenRunSteps(() -> {
            Iter state = holder.checkAndAdvance();
            if (state == Iter.SUCCESS) {
                result.value = holder.pos.method_10062();
            }
            return state != Iter.CONTINUE;
        }, TaskStage.startWorldTick((class_3218)world), TimeUnit.TICKS, 1, 3);
    }

    private static boolean isSafe(class_2791 chunk, class_2338 pos) {
        class_2680 floor = chunk.method_8320(pos.method_10074());
        if (!floor.method_51366()) {
            return false;
        }
        class_2680 curUp = chunk.method_8320(pos);
        class_2680 aboveUp = chunk.method_8320(pos.method_10084());
        return !curUp.method_51366() && !aboveUp.method_51366();
    }

    private static boolean isSafe(class_2680 floor, class_2680 block1, class_2680 block2) {
        return floor.method_51366() && !block1.method_51366() && !block2.method_51366();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Kind implements class_3542
    {
        NONE{

            @Override
            public Kind next() {
                return FLOOR;
            }
        }
        ,
        FLOOR{

            @Override
            public Kind next() {
                return CEILING;
            }
        }
        ,
        CEILING{

            @Override
            public Kind next() {
                return MEDIAN;
            }
        }
        ,
        MEDIAN{

            @Override
            public Kind next() {
                return NONE;
            }
        };


        public String method_15434() {
            return this.toString();
        }

        public class_5250 text() {
            return class_2561.method_43471((String)("message.ait.control.ylandtype." + this.method_15434().toLowerCase()));
        }

        public abstract Kind next();
    }

    static class SafeFloorHolder {
        class_2338 cursor;
        class_2680 floor;
        class_2680 current;
        class_2680 above;
        final class_2791 chunk;
        final int maxY;

        public SafeFloorHolder(class_1937 world, class_2338 pos) {
            this.chunk = world.method_22350(pos);
            this.maxY = this.chunk.method_31600();
            int minY = this.chunk.method_31607();
            this.cursor = pos.method_33096(minY + 2);
            this.floor = this.chunk.method_8320(this.cursor.method_10074());
            this.current = this.chunk.method_8320(this.cursor);
            this.above = this.chunk.method_8320(this.cursor.method_10084());
        }

        public Iter checkAndAdvance() {
            if (this.cursor.method_10264() >= this.maxY) {
                return Iter.FAIL;
            }
            if (SafePosSearch.isSafe(this.floor, this.current, this.above)) {
                return Iter.SUCCESS;
            }
            this.cursor = this.cursor.method_10084();
            this.floor = this.current;
            this.current = this.above;
            this.above = this.chunk.method_8320(this.cursor);
            return Iter.CONTINUE;
        }
    }

    static class SafeMedianHolder {
        class_2338 upCursor;
        class_2680 floorUp;
        class_2680 curUp;
        class_2680 aboveUp;
        class_2338 downCursor;
        class_2680 floorDown;
        class_2680 curDown;
        class_2680 aboveDown;
        final class_2791 chunk;

        public SafeMedianHolder(class_1937 world, class_2338 pos) {
            this.chunk = world.method_22350(pos);
            this.upCursor = pos.method_10084();
            this.floorUp = this.chunk.method_8320(this.upCursor.method_10074());
            this.curUp = this.chunk.method_8320(this.upCursor);
            this.aboveUp = this.chunk.method_8320(this.upCursor.method_10084());
            this.downCursor = pos.method_10074();
            this.floorDown = this.chunk.method_8320(this.downCursor.method_10074());
            this.curDown = this.chunk.method_8320(this.downCursor);
            this.aboveDown = this.chunk.method_8320(this.downCursor.method_10084());
        }

        public DoubleIter checkAndAdvance() {
            boolean canGoDown;
            boolean canGoUp = this.upCursor.method_10264() < this.chunk.method_31600();
            boolean bl = canGoDown = this.downCursor.method_10264() > this.chunk.method_31607();
            if (!canGoUp && !canGoDown) {
                return DoubleIter.FAIL;
            }
            if (canGoUp) {
                if (SafePosSearch.isSafe(this.floorUp, this.curUp, this.aboveUp)) {
                    this.upCursor = this.upCursor.method_10074();
                    return DoubleIter.SUCCESS_A;
                }
                this.upCursor = this.upCursor.method_10084();
                this.floorUp = this.curUp;
                this.curUp = this.aboveUp;
                this.aboveUp = this.chunk.method_8320(this.upCursor);
            }
            if (canGoDown) {
                if (SafePosSearch.isSafe(this.floorDown, this.curDown, this.aboveDown)) {
                    this.downCursor = this.downCursor.method_10084();
                    return DoubleIter.SUCCESS_B;
                }
                this.downCursor = this.downCursor.method_10074();
                this.curDown = this.aboveDown;
                this.aboveDown = this.floorDown;
                this.floorDown = this.chunk.method_8320(this.downCursor);
            }
            return DoubleIter.CONTINUE;
        }
    }

    static class SafeXZHolder {
        int x;
        int z;
        class_2791 prevChunk;
        final class_1937 world;
        final class_2338.class_2339 pos;
        final int maxX;
        final int maxZ;
        final int minX;

        public SafeXZHolder(class_1937 world, class_2338.class_2339 pos, int maxX, int maxZ, int minX, int minZ) {
            this.world = world;
            this.pos = pos;
            this.maxX = maxX;
            this.maxZ = maxZ;
            this.minX = minX;
            this.x = minX;
            this.z = minZ;
        }

        public Iter checkAndAdvance() {
            if (this.z >= this.maxZ) {
                return Iter.FAIL;
            }
            if (this.x >= this.maxX) {
                this.x = this.minX;
                ++this.z;
                return Iter.CONTINUE;
            }
            this.pos.method_33097(this.x).method_33099(this.z);
            class_1923 tempPos = new class_1923((class_2338)this.pos);
            if (this.prevChunk == null || !this.prevChunk.method_12004().equals((Object)tempPos)) {
                this.prevChunk = this.world.method_8497(tempPos.field_9181, tempPos.field_9180);
            }
            if (SafePosSearch.isSafe(this.prevChunk, (class_2338)this.pos)) {
                return Iter.SUCCESS;
            }
            ++this.x;
            return Iter.CONTINUE;
        }

        public class_2338 pos() {
            return this.pos.method_10062();
        }
    }

    static enum Iter {
        SUCCESS,
        FAIL,
        CONTINUE;

    }

    static enum DoubleIter {
        SUCCESS_A,
        SUCCESS_B,
        FAIL,
        CONTINUE;

    }
}

