/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.util;

import dev.amble.ait.AITMod;
import dev.amble.ait.core.AITDimensions;
import dev.amble.ait.core.entities.FlightTardisEntity;
import dev.amble.ait.module.planet.core.space.planet.Planet;
import dev.amble.ait.module.planet.core.space.planet.PlanetRenderInfo;
import dev.amble.ait.module.planet.core.space.system.Space;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class SpaceUtils {
    public static void init() {
    }

    private static void onWorldTick(class_3218 world) {
        SpaceUtils.checkPlayerTeleportation(world);
    }

    public static void checkPlayerTeleportation(class_3218 world) {
        ArrayList<class_3222> playersToTeleport = new ArrayList<class_3222>();
        ArrayList<class_3222> playersToSuck = new ArrayList<class_3222>();
        block0: for (class_3222 player : world.method_18456()) {
            if (player.method_37908().method_27983() != AITDimensions.SPACE) continue;
            class_243 playerPos = player.method_19538();
            for (Planet planet : Space.getInstance().getPlanets()) {
                PlanetRenderInfo planetInfo = planet.render();
                class_243 planetPos = planetInfo.position();
                double planetRadius = planetInfo.radius();
                double suctionRadius = planetInfo.suctionRadius();
                double distance = planetPos.method_1022(playerPos);
                if (distance < suctionRadius) {
                    playersToSuck.add(player);
                    SpaceUtils.applySuction(playersToSuck, planetPos);
                }
                if (!(distance < planetRadius)) continue;
                playersToSuck.remove(player);
                playersToTeleport.add(player);
                continue block0;
            }
        }
        for (class_3222 player : playersToTeleport) {
            SpaceUtils.teleportPlayerToTouchingPlanet(player);
        }
    }

    private static void applySuction(List<class_3222> player, class_243 planetPos) {
        player.forEach(entity -> {
            if (entity.method_7325()) {
                return;
            }
            class_1297 patt0$temp = entity.method_5854();
            if (patt0$temp instanceof FlightTardisEntity) {
                FlightTardisEntity tardis = (FlightTardisEntity)patt0$temp;
                if (tardis.tardis() != null && ((Boolean)tardis.tardis().get().travel().antigravs().get()).booleanValue()) {
                    return;
                }
                motion = planetPos.method_1020(tardis.method_19538()).method_1029().method_1021((double)0.1f);
                tardis.method_18799(tardis.method_18798().method_1019(motion));
                tardis.field_6007 = true;
                tardis.field_6037 = true;
            } else {
                motion = planetPos.method_1020(entity.method_19538()).method_1029().method_1021((double)0.1f);
                entity.method_18799(entity.method_18798().method_1019(motion));
                entity.field_6007 = true;
                entity.field_6037 = true;
            }
        });
    }

    private static void teleportPlayerToTouchingPlanet(class_3222 player) {
        MinecraftServer server = player.method_5682();
        if (server == null) {
            return;
        }
        class_2960 target = SpaceUtils.getTouchingPlanet((class_1297)player).orElse(null);
        if (target == null) {
            return;
        }
        class_5321 targetWorldKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)target);
        class_3218 targetWorld = server.method_3847(targetWorldKey);
        if (targetWorld != null) {
            player.method_48105(targetWorld, player.method_23317(), (double)targetWorld.method_31600(), player.method_23321(), Set.of(), player.method_36454(), player.method_36455());
        } else {
            AITMod.LOGGER.error("Teleporting to planets -> Dimension {} not found!", (Object)target);
        }
    }

    private static Optional<class_2960> getTouchingPlanet(class_1297 entity) {
        for (Planet planet : Space.getInstance().getPlanets()) {
            PlanetRenderInfo planetInfo = planet.render();
            class_243 planetPos = planetInfo.position();
            double planetRadius = planetInfo.radius();
            double distance = planetPos.method_1022(entity.method_19538());
            if (!(distance < planetRadius) || !planet.hasLandableSurface()) continue;
            return Optional.of(planet.dimension());
        }
        return Optional.empty();
    }

    static {
        ServerTickEvents.END_WORLD_TICK.register(SpaceUtils::onWorldTick);
    }
}

