/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.world;

import com.mojang.serialization.Codec;
import dev.amble.ait.AITMod;
import dev.amble.ait.core.events.ServerChunkEvents;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import net.fabricmc.fabric.api.attachment.v1.AttachmentRegistry;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2839;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5281;
import net.minecraft.class_5425;

public record RiftChunkManager(class_3218 world) {
    private static final AttachmentType<Double> ARTRON = AttachmentRegistry.createPersistent((class_2960)AITMod.id("artron"), (Codec)Codec.DOUBLE);
    private static final AttachmentType<Double> MAX_ARTRON = AttachmentRegistry.createPersistent((class_2960)AITMod.id("max_artron"), (Codec)Codec.DOUBLE);

    public static void init() {
        ServerChunkEvents.TICK.register((world, chunk) -> {
            class_1923 pos;
            if (world.method_8503().method_3780() % 20 != 0) {
                return;
            }
            RiftChunkManager manager = RiftChunkManager.getInstance(world);
            if (!manager.isRiftChunk(pos = chunk.method_12004())) {
                return;
            }
            if (manager.getMaxArtron(pos) < manager.getArtron(pos)) {
                manager.addFuel(chunk.method_12004(), 1.0);
            }
        });
    }

    public static RiftChunkManager getInstance(class_3218 world) {
        return new RiftChunkManager(world);
    }

    public double getArtron(class_1923 pos) {
        if (!this.isRiftChunk(pos)) {
            return 0.0;
        }
        class_2791 shouldBeProtoChunk = this.world.method_14178().method_12121(pos.field_9181, pos.field_9180, class_2806.field_16423, true);
        if (!(shouldBeProtoChunk instanceof class_2839)) {
            return 0.0;
        }
        class_2839 protoChunk = (class_2839)shouldBeProtoChunk;
        return (Double)protoChunk.getAttachedOrCreate(ARTRON, () -> this.world.method_8409().method_39332(100, 800));
    }

    public double getMaxArtron(class_1923 pos) {
        if (!this.isRiftChunk(pos)) {
            return 0.0;
        }
        class_2791 shouldBeProtoChunk = this.world.method_14178().method_12121(pos.field_9181, pos.field_9180, class_2806.field_16423, true);
        if (!(shouldBeProtoChunk instanceof class_2839)) {
            return 0.0;
        }
        class_2839 protoChunk = (class_2839)shouldBeProtoChunk;
        return (Double)protoChunk.getAttachedOrCreate(ARTRON, () -> this.world.method_8409().method_39332(300, 1000));
    }

    public double removeFuel(class_1923 pos, double amount) {
        double artron;
        if (!this.isRiftChunk(pos)) {
            return 0.0;
        }
        artron -= (artron = this.getArtron(pos)) < amount ? 0.0 : amount;
        class_2791 shouldBeProtoChunk = this.world.method_14178().method_12121(pos.field_9181, pos.field_9180, class_2806.field_16423, true);
        if (shouldBeProtoChunk instanceof class_2839) {
            class_2839 protoChunk = (class_2839)shouldBeProtoChunk;
            protoChunk.setAttached(ARTRON, (Object)artron);
        }
        return artron - amount;
    }

    public void addFuel(class_1923 pos, double amount) {
        if (!this.isRiftChunk(pos)) {
            return;
        }
        RiftChunkManager.addFuel((class_5425)this.world, pos, amount);
    }

    public void setCurrentFuel(class_1923 pos, double amount) {
        class_2791 shouldBeProtoChunk = this.world.method_14178().method_12121(pos.field_9181, pos.field_9180, class_2806.field_16423, true);
        if (shouldBeProtoChunk instanceof class_2839) {
            class_2839 protoChunk = (class_2839)shouldBeProtoChunk;
            protoChunk.modifyAttached(ARTRON, d -> amount);
        }
    }

    public boolean isRiftChunk(class_1923 chunkPos) {
        return RiftChunkManager.isRiftChunk((class_5281)this.world, chunkPos);
    }

    public boolean isRiftChunk(class_2338 pos) {
        return RiftChunkManager.isRiftChunk((class_5281)this.world, pos);
    }

    public static boolean isRiftChunk(CachedDirectedGlobalPos cached) {
        return RiftChunkManager.isRiftChunk((class_5281)cached.getWorld(), cached.getPos());
    }

    public static boolean isRiftChunk(class_5281 world, class_2338 pos) {
        return RiftChunkManager.isRiftChunk(world, new class_1923(pos));
    }

    public static boolean isRiftChunk(class_5281 world, class_1923 pos) {
        return class_2919.method_12662((int)pos.field_9181, (int)pos.field_9180, (long)world.method_8412(), (long)987234910L).method_43048(8) == 0;
    }

    private static void addFuel(class_5425 world, class_1923 pos, double amount) {
        class_2791 shouldBeProtoChunk = world.method_8398().method_12121(pos.field_9181, pos.field_9180, class_2806.field_16423, true);
        if (shouldBeProtoChunk instanceof class_2839) {
            class_2839 protoChunk = (class_2839)shouldBeProtoChunk;
            protoChunk.modifyAttached(ARTRON, d -> d + amount);
        }
    }

    public static double getFuel(class_3218 world, class_1923 pos) {
        if (!RiftChunkManager.isRiftChunk((class_5281)world, pos)) {
            return 0.0;
        }
        class_2791 shouldBeProtoChunk = world.method_14178().method_12121(pos.field_9181, pos.field_9180, class_2806.field_16423, true);
        if (!(shouldBeProtoChunk instanceof class_2839)) {
            return 0.0;
        }
        class_2839 protoChunk = (class_2839)shouldBeProtoChunk;
        return (Double)protoChunk.getAttachedOrCreate(ARTRON, () -> world.method_8409().method_39332(100, 800));
    }

    public static double getMaxFuel(class_3218 world, class_1923 pos) {
        if (!RiftChunkManager.isRiftChunk((class_5281)world, pos)) {
            return 0.0;
        }
        class_2791 shouldBeProtoChunk = world.method_14178().method_12121(pos.field_9181, pos.field_9180, class_2806.field_16423, true);
        if (!(shouldBeProtoChunk instanceof class_2839)) {
            return 0.0;
        }
        class_2839 protoChunk = (class_2839)shouldBeProtoChunk;
        return (Double)protoChunk.getAttachedOrCreate(MAX_ARTRON, () -> world.method_8409().method_39332(300, 1000));
    }
}

