/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.data;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public record Loyalty(int level, Type type) {
    public static final Codec<Loyalty> CODEC = Codec.either((Codec)Codec.STRING, (Codec)Codec.INT).xmap(either -> (Loyalty)either.mapLeft(Type::get).map(Loyalty::new, Loyalty::fromLevel), loyalty -> Either.right((Object)loyalty.level));

    public Loyalty(Type type) {
        this(type.level, type);
    }

    public Loyalty add(int level) {
        return Loyalty.fromLevel(this.level + level);
    }

    public Loyalty subtract(int level) {
        return Loyalty.fromLevel(this.level - level);
    }

    public boolean greaterOrEqual(Loyalty other) {
        return this.level >= other.level;
    }

    public boolean smallerOrEqual(Loyalty other) {
        return this.level <= other.level;
    }

    public boolean smallerThan(Loyalty other) {
        return this.level < other.level;
    }

    public boolean isOf(Type type) {
        return this.level >= type.level;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Loyalty)) return false;
        Loyalty other = (Loyalty)obj;
        if (this.level != other.level) return false;
        return true;
    }

    public static Loyalty fromLevel(int level) {
        level = Type.normalize(level);
        return new Loyalty(level, Type.get(level));
    }

    public static Loyalty deserialize(Type type, Optional<Integer> level) {
        return level.map(Loyalty::fromLevel).orElseGet(() -> new Loyalty(type));
    }

    public static Loyalty deserialize(Optional<String> type, Optional<Integer> level) {
        return Loyalty.deserialize(type.map(Type::valueOf).orElse(null), level);
    }

    public static enum Type {
        REJECT(0),
        NEUTRAL(125),
        COMPANION(245),
        PILOT(450),
        OWNER(500);

        public final int level;

        private Type(int start) {
            this.level = start;
        }

        public static Type get(String id) {
            return Type.valueOf(id.toUpperCase());
        }

        public static Type get(int level) {
            level = Type.normalize(level);
            for (int i = 0; i < Type.values().length - 1; ++i) {
                Type current = Type.values()[i];
                Type next = Type.values()[i + 1];
                if (current.level > level || level >= next.level) continue;
                return current;
            }
            return OWNER;
        }

        public static int normalize(int level) {
            return Math.min(Math.max(level, Type.REJECT.level), Type.OWNER.level);
        }

        public Type next() {
            return switch (this.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> NEUTRAL;
                case 1 -> COMPANION;
                case 2 -> PILOT;
                case 3 -> OWNER;
                case 4 -> REJECT;
            };
        }

        public class_5250 text() {
            return class_2561.method_43471((String)("tardis.loyalty.name." + this.name().toLowerCase()));
        }
    }
}

