/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.data;

import com.mojang.datafixers.util.Either;
import dev.amble.ait.core.tardis.Tardis;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public abstract class TardisMap<T>
extends ConcurrentHashMap<UUID, T> {
    private TardisMap() {
    }

    public static class Optional<T extends Tardis>
    extends TardisMap<Either<T, Exception>> {
        private Either<T, Exception> wrap(T t) {
            return Either.left(t);
        }

        private Either<T, Exception> wrap(Exception e) {
            return Either.right((Object)e);
        }

        @Nullable
        public Either<T, Exception> put(T t) {
            if (t == null) {
                return null;
            }
            return this.put(((Tardis)t).getUuid(), this.wrap(t));
        }

        public void empty(UUID id, Exception e) {
            this.put(id, this.wrap(e));
        }
    }

    public static class Direct<T extends Tardis>
    extends TardisMap<T> {
        public T put(T t) {
            return (T)((Tardis)super.put(((Tardis)t).getUuid(), t));
        }
    }
}

