/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.data.enummap;

import dev.amble.ait.data.enummap.Ordered;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class EnumMap<K extends Ordered, V> {
    private final V[] values;

    public EnumMap(Supplier<K[]> values, Function<Integer, V[]> supplier) {
        this.values = supplier.apply(((Ordered[])values.get()).length);
    }

    public void map(Function<V, V> func) {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = func.apply(this.values[i]);
        }
    }

    public V[] getValues() {
        return this.values;
    }

    public V put(K k, V v) {
        V prev = this.values[k.index()];
        this.values[k.index()] = v;
        return prev;
    }

    public V remove(K k) {
        return this.put(k, null);
    }

    public V get(K k) {
        return this.get(k.index());
    }

    public V get(int index) {
        return this.values[index];
    }

    public boolean containsKey(K k) {
        if (this.size() - 1 < k.index()) {
            return false;
        }
        return this.get(k) != null;
    }

    public void clear() {
        Arrays.fill(this.values, null);
    }

    public int size() {
        return this.values.length;
    }

    public static class Compliant<K extends Ordered, V>
    extends EnumMap<K, V>
    implements Map<K, V> {
        private final K[] keys;

        public Compliant(Supplier<K[]> values, Function<Integer, V[]> supplier) {
            super(values, supplier);
            this.keys = (Ordered[])values.get();
        }

        @Override
        public V remove(Object k) {
            return ((EnumMap)this).remove((Ordered)k);
        }

        @Override
        public V get(Object key) {
            return ((EnumMap)this).get((Ordered)key);
        }

        @Override
        public void putAll(@NotNull Map<? extends K, ? extends V> m) {
            m.forEach(this::put);
        }

        @Override
        public boolean containsKey(Object key) {
            return ((EnumMap)this).containsKey((Ordered)key);
        }

        @Override
        @NotNull
        public Set<Map.Entry<K, V>> entrySet() {
            V[] values = this.getValues();
            HashSet<Map.Entry<K, V>> set = new HashSet<Map.Entry<K, V>>(values.length);
            for (int i = 0; i < this.size(); ++i) {
                Object value = values[i];
                if (value == null) continue;
                set.add(Map.entry(this.keys[i], value));
            }
            return set;
        }

        @Override
        @NotNull
        public Set<K> keySet() {
            return Set.of(this.keys);
        }

        @Override
        @NotNull
        public Collection<V> values() {
            return List.of(this.getValues());
        }

        @Override
        public boolean isEmpty() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsValue(Object value) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

