/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.data.landing;

import com.google.common.collect.ImmutableCollection;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.amble.ait.core.tardis.manager.ServerTardisManager;
import dev.amble.ait.data.landing.LandingPadSpot;
import dev.amble.lib.util.ServerLifecycleHooks;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import org.jetbrains.annotations.Nullable;

public class LandingPadRegion {
    public static final Codec<LandingPadRegion> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("chunk").forGetter(o -> o.getChunk().method_8324()), (App)Codec.INT.fieldOf("y").forGetter(LandingPadRegion::getDefaultY), (App)Codec.list(LandingPadSpot.CODEC).fieldOf("spots").forGetter(o -> o.spots), (App)Codec.STRING.fieldOf("code").forGetter(LandingPadRegion::getLandingCode)).apply((Applicative)instance, LandingPadRegion::create));
    private static final int CHUNK_LENGTH = 16;
    private static final int MAX_SPOTS = 64;
    private static final int MAX_PER_ROW = 8;
    private final class_1923 chunk;
    private final List<LandingPadSpot> spots;
    private final int defaultY;
    private String landingCode;

    private static LandingPadRegion create(long chunk, int y, List<LandingPadSpot> spots, String landingCode) {
        if (spots instanceof ImmutableCollection) {
            spots = new ArrayList<LandingPadSpot>(spots);
        }
        return new LandingPadRegion(new class_1923(chunk), y, spots, landingCode);
    }

    private LandingPadRegion(class_1923 chunk, int y, List<LandingPadSpot> spots, String landingCode) {
        this.chunk = chunk;
        this.spots = spots;
        this.landingCode = landingCode;
        this.defaultY = y;
        if (spots.isEmpty()) {
            this.createAllSpots();
        }
    }

    public LandingPadRegion(class_1923 pos, int y, String landingCode) {
        this(pos, y, new ArrayList<LandingPadSpot>(), landingCode);
    }

    @Nullable
    public LandingPadSpot getFreeSpot() {
        for (LandingPadSpot spot : this.spots) {
            if (spot.isOccupied()) continue;
            return spot;
        }
        return null;
    }

    private LandingPadSpot createSpot() {
        if (this.spots.isEmpty()) {
            return new LandingPadSpot(new class_2338(this.chunk.method_8326() + 1, this.defaultY, this.chunk.method_8328() + 1));
        }
        float rowCount = (float)this.spots.size() / 8.0f;
        boolean isNewRow = rowCount == (float)Math.round(rowCount);
        class_2338 lastPos = this.spots.get(this.spots.size() - 1).getPos();
        if (!isNewRow) {
            return new LandingPadSpot(lastPos.method_10069(2, 0, 0));
        }
        return new LandingPadSpot(new class_2338(this.spots.get(0).getPos().method_10263(), this.defaultY, lastPos.method_10260() + 2));
    }

    private LandingPadSpot generateSpot() {
        LandingPadSpot created = this.createSpot();
        this.spots.add(created);
        return created;
    }

    public List<LandingPadSpot> getSpots() {
        return this.spots;
    }

    public int getDefaultY() {
        return this.defaultY;
    }

    public class_1923 getChunk() {
        return this.chunk;
    }

    public String getLandingCode() {
        return this.landingCode;
    }

    public void setLandingCode(String string) {
        this.landingCode = string;
    }

    private boolean isFull() {
        return this.getFreeSpot() == null;
    }

    private void createAllSpots() {
        int toCreate = 64 - this.spots.size();
        for (int i = 0; i < toCreate; ++i) {
            this.generateSpot();
        }
    }

    public Optional<LandingPadSpot> getSpotAt(class_2338 pos) {
        if (this.chunk.method_8324() != new class_1923(pos).method_8324()) {
            return Optional.empty();
        }
        for (LandingPadSpot spot : this.spots) {
            class_2338 p = spot.getPos();
            if (p.method_10263() != pos.method_10263() || p.method_10260() != pos.method_10260()) continue;
            return Optional.of(spot);
        }
        return Optional.empty();
    }

    public LandingPadSpot createSpotAt(class_2338 pos) {
        LandingPadSpot existing = this.getSpotAt(pos).orElse(null);
        if (existing != null) {
            return existing;
        }
        LandingPadSpot created = new LandingPadSpot(pos);
        this.spots.add(created);
        return created;
    }

    public void removeSpotAt(class_2338 pos) {
        LandingPadSpot existing = this.getSpotAt(pos).orElse(null);
        if (existing == null) {
            return;
        }
        this.removeSpot(existing);
    }

    private void removeSpot(LandingPadSpot spot) {
        this.spots.remove(spot);
        if (!spot.isOccupied()) {
            return;
        }
        ServerTardisManager.getInstance().getTardis(ServerLifecycleHooks.get(), spot.getReference().getId(), tardis -> tardis.landingPad().release());
    }

    public String toString() {
        return "LandingPadRegion{chunk=" + String.valueOf(this.chunk) + ", spots=" + String.valueOf(this.spots) + ", defaultY=" + this.defaultY + "}";
    }
}

