/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.data.landing;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.amble.ait.api.tardis.link.v2.TardisRef;
import dev.amble.ait.core.tardis.Tardis;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_2338;

public class LandingPadSpot {
    public static final Codec<LandingPadSpot> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("tardis").forGetter(o -> {
        TardisRef ref = o.getReference();
        if (ref != null && ref.getId() != null) {
            return Optional.of(ref.getId().toString());
        }
        return Optional.empty();
    }), (App)class_2338.field_25064.fieldOf("pos").forGetter(LandingPadSpot::getPos)).apply((Applicative)instance, LandingPadSpot::create));
    private class_2338 pos;
    private TardisRef tardis;

    private static LandingPadSpot create(Optional<String> tardis, class_2338 pos) {
        UUID id = null;
        if (tardis.isPresent()) {
            id = UUID.fromString(tardis.get());
        }
        return new LandingPadSpot(id, pos);
    }

    private LandingPadSpot(UUID tardis, class_2338 pos) {
        if (tardis != null) {
            this.tardis = new TardisRef(tardis, uuid -> null);
        }
        this.pos = pos;
    }

    public LandingPadSpot(class_2338 pos) {
        this.pos = pos;
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public void setPos(class_2338 pos) {
        this.pos = pos;
    }

    public TardisRef getReference() {
        return this.tardis;
    }

    public void claim(Tardis tardis) {
        if (this.isOccupied() && !this.tardis.getId().equals(tardis.getUuid()) && !this.tardis.contains(tardis)) {
            throw new IllegalStateException("Spot at %s already occupied by %s cannot be claimed by %s".formatted(this.pos, this.tardis.getId(), tardis.getUuid()));
        }
        this.tardis = new TardisRef(tardis, uuid -> null);
        this.pos = tardis.travel().destination().getPos();
    }

    public TardisRef release() {
        TardisRef result = this.tardis;
        this.tardis = null;
        return result;
    }

    public boolean isOccupied() {
        return this.tardis != null && this.tardis.getId() != null;
    }

    public String toString() {
        return "LandingPadSpot{pos=" + String.valueOf(this.pos) + ", tardis=" + String.valueOf(this.tardis) + "}";
    }
}

