/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.data.properties;

import dev.amble.ait.api.tardis.KeyedTardisComponent;
import dev.amble.ait.data.properties.PropertyType;
import dev.amble.ait.data.properties.Value;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import dev.amble.lib.data.DirectedGlobalPos;
import java.util.HashSet;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.joml.Vector2i;

public class Property<T> {
    private final PropertyType<T> type;
    private final String name;
    protected final Function<KeyedTardisComponent, T> def;
    public static final PropertyType.Nullable<DirectedGlobalPos> DIRECTED_GLOBAL_POS = new PropertyType.Nullable<DirectedGlobalPos>(DirectedGlobalPos.class, (buf, pos) -> pos.write(buf), DirectedGlobalPos::read);
    public static final PropertyType.Nullable<class_2338> BLOCK_POS = new PropertyType.Nullable<class_2338>(class_2338.class, class_2540::method_10807, class_2540::method_10811);
    public static final PropertyType.Nullable<CachedDirectedGlobalPos> CDIRECTED_GLOBAL_POS = new PropertyType.Nullable<CachedDirectedGlobalPos>(CachedDirectedGlobalPos.class, (buf, pos) -> pos.write(buf), CachedDirectedGlobalPos::read);
    public static final PropertyType.Nullable<class_2960> IDENTIFIER = new PropertyType.Nullable<class_2960>(class_2960.class, class_2540::method_10812, class_2540::method_10810);
    public static final PropertyType.Nullable<Long> LONG = new PropertyType.Nullable<Long>(Long.class, class_2540::writeLong, class_2540::readLong);
    public static final PropertyType.Nullable<class_5321<class_1937>> WORLD_KEY = new PropertyType.Nullable<class_5321>(class_5321.class, class_2540::method_44116, buf -> buf.method_44112(class_7924.field_41223));
    public static final PropertyType<class_2350> DIRECTION = PropertyType.forEnum(class_2350.class);
    public static final PropertyType.Nullable<Vector2i> VEC2I = new PropertyType.Nullable<Vector2i>(Vector2i.class, (buf, vector2i) -> {
        buf.writeInt(vector2i.x);
        buf.writeInt(vector2i.y);
    }, buf -> new Vector2i(buf.readInt(), buf.readInt()));
    public static final PropertyType.Nullable<String> STR = new PropertyType.Nullable<String>(String.class, class_2540::method_10814, class_2540::method_19772);
    public static final PropertyType.Nullable<UUID> UUID = new PropertyType.Nullable<UUID>(UUID.class, class_2540::method_10797, class_2540::method_10790);
    public static final PropertyType.Nullable<Double> DOUBLE = new PropertyType.Nullable<Double>(Double.class, class_2540::writeDouble, class_2540::readDouble);
    public static final PropertyType.Nullable<HashSet<String>> STR_SET = new PropertyType.Nullable<HashSet>(HashSet.class, (buf, strings) -> {
        buf.method_10804(strings.size());
        for (String str : strings) {
            buf.method_10814(str);
        }
    }, buf -> {
        HashSet<String> result = new HashSet<String>();
        int size = buf.method_10816();
        for (int i = 0; i < size; ++i) {
            result.add(buf.method_19772());
        }
        return result;
    });
    public static final PropertyType.Nullable<class_1799> ITEM_STACK = new PropertyType.Nullable<class_1799>(class_1799.class, class_2540::method_10793, class_2540::method_10819);

    public Property(PropertyType<T> type, String name, Function<KeyedTardisComponent, T> def) {
        this.type = type;
        this.name = name;
        this.def = def;
    }

    public Property(PropertyType<T> type, String name, T def) {
        this((PropertyType<Function<KeyedTardisComponent, Object>>)type, name, o -> def);
    }

    public Property(PropertyType.Nullable<T> type, String name) {
        this((PropertyType<Function<KeyedTardisComponent, Object>>)type, name, o -> null);
    }

    public Value<T> create(KeyedTardisComponent holder) {
        T t = this.def == null ? null : (T)this.def.apply(holder);
        Value<Object> result = this.create(t);
        result.of(holder, this);
        return result;
    }

    protected Value<T> create(T t) {
        return new Value<T>(t);
    }

    public String getName() {
        return this.name;
    }

    public PropertyType<T> getType() {
        return this.type;
    }

    public Property<T> copy(String name) {
        return new Property<Function<KeyedTardisComponent, T>>(this.type, name, this.def);
    }

    public Property<T> copy(String name, T def) {
        return new Property<T>(this.type, name, def);
    }

    public static <T extends Enum<T>> Property<T> forEnum(String name, Class<T> clazz, T def) {
        return new Property<T>(PropertyType.forEnum(clazz), name, def);
    }
}

