/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.data.properties.flt;

import dev.amble.ait.api.tardis.KeyedTardisComponent;
import dev.amble.ait.data.properties.Property;
import dev.amble.ait.data.properties.PropertyType;
import dev.amble.ait.data.properties.flt.FloatValue;
import java.util.function.Function;
import net.minecraft.class_2540;

public class FloatProperty
extends Property<Float> {
    public static final PropertyType<Float> TYPE = new PropertyType<Float>(Float.class, class_2540::writeFloat, class_2540::readFloat);

    public FloatProperty(String name) {
        this(name, 0.0f);
    }

    public FloatProperty(String name, Float def) {
        this(name, FloatProperty.normalize(def));
    }

    public FloatProperty(String name, float def) {
        super(TYPE, name, Float.valueOf(def));
    }

    public FloatProperty(String name, Function<KeyedTardisComponent, Float> def) {
        super(TYPE, name, def.andThen(FloatProperty::normalize));
    }

    public FloatValue create(KeyedTardisComponent holder) {
        return (FloatValue)super.create(holder);
    }

    protected FloatValue create(Float flt) {
        return new FloatValue(flt);
    }

    public static float normalize(Float value) {
        return value == null ? 0.0f : value.floatValue();
    }
}

