/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.data.properties.integer.ranged;

import dev.amble.ait.api.tardis.KeyedTardisComponent;
import dev.amble.ait.data.properties.Property;
import dev.amble.ait.data.properties.PropertyType;
import dev.amble.ait.data.properties.integer.ranged.RangedIntValue;
import java.util.function.Function;
import net.minecraft.class_2540;
import net.minecraft.class_3532;

public class RangedIntProperty
extends Property<Integer> {
    public static final PropertyType<Integer> TYPE = new PropertyType<Integer>(Integer.class, class_2540::writeInt, class_2540::readInt);
    private final int min;
    private final int max;

    public RangedIntProperty(String name, int max) {
        this(name, 0, max, 0);
    }

    public RangedIntProperty(String name, int max, Integer def) {
        this(name, 0, max, RangedIntProperty.normalize(0, max, def));
    }

    public RangedIntProperty(String name, int min, int max, Integer def) {
        super(TYPE, name, RangedIntProperty.normalize(min, max, def));
        this.min = min;
        this.max = max;
    }

    public RangedIntProperty(String name, int max, int def) {
        super(TYPE, name, def);
        this.min = 0;
        this.max = max;
    }

    public RangedIntProperty(String name, int min, int max, Function<KeyedTardisComponent, Integer> def) {
        super(TYPE, name, def.andThen(i -> RangedIntProperty.normalize(min, max, i)));
        this.min = min;
        this.max = max;
    }

    public RangedIntValue create(KeyedTardisComponent holder) {
        return (RangedIntValue)super.create(holder);
    }

    protected RangedIntValue create(Integer integer) {
        return new RangedIntValue(integer);
    }

    public static int normalize(int min, int max, Integer value) {
        return class_3532.method_15340((int)(value == null ? 0 : value), (int)min, (int)max);
    }

    public static int normalize(RangedIntProperty property, Integer value) {
        return RangedIntProperty.normalize(property.min, property.max, value);
    }
}

