/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.data.schema.console;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import dev.amble.ait.client.models.consoles.ConsoleModel;
import dev.amble.ait.data.schema.console.ConsoleVariantSchema;
import dev.amble.ait.data.schema.console.variant.hartnell.HartnellVariant;
import dev.amble.ait.registry.impl.console.variant.ClientConsoleVariantRegistry;
import dev.amble.ait.registry.impl.console.variant.ConsoleVariantRegistry;
import dev.amble.lib.api.Identifiable;
import java.lang.reflect.Type;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_151;
import net.minecraft.class_2960;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public abstract class ClientConsoleVariantSchema
implements Identifiable {
    private final class_2960 parent;
    private final class_2960 id;

    protected ClientConsoleVariantSchema(class_2960 parent, class_2960 id) {
        this.parent = parent;
        this.id = id;
    }

    protected ClientConsoleVariantSchema(class_2960 parent) {
        this.id = parent;
        this.parent = parent;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientConsoleVariantSchema)) return false;
        ClientConsoleVariantSchema other = (ClientConsoleVariantSchema)o;
        if (!this.id.equals((Object)other.id)) return false;
        return true;
    }

    public ConsoleVariantSchema parent() {
        return (ConsoleVariantSchema)ConsoleVariantRegistry.getInstance().get(this.parent);
    }

    public class_2960 id() {
        return this.id;
    }

    public abstract class_2960 texture();

    public abstract class_2960 emission();

    @Environment(value=EnvType.CLIENT)
    public abstract ConsoleModel model();

    public static Object serializer() {
        return new Serializer();
    }

    public Vector3f sonicItemTranslations() {
        return ConsoleVariantSchema.DEFAULT_SONIC_POS;
    }

    public float[] sonicItemRotations() {
        return ConsoleVariantSchema.DEFAULT_SONIC_ROTATION;
    }

    public Vector3f handlesTranslations() {
        return ConsoleVariantSchema.DEFAULT_HANDLES_POS;
    }

    public float[] handlesRotations() {
        return ConsoleVariantSchema.DEFAULT_HANDLES_ROTATION;
    }

    private static class Serializer
    implements JsonSerializer<ClientConsoleVariantSchema>,
    JsonDeserializer<ClientConsoleVariantSchema> {
        private Serializer() {
        }

        public ClientConsoleVariantSchema deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            class_2960 id;
            try {
                id = new class_2960(json.getAsJsonPrimitive().getAsString());
            }
            catch (class_151 e) {
                id = HartnellVariant.REFERENCE;
            }
            return (ClientConsoleVariantSchema)ClientConsoleVariantRegistry.getInstance().get(id);
        }

        public JsonElement serialize(ClientConsoleVariantSchema src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.id().toString());
        }
    }
}

