/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.data.schema.console;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import dev.amble.ait.AITMod;
import dev.amble.ait.data.Loyalty;
import dev.amble.ait.data.schema.BasicSchema;
import dev.amble.ait.data.schema.console.ClientConsoleVariantSchema;
import dev.amble.ait.data.schema.console.ConsoleTypeSchema;
import dev.amble.ait.registry.impl.console.ConsoleRegistry;
import dev.amble.ait.registry.impl.console.variant.ClientConsoleVariantRegistry;
import dev.amble.ait.registry.impl.console.variant.ConsoleVariantRegistry;
import dev.amble.lib.register.unlockable.Unlockable;
import java.lang.reflect.Type;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_151;
import net.minecraft.class_2960;
import org.joml.Vector3f;

public abstract class ConsoleVariantSchema
extends BasicSchema
implements Unlockable {
    public static final float[] DEFAULT_SONIC_ROTATION = new float[]{120.0f, 135.0f};
    public static final Vector3f DEFAULT_SONIC_POS = new Vector3f(0.1f, 1.2f, 0.26f);
    public static final float[] DEFAULT_HANDLES_ROTATION = new float[]{120.0f, 135.0f};
    public static final Vector3f DEFAULT_HANDLES_POS = new Vector3f(0.65f, 1.6f, 0.6f);
    private final class_2960 parent;
    private final class_2960 id;
    private final Loyalty loyalty;
    @Environment(value=EnvType.CLIENT)
    private ClientConsoleVariantSchema cachedSchema;

    protected ConsoleVariantSchema(class_2960 parent, class_2960 id, Optional<Loyalty> loyalty) {
        super("console");
        this.parent = parent;
        this.id = id;
        this.loyalty = loyalty.orElse(null);
    }

    protected ConsoleVariantSchema(class_2960 parent, class_2960 id, Loyalty loyalty) {
        this(parent, id, Optional.of(loyalty));
    }

    protected ConsoleVariantSchema(class_2960 parent, class_2960 id) {
        this(parent, id, Optional.empty());
    }

    public class_2960 id() {
        return this.id;
    }

    @Override
    public Optional<Loyalty> requirement() {
        return Optional.ofNullable(this.loyalty);
    }

    @Override
    public Unlockable.UnlockType unlockType() {
        return Unlockable.UnlockType.CONSOLE;
    }

    public class_2960 parentId() {
        return this.parent;
    }

    public ConsoleTypeSchema parent() {
        return (ConsoleTypeSchema)ConsoleRegistry.getInstance().get(this.parentId());
    }

    @Environment(value=EnvType.CLIENT)
    public ClientConsoleVariantSchema getClient() {
        if (this.cachedSchema == null) {
            this.cachedSchema = ClientConsoleVariantRegistry.withParent(this);
        }
        return this.cachedSchema;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConsoleVariantSchema)) return false;
        ConsoleVariantSchema other = (ConsoleVariantSchema)o;
        if (!this.id.equals((Object)other.id)) return false;
        return true;
    }

    public static Object serializer() {
        return new Serializer();
    }

    private static class Serializer
    implements JsonSerializer<ConsoleVariantSchema>,
    JsonDeserializer<ConsoleVariantSchema> {
        private Serializer() {
        }

        public ConsoleVariantSchema deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            class_2960 id;
            try {
                id = new class_2960(json.getAsJsonPrimitive().getAsString());
            }
            catch (class_151 e) {
                id = AITMod.id("console/borealis");
            }
            return (ConsoleVariantSchema)ConsoleVariantRegistry.getInstance().get(id);
        }

        public JsonElement serialize(ConsoleVariantSchema src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.id().toString());
        }
    }
}

