/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.data.schema.door;

import dev.amble.ait.client.AITModClient;
import dev.amble.ait.client.tardis.ClientTardis;
import dev.amble.ait.core.tardis.handler.DoorHandler;
import dev.amble.ait.data.schema.AnimatedFeature;
import dev.amble.lib.client.bedrock.BedrockAnimationReference;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_630;

public interface AnimatedDoor
extends AnimatedFeature {
    default public Optional<BedrockAnimationReference> getLeftAnimation() {
        return Optional.empty();
    }

    default public Optional<BedrockAnimationReference> getRightAnimation() {
        return Optional.empty();
    }

    default public class_243 getScale() {
        return new class_243(1.0, 1.0, 1.0);
    }

    default public class_243 getOffset() {
        return class_243.field_1353;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    default public void runAnimations(class_630 root, class_4587 matrices, float tickDelta, ClientTardis tardis) {
        DoorHandler doors = tardis.door();
        class_243 offset = this.getOffset().method_1021(-1.0);
        matrices.method_22904(offset.field_1352, offset.field_1351, offset.field_1350);
        class_243 scale = this.getScale();
        matrices.method_22905((float)scale.field_1352, (float)scale.field_1351, (float)scale.field_1350);
        matrices.method_22903();
        float leftProgress = doors.getLeftRot();
        float rightProgress = doors.getRightRot();
        if (!AITModClient.CONFIG.animateDoors) {
            leftProgress = doors.isLeftOpen() ? 1.0f : 0.0f;
            rightProgress = doors.isRightOpen() ? 1.0f : 0.0f;
        }
        float leftDelta = leftProgress == 1.0f || leftProgress == 0.0f ? 0.0f : tickDelta / 10.0f;
        float rightDelta = rightProgress == 1.0f || rightProgress == 0.0f ? 0.0f : tickDelta / 10.0f;
        float finalRightProgress = rightProgress - 0.001f;
        float finalLeftProgress = leftProgress - 0.001f;
        this.getLeftAnimation().flatMap(BedrockAnimationReference::get).ifPresent(anim -> anim.apply(root, (int)((double)finalLeftProgress * anim.animationLength * 20.0), leftDelta));
        this.getRightAnimation().flatMap(BedrockAnimationReference::get).ifPresent(anim -> anim.apply(root, (int)((double)finalRightProgress * anim.animationLength * 20.0), rightDelta));
        matrices.method_22909();
    }
}

