/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.data.schema.door;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.amble.ait.AITMod;
import dev.amble.ait.core.util.PortalOffsets;
import dev.amble.ait.data.schema.door.AnimatedDoor;
import dev.amble.ait.data.schema.door.DoorSchema;
import dev.amble.lib.client.bedrock.BedrockAnimationReference;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3414;

public class DatapackDoor
extends DoorSchema
implements AnimatedDoor {
    public static final Codec<DatapackDoor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("id").forGetter(DoorSchema::id), (App)class_2960.field_25139.fieldOf("open_sound").forGetter(DatapackDoor::getOpenSoundId), (App)class_2960.field_25139.fieldOf("close_sound").forGetter(DatapackDoor::getCloseSoundId), (App)class_2960.field_25139.fieldOf("model").forGetter(DatapackDoor::getModelId), (App)Codec.BOOL.fieldOf("is_double").forGetter(DoorSchema::isDouble), (App)PortalOffsets.CODEC.optionalFieldOf("portal_info", (Object)new PortalOffsets(1.0f, 2.0f)).forGetter(DatapackDoor::getOffsets), (App)BedrockAnimationReference.CODEC.optionalFieldOf("left_animation").forGetter(DatapackDoor::getLeftAnimation), (App)BedrockAnimationReference.CODEC.optionalFieldOf("right_animation").forGetter(DatapackDoor::getRightAnimation), (App)class_243.field_38277.optionalFieldOf("scale", (Object)new class_243(1.0, 1.0, 1.0)).forGetter(DatapackDoor::getScale), (App)class_243.field_38277.optionalFieldOf("offset", (Object)new class_243(0.0, 0.0, 0.0)).forGetter(DatapackDoor::getOffset), (App)Codec.BOOL.optionalFieldOf("isDatapack", (Object)true).forGetter(DatapackDoor::wasDatapack)).apply((Applicative)instance, DatapackDoor::new));
    protected final class_2960 openSound;
    protected final class_2960 closeSound;
    protected final class_2960 model;
    protected final boolean isDouble;
    protected final PortalOffsets offsets;
    protected final BedrockAnimationReference leftAnimation;
    protected final BedrockAnimationReference rightAnimation;
    protected final class_243 scale;
    protected final class_243 offset;
    protected final boolean initiallyDatapack;

    public DatapackDoor(class_2960 id, class_2960 openSound, class_2960 closeSound, class_2960 model, boolean isDouble, PortalOffsets offsets, Optional<BedrockAnimationReference> leftAnimation, Optional<BedrockAnimationReference> rightAnimation, class_243 scale, class_243 offset, boolean initiallyDatapack) {
        super(id);
        this.openSound = openSound;
        this.closeSound = closeSound;
        this.model = model;
        this.isDouble = isDouble;
        this.offsets = offsets;
        this.leftAnimation = leftAnimation.orElse(null);
        this.rightAnimation = rightAnimation.orElse(null);
        this.scale = scale;
        this.offset = offset;
        this.initiallyDatapack = initiallyDatapack;
    }

    @Override
    public boolean isDouble() {
        return this.isDouble;
    }

    @Override
    public class_3414 openSound() {
        return class_3414.method_47908((class_2960)this.getOpenSoundId());
    }

    @Override
    public class_3414 closeSound() {
        return class_3414.method_47908((class_2960)this.getCloseSoundId());
    }

    @Override
    public Optional<BedrockAnimationReference> getLeftAnimation() {
        return Optional.ofNullable(this.leftAnimation);
    }

    @Override
    public Optional<BedrockAnimationReference> getRightAnimation() {
        return Optional.ofNullable(this.rightAnimation);
    }

    public class_2960 getOpenSoundId() {
        return this.openSound;
    }

    public class_2960 getCloseSoundId() {
        return this.closeSound;
    }

    @Override
    public class_243 adjustPortalPos(class_243 pos, class_2350 direction) {
        return this.offsets.apply(direction, pos);
    }

    public PortalOffsets getOffsets() {
        return this.offsets;
    }

    public boolean wasDatapack() {
        return this.initiallyDatapack;
    }

    public class_2960 getModelId() {
        return this.model;
    }

    @Override
    public class_243 getScale() {
        return this.scale;
    }

    @Override
    public class_243 getOffset() {
        return this.offset;
    }

    public static DatapackDoor fromInputStream(InputStream stream) {
        return DatapackDoor.fromJson(JsonParser.parseReader((Reader)new InputStreamReader(stream)).getAsJsonObject());
    }

    public static DatapackDoor fromJson(JsonObject json) {
        AtomicReference created = new AtomicReference();
        CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).get().ifLeft(recipe -> created.set((DatapackDoor)recipe.getFirst())).ifRight(err -> {
            created.set(null);
            AITMod.LOGGER.error("Error decoding datapack door type: {}", err);
        });
        return (DatapackDoor)created.get();
    }
}

