/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.data.schema.door;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.data.schema.door.impl.CapsuleDoorVariant;
import dev.amble.ait.registry.impl.door.DoorRegistry;
import dev.amble.lib.api.Identifiable;
import java.lang.reflect.Type;
import net.minecraft.class_151;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import org.jetbrains.annotations.Nullable;

public abstract class DoorSchema
implements Identifiable {
    private final class_2960 id;

    protected DoorSchema(class_2960 id) {
        this.id = id;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DoorSchema)) return false;
        DoorSchema that = (DoorSchema)o;
        if (!this.id.equals((Object)that.id)) return false;
        return true;
    }

    public class_2960 id() {
        return this.id;
    }

    public abstract boolean isDouble();

    public class_3414 openSound() {
        return AITSounds.POLICE_BOX_DOOR_OPEN;
    }

    public class_3414 closeSound() {
        return AITSounds.POLICE_BOX_DOOR_CLOSE;
    }

    @Deprecated(forRemoval=true)
    public class_243 adjustPortalPos(class_243 pos, class_2350 direction) {
        return pos;
    }

    @Nullable
    public class_243 getPortalPosition() {
        return this.adjustPortalPos(class_243.field_1353, class_2350.field_11043);
    }

    @Nullable
    public class_243 getPortalPosition(class_243 origin, float angle) {
        class_243 pos = this.getPortalPosition();
        if (pos == null) {
            return null;
        }
        return pos.method_1037((float)Math.toRadians(180.0)).method_1024((float)Math.toRadians(180.0f - angle)).method_18805(1.0, -1.0, 1.0).method_1019(origin);
    }

    public static Object serializer() {
        return new Serializer();
    }

    private static class Serializer
    implements JsonSerializer<DoorSchema>,
    JsonDeserializer<DoorSchema> {
        private Serializer() {
        }

        public DoorSchema deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            class_2960 id;
            try {
                id = new class_2960(json.getAsJsonPrimitive().getAsString());
            }
            catch (class_151 e) {
                id = CapsuleDoorVariant.REFERENCE;
            }
            return (DoorSchema)DoorRegistry.getInstance().get(id);
        }

        public JsonElement serialize(DoorSchema src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.id().toString());
        }
    }
}

