/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.data.schema.exterior;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import dev.amble.ait.AITMod;
import dev.amble.ait.client.models.exteriors.ExteriorModel;
import dev.amble.ait.data.datapack.exterior.BiomeOverrides;
import dev.amble.ait.data.schema.door.ClientDoorSchema;
import dev.amble.ait.data.schema.exterior.ExteriorVariantSchema;
import dev.amble.ait.registry.impl.door.ClientDoorRegistry;
import dev.amble.ait.registry.impl.exterior.ClientExteriorVariantRegistry;
import dev.amble.ait.registry.impl.exterior.ExteriorVariantRegistry;
import dev.amble.lib.api.Identifiable;
import java.lang.reflect.Type;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_151;
import net.minecraft.class_2960;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public abstract class ClientExteriorVariantSchema
implements Identifiable {
    private final class_2960 parent;
    private final class_2960 id;
    private ClientDoorSchema door;

    protected ClientExteriorVariantSchema(class_2960 parent, class_2960 id) {
        this.parent = parent;
        this.id = id;
    }

    protected ClientExteriorVariantSchema(class_2960 parent) {
        this.id = parent;
        this.parent = parent;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientExteriorVariantSchema)) return false;
        ClientExteriorVariantSchema other = (ClientExteriorVariantSchema)o;
        if (!this.id.equals((Object)other.id)) return false;
        return true;
    }

    public ExteriorVariantSchema parent() {
        return (ExteriorVariantSchema)ExteriorVariantRegistry.getInstance().get(this.parent);
    }

    public class_2960 id() {
        return this.id;
    }

    public abstract class_2960 texture();

    public abstract class_2960 emission();

    public abstract ExteriorModel model();

    public abstract Vector3f sonicItemTranslations();

    public abstract BiomeOverrides overrides();

    public float[] sonicItemRotations() {
        return new float[]{0.0f, 45.0f};
    }

    public ExteriorVariantSchema getDefaultVariant() {
        return ((ExteriorVariantSchema)ExteriorVariantRegistry.getInstance().get(this.parent().id())).category().getDefaultVariant();
    }

    public ClientDoorSchema getDoor() {
        if (this.door == null) {
            this.door = ClientDoorRegistry.withParent(this.parent().door());
        }
        return this.door;
    }

    public boolean hasTransparentDoors() {
        return false;
    }

    public static Object serializer() {
        return new Serializer();
    }

    private static class Serializer
    implements JsonSerializer<ClientExteriorVariantSchema>,
    JsonDeserializer<ClientExteriorVariantSchema> {
        private Serializer() {
        }

        public ClientExteriorVariantSchema deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            class_2960 id;
            try {
                id = new class_2960(json.getAsJsonPrimitive().getAsString());
            }
            catch (class_151 e) {
                id = AITMod.id("capsule_default");
            }
            return (ClientExteriorVariantSchema)ClientExteriorVariantRegistry.getInstance().get(id);
        }

        public JsonElement serialize(ClientExteriorVariantSchema src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.id().toString());
        }
    }
}

