/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.data.schema.exterior;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import dev.amble.ait.AITMod;
import dev.amble.ait.data.Loyalty;
import dev.amble.ait.data.schema.BasicSchema;
import dev.amble.ait.data.schema.door.DoorSchema;
import dev.amble.ait.data.schema.exterior.ClientExteriorVariantSchema;
import dev.amble.ait.data.schema.exterior.ExteriorCategorySchema;
import dev.amble.ait.registry.impl.CategoryRegistry;
import dev.amble.ait.registry.impl.exterior.ClientExteriorVariantRegistry;
import dev.amble.ait.registry.impl.exterior.ExteriorVariantRegistry;
import dev.amble.lib.register.unlockable.Unlockable;
import java.lang.reflect.Type;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_151;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public abstract class ExteriorVariantSchema
extends BasicSchema
implements Unlockable {
    private final class_2960 category;
    private final class_2960 id;
    private final Loyalty loyalty;
    public static final double DEFAULT_SEAT_FORWARD_TRANSLATION = 0.5;
    public static final class_243 DEFAULT_SEAT_POS = new class_243(0.5, 1.0, 0.5);
    @Environment(value=EnvType.CLIENT)
    private ClientExteriorVariantSchema cachedSchema;

    protected ExteriorVariantSchema(class_2960 category, class_2960 id, Optional<Loyalty> loyalty) {
        super("exterior");
        this.category = category;
        this.id = id;
        this.loyalty = loyalty.orElse(null);
    }

    protected ExteriorVariantSchema(class_2960 category, class_2960 id, Loyalty loyalty) {
        this(category, id, Optional.of(loyalty));
    }

    protected ExteriorVariantSchema(class_2960 category, class_2960 id) {
        this(category, id, Optional.empty());
    }

    public static Object serializer() {
        return new Serializer();
    }

    public class_2960 id() {
        return this.id;
    }

    @Override
    public Optional<Loyalty> requirement() {
        return Optional.ofNullable(this.loyalty);
    }

    @Override
    public Unlockable.UnlockType unlockType() {
        return Unlockable.UnlockType.EXTERIOR;
    }

    public class_2960 categoryId() {
        return this.category;
    }

    public abstract class_243 seatTranslations();

    public double seatForwardTranslation() {
        return 0.5;
    }

    public ExteriorCategorySchema category() {
        return (ExteriorCategorySchema)CategoryRegistry.getInstance().get(this.categoryId());
    }

    @Environment(value=EnvType.CLIENT)
    public ClientExteriorVariantSchema getClient() {
        if (this.cachedSchema == null) {
            this.cachedSchema = ClientExteriorVariantRegistry.withParent(this);
        }
        return this.cachedSchema;
    }

    public class_265 bounding(class_2350 dir) {
        return null;
    }

    public abstract DoorSchema door();

    public boolean hasPortals() {
        return this.category().hasPortals();
    }

    @Deprecated(forRemoval=true)
    public class_243 adjustPortalPos(class_243 pos, byte direction) {
        return pos;
    }

    @Nullable
    public class_243 getPortalPosition() {
        return this.adjustPortalPos(class_243.field_1353, (byte)0);
    }

    @Nullable
    public class_243 getPortalPosition(class_243 origin, float angle) {
        class_243 pos = this.getPortalPosition();
        if (pos == null) {
            return null;
        }
        return pos.method_1037((float)Math.toRadians(180.0)).method_1024((float)Math.toRadians(180.0f - angle)).method_18805(1.0, -1.0, 1.0).method_1019(origin);
    }

    public double portalWidth() {
        return 1.0;
    }

    public double portalHeight() {
        return 2.0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExteriorVariantSchema)) return false;
        ExteriorVariantSchema other = (ExteriorVariantSchema)o;
        if (!this.id.equals((Object)other.id)) return false;
        return true;
    }

    private static class Serializer
    implements JsonSerializer<ExteriorVariantSchema>,
    JsonDeserializer<ExteriorVariantSchema> {
        private Serializer() {
        }

        public ExteriorVariantSchema deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            class_2960 id;
            try {
                id = new class_2960(json.getAsJsonPrimitive().getAsString());
            }
            catch (class_151 e) {
                id = AITMod.id("capsule_default");
            }
            return (ExteriorVariantSchema)ExteriorVariantRegistry.getInstance().get(id);
        }

        public JsonElement serialize(ExteriorVariantSchema src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.id().toString());
        }
    }
}

