/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.data.schema.sonic;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.amble.ait.data.Loyalty;
import dev.amble.ait.data.schema.BasicSchema;
import dev.amble.lib.register.unlockable.Unlockable;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_2960;

public abstract class SonicSchema
extends BasicSchema
implements Unlockable {
    private final class_2960 id;
    private final Models models;
    private final Rendering rendering;
    private final Loyalty loyalty;

    protected SonicSchema(class_2960 id, Models models, Rendering rendering, Optional<Loyalty> loyalty) {
        super("sonic");
        this.id = id;
        this.models = models;
        this.rendering = rendering;
        this.loyalty = loyalty.orElse(null);
    }

    protected SonicSchema(class_2960 id, Models models, Rendering rendering) {
        this(id, models, rendering, Optional.empty());
    }

    public class_2960 id() {
        return this.id;
    }

    @Override
    public Optional<Loyalty> requirement() {
        return Optional.ofNullable(this.loyalty);
    }

    @Override
    public Unlockable.UnlockType unlockType() {
        return Unlockable.UnlockType.SONIC;
    }

    public Models models() {
        return this.models;
    }

    public Rendering rendering() {
        return this.rendering;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof SonicSchema)) return false;
        SonicSchema that = (SonicSchema)o;
        if (!this.id.equals((Object)that.id)) return false;
        return true;
    }

    public record Models(class_2960 inactive, class_2960 interaction, class_2960 overload, class_2960 scanning, class_2960 tardis) {
        public static final Codec<Models> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("inactive").forGetter(Models::inactive), (App)class_2960.field_25139.fieldOf("interaction").forGetter(Models::interaction), (App)class_2960.field_25139.fieldOf("overload").forGetter(Models::overload), (App)class_2960.field_25139.fieldOf("scanning").forGetter(Models::scanning), (App)class_2960.field_25139.fieldOf("tardis").forGetter(Models::tardis)).apply((Applicative)instance, Models::new));

        public void load(Consumer<class_2960> consumer) {
            consumer.accept(this.inactive);
            consumer.accept(this.interaction);
            consumer.accept(this.overload);
            consumer.accept(this.scanning);
            consumer.accept(this.tardis);
        }
    }

    public record Rendering(Optional<Offset> positionOffset, Optional<Offset> scaleOffset) {
        public static final Codec<Rendering> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Offset.CODEC.optionalFieldOf("position").forGetter(Rendering::positionOffset), (App)Offset.CODEC.optionalFieldOf("scale").forGetter(Rendering::scaleOffset)).apply((Applicative)instance, Rendering::new));

        public Rendering() {
            this(Optional.of(new Offset()), Optional.of(new Offset()));
        }

        public Offset getPositionOffset() {
            return this.positionOffset.orElse(new Offset());
        }

        public Offset getScaleOffset() {
            return this.scaleOffset.orElse(new Offset());
        }

        public record Offset(float x, float y, float z) {
            static final Codec<Offset> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("x").forGetter(Offset::x), (App)Codec.FLOAT.fieldOf("y").forGetter(Offset::y), (App)Codec.FLOAT.fieldOf("z").forGetter(Offset::z)).apply((Applicative)instance, Offset::new));

            public Offset() {
                this(0.0f, 0.0f, 0.0f);
            }
        }
    }
}

