/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.datagen.datagen_providers;

import dev.amble.ait.AITMod;
import dev.amble.ait.core.AITBlocks;
import dev.amble.ait.core.AITItems;
import dev.amble.ait.module.ModuleRegistry;
import dev.amble.lib.datagen.model.AmbleModelProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4918;
import net.minecraft.class_4922;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4944;
import net.minecraft.class_4945;

public class AITModelProvider
extends AmbleModelProvider {
    private final List<class_2248> directionalBlocksToRegister = new ArrayList<class_2248>();
    private final List<class_2248> simpleBlocksToRegister = new ArrayList<class_2248>();
    private final List<class_3545<class_2248, class_2248>> coralFanBlocksToRegister = new ArrayList<class_3545<class_2248, class_2248>>();

    public AITModelProvider(FabricDataOutput output) {
        super(output);
    }

    private static class_4942 item(String modid, String parent, class_4945 ... requiredTextureKeys) {
        return new class_4942(Optional.of(new class_2960(modid, "item/" + parent)), Optional.empty(), requiredTextureKeys);
    }

    private static class_4942 item(String parent, class_4945 ... requiredTextureKeys) {
        return AITModelProvider.item("ait", parent, requiredTextureKeys);
    }

    private static class_4942 item(class_4945 ... requiredTextureKeys) {
        return AITModelProvider.item("minecraft", "generated", requiredTextureKeys);
    }

    private static class_4942 item(String name) {
        return AITModelProvider.item(name, class_4945.field_23006);
    }

    private static String getItemName(class_1792 item) {
        return item.method_7876().split("\\.")[2];
    }

    public void generateBlockStateModels(class_4910 generator) {
        for (class_2248 class_22482 : this.directionalBlocksToRegister) {
            generator.field_22830.accept(class_4922.method_25758((class_2248)class_22482).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11043), class_4935.method_25824().method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22890)));
        }
        for (class_2248 class_22483 : this.simpleBlocksToRegister) {
            generator.method_25641(class_22483);
        }
        for (class_3545 class_35452 : this.coralFanBlocksToRegister) {
            generator.method_25601((class_2248)class_35452.method_15442(), (class_2248)class_35452.method_15441());
        }
        ModuleRegistry.instance().iterator().forEachRemaining(module -> {
            module.getDataGenerator().ifPresent(data -> data.models(this, generator));
            module.getBlockRegistry().ifPresent(xva$0 -> this.withBlocks(new Class[]{xva$0}));
        });
        class_4910.class_4912 tardis_coral_pool = generator.method_25650(AITBlocks.TARDIS_CORAL_BLOCK);
        tardis_coral_pool.method_25725(AITBlocks.TARDIS_CORAL_STAIRS);
        tardis_coral_pool.method_25724(AITBlocks.TARDIS_CORAL_SLAB);
        super.generateBlockStateModels(generator);
    }

    public void generateItemModels(class_4915 generator) {
        ModuleRegistry.instance().iterator().forEachRemaining(module -> {
            module.getItemRegistry().ifPresent(xva$0 -> this.withItems(new Class[]{xva$0}));
            module.getBlockRegistry().ifPresent(xva$0 -> this.withBlocks(new Class[]{xva$0}));
            module.getDataGenerator().ifPresent(data -> data.generateItemModels(this, generator));
        });
        this.withItems(new Class[]{AITItems.class});
        this.withBlocks(new Class[]{AITBlocks.class});
        super.generateItemModels(generator);
    }

    public void registerDirectionalBlock(class_2248 block) {
        this.directionalBlocksToRegister.add(block);
    }

    public void registerCoralFanBlock(class_2248 fanBlock, class_2248 wallFanBlock) {
        this.coralFanBlocksToRegister.add((class_3545<class_2248, class_2248>)new class_3545((Object)fanBlock, (Object)wallFanBlock));
    }

    public void registerSimpleBlock(class_2248 block) {
        this.simpleBlocksToRegister.add(block);
    }

    private void registerItem(class_4915 generator, class_1792 item, String modid) {
        class_4942 model = AITModelProvider.item(class_4945.field_23006);
        model.method_25852(class_4941.method_25840((class_1792)item), this.createTextureMap(item, modid), generator.field_22844);
    }

    private class_4944 createTextureMap(class_1792 item, String modid) {
        class_2960 texture = new class_2960(modid, "item/" + AITModelProvider.getItemName(item));
        if (!this.doesTextureExist(texture)) {
            texture = AITMod.id("item/error");
        }
        return new class_4944().method_25868(class_4945.field_23006, texture);
    }

    public boolean doesTextureExist(class_2960 texture) {
        return this.output.getModContainer().findPath("assets/" + texture.method_12836() + "/textures/" + texture.method_12832() + ".png").isPresent();
    }
}

