/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.mixin.client.rendering;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.amble.ait.client.AITModClient;
import dev.amble.ait.client.tardis.ClientTardis;
import dev.amble.ait.client.util.ClientTardisUtil;
import dev.amble.ait.client.util.SkyboxUtil;
import dev.amble.ait.core.AITDimensions;
import dev.amble.ait.core.world.TardisServerWorld;
import net.fabricmc.fabric.api.client.rendering.v1.DimensionRenderingRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5321;
import net.minecraft.class_5539;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_758;
import net.minecraft.class_761;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_761.class})
public abstract class SkyboxMixin {
    @Shadow
    @Final
    private class_310 field_4088;
    @Shadow
    @Nullable
    private class_638 field_4085;
    @Shadow
    @Nullable
    private class_291 field_4087;
    @Shadow
    @Final
    private static class_2960 field_4111;
    @Shadow
    @Final
    private static class_2960 field_4098;
    @Shadow
    @Nullable
    private class_291 field_4113;
    @Shadow
    @Nullable
    private class_291 field_4102;
    @Unique
    private static WorldRenderContext context;

    @Shadow
    protected abstract void method_3250(class_4587 var1);

    @Shadow
    public abstract void method_22710(class_4587 var1, float var2, long var3, boolean var5, class_4184 var6, class_757 var7, class_765 var8, Matrix4f var9);

    @Shadow
    protected abstract void method_3293();

    @Inject(method={"<clinit>"}, at={@At(value="TAIL")})
    private static void init(CallbackInfo ci) {
        WorldRenderEvents.AFTER_SETUP.register(ctx -> {
            context = ctx;
        });
    }

    @Inject(method={"renderSky(Lnet/minecraft/client/util/math/MatrixStack;Lorg/joml/Matrix4f;FLnet/minecraft/client/render/Camera;ZLjava/lang/Runnable;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void ait$renderSky(class_4587 matrices, Matrix4f projectionMatrix, float tickDelta, class_4184 camera, boolean thickFog, Runnable fogCallback, CallbackInfo ci) {
        if (this.field_4085 == null) {
            return;
        }
        if (TardisServerWorld.isTardisDimension(this.field_4085)) {
            this.renderSkyDynamically(matrices, projectionMatrix, tickDelta, camera, fogCallback, ci);
            this.field_4085.method_16107().method_15405("projector");
        }
        if (this.field_4085.method_27983() == AITDimensions.TIME_VORTEX_WORLD) {
            SkyboxUtil.renderVortexSky(matrices);
            ci.cancel();
        }
        if (this.field_4085.method_27983() == AITDimensions.MOON) {
            SkyboxUtil.renderMoonSky(matrices, fogCallback, this.field_4113, this.field_4085, tickDelta, projectionMatrix);
            ci.cancel();
        }
        if (this.field_4085.method_27983() == AITDimensions.MARS) {
            SkyboxUtil.renderMarsSky(matrices, fogCallback, this.field_4113, this.field_4085, tickDelta, projectionMatrix, ci);
        }
        if (this.field_4085.method_27983() == AITDimensions.SPACE) {
            SkyboxUtil.renderSpaceSky(false, matrices, fogCallback, this.field_4113, this.field_4085, tickDelta, projectionMatrix);
            ci.cancel();
        }
    }

    @Unique
    private void renderSkyDynamically(class_4587 matrices, Matrix4f projectionMatrix, float tickDelta, class_4184 camera, Runnable fogCallback, CallbackInfo ci) {
        if (!AITModClient.CONFIG.environmentProjector || context == null) {
            SkyboxUtil.renderTardisSky(matrices);
            ci.cancel();
            return;
        }
        if (this.field_4085 == null) {
            return;
        }
        ClientTardis tardis = ClientTardisUtil.getCurrentTardis();
        if (tardis == null || tardis.stats() == null || tardis.stats().skybox() == null) {
            return;
        }
        class_5321<class_1937> skyboxWorld = tardis.stats().skybox().get();
        class_2350 skyboxDirection = tardis.stats().skyboxDirection().get();
        if (skyboxWorld == class_1937.field_25179) {
            matrices.method_22903();
            matrices.method_22907(class_7833.field_40716.rotationDegrees(skyboxDirection.method_10144()));
            this.renderOverworldSky(matrices, projectionMatrix, tickDelta, camera, fogCallback);
            matrices.method_22909();
            ci.cancel();
            return;
        }
        if (skyboxWorld == class_1937.field_25181) {
            matrices.method_22903();
            matrices.method_22907(class_7833.field_40716.rotationDegrees(skyboxDirection.method_10144()));
            this.method_3250(matrices);
            matrices.method_22909();
            ci.cancel();
            return;
        }
        if (skyboxWorld == class_1937.field_25180) {
            SkyboxUtil.renderTardisSky(matrices);
            ci.cancel();
            return;
        }
        if (skyboxWorld == AITDimensions.SPACE) {
            matrices.method_22903();
            matrices.method_22907(class_7833.field_40716.rotationDegrees(skyboxDirection.method_10144()));
            SkyboxUtil.renderSpaceSky(true, matrices, fogCallback, this.field_4113, this.field_4085, tickDelta, projectionMatrix);
            matrices.method_22909();
            ci.cancel();
            return;
        }
        if (skyboxWorld == AITDimensions.MOON) {
            SkyboxUtil.renderMoonSky(skyboxDirection.method_10144(), matrices, fogCallback, this.field_4113, this.field_4085, tickDelta, projectionMatrix);
            ci.cancel();
            return;
        }
        if (skyboxWorld == AITDimensions.MARS) {
            matrices.method_22903();
            matrices.method_22907(class_7833.field_40716.rotationDegrees(skyboxDirection.method_10144()));
            SkyboxUtil.renderMarsSky(matrices, fogCallback, this.field_4113, this.field_4085, tickDelta, projectionMatrix, ci);
            matrices.method_22909();
            return;
        }
        if (skyboxWorld == AITDimensions.TIME_VORTEX_WORLD) {
            matrices.method_22903();
            matrices.method_22907(class_7833.field_40716.rotationDegrees(skyboxDirection.method_10144()));
            SkyboxUtil.renderVortexSky(matrices, tardis);
            matrices.method_22909();
            ci.cancel();
            return;
        }
        DimensionRenderingRegistry.SkyRenderer renderer = DimensionRenderingRegistry.getSkyRenderer(skyboxWorld);
        if (renderer != null) {
            renderer.render(context);
            ci.cancel();
        }
    }

    @Unique
    private void renderOverworldSky(class_4587 matrices, Matrix4f projectionMatrix, float tickDelta, class_4184 camera, Runnable fogCallback) {
        float q;
        float p;
        float o;
        float k;
        float i;
        class_243 vec3d = this.field_4085.method_23777(camera.method_19326(), tickDelta);
        float f = (float)vec3d.field_1352;
        float g = (float)vec3d.field_1351;
        float h = (float)vec3d.field_1350;
        class_758.method_3212();
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShaderColor((float)f, (float)g, (float)h, (float)1.0f);
        class_5944 shaderProgram = RenderSystem.getShader();
        this.field_4087.method_1353();
        this.field_4087.method_34427(matrices.method_23760().method_23761(), projectionMatrix, shaderProgram);
        class_291.method_1354();
        RenderSystem.enableBlend();
        float[] fs = this.field_4085.method_28103().method_28109(this.field_4085.method_30274(tickDelta), tickDelta);
        if (fs != null) {
            RenderSystem.setShader(class_757::method_34540);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            matrices.method_22903();
            matrices.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
            i = class_3532.method_15374((float)this.field_4085.method_8442(tickDelta)) < 0.0f ? 180.0f : 0.0f;
            matrices.method_22907(class_7833.field_40718.rotationDegrees(i));
            matrices.method_22907(class_7833.field_40718.rotationDegrees(90.0f));
            float j = fs[0];
            k = fs[1];
            float l = fs[2];
            Matrix4f matrix4f = matrices.method_23760().method_23761();
            bufferBuilder.method_1328(class_293.class_5596.field_27381, class_290.field_1576);
            bufferBuilder.method_22918(matrix4f, 0.0f, 100.0f, 0.0f).method_22915(j, k, l, fs[3]).method_1344();
            for (int n = 0; n <= 16; ++n) {
                o = (float)n * ((float)Math.PI * 2) / 16.0f;
                p = class_3532.method_15374((float)o);
                q = class_3532.method_15362((float)o);
                bufferBuilder.method_22918(matrix4f, p * 120.0f, q * 120.0f, -q * 40.0f * fs[3]).method_22915(fs[0], fs[1], fs[2], 0.0f).method_1344();
            }
            class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
            matrices.method_22909();
        }
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
        matrices.method_22903();
        i = 1.0f - this.field_4085.method_8430(tickDelta);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)i);
        matrices.method_22907(class_7833.field_40716.rotationDegrees(-90.0f));
        matrices.method_22907(class_7833.field_40714.rotationDegrees(this.field_4085.method_30274(tickDelta) * 360.0f));
        Matrix4f matrix4f2 = matrices.method_23760().method_23761();
        k = 30.0f;
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)field_4111);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix4f2, -k, 100.0f, -k).method_22913(0.0f, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix4f2, k, 100.0f, -k).method_22913(1.0f, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix4f2, k, 100.0f, k).method_22913(1.0f, 1.0f).method_1344();
        bufferBuilder.method_22918(matrix4f2, -k, 100.0f, k).method_22913(0.0f, 1.0f).method_1344();
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        k = 20.0f;
        RenderSystem.setShaderTexture((int)0, (class_2960)field_4098);
        int r = this.field_4085.method_30273();
        int s = r % 4;
        int m = r / 4 % 2;
        float t = (float)s / 4.0f;
        o = (float)m / 2.0f;
        p = (float)(s + 1) / 4.0f;
        q = (float)(m + 1) / 2.0f;
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix4f2, -k, -100.0f, k).method_22913(p, q).method_1344();
        bufferBuilder.method_22918(matrix4f2, k, -100.0f, k).method_22913(t, q).method_1344();
        bufferBuilder.method_22918(matrix4f2, k, -100.0f, -k).method_22913(t, o).method_1344();
        bufferBuilder.method_22918(matrix4f2, -k, -100.0f, -k).method_22913(p, o).method_1344();
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        float u = this.field_4085.method_23787(tickDelta) * i;
        if (u > 0.0f) {
            RenderSystem.setShaderColor((float)u, (float)u, (float)u, (float)u);
            class_758.method_23792();
            this.field_4113.method_1353();
            this.field_4113.method_34427(matrices.method_23760().method_23761(), projectionMatrix, class_757.method_34539());
            class_291.method_1354();
            fogCallback.run();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        matrices.method_22909();
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        double d = this.field_4088.field_1724.method_5836((float)tickDelta).field_1351 - this.field_4085.method_28104().method_28105((class_5539)this.field_4085);
        if (d < 0.0) {
            matrices.method_22903();
            matrices.method_46416(0.0f, 12.0f, 0.0f);
            this.field_4102.method_1353();
            this.field_4102.method_34427(matrices.method_23760().method_23761(), projectionMatrix, shaderProgram);
            class_291.method_1354();
            matrices.method_22909();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.depthMask((boolean)true);
    }

    @Unique
    private void renderEndPortalEffect(class_4587 matrices, Matrix4f projectionMatrix, float tickDelta, class_4184 camera, Runnable fogCallback) {
        fogCallback.run();
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        class_243 vec3d = this.field_4085.method_23777(class_310.method_1551().field_1773.method_19418().method_19326(), tickDelta);
        float f = (float)vec3d.field_1352;
        float g = (float)vec3d.field_1351;
        float h = (float)vec3d.field_1350;
        class_758.method_3212();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShaderColor((float)f, (float)g, (float)h, (float)1.0f);
        class_291.method_1354();
        RenderSystem.enableBlend();
        float[] fs = this.field_4085.method_28103().method_28109(this.field_4085.method_30274(tickDelta), tickDelta);
        if (fs != null) {
            RenderSystem.setShader(class_757::method_34534);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            matrices.method_22903();
            matrices.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
            float i = class_3532.method_15374((float)this.field_4085.method_8442(tickDelta)) < 0.0f ? 180.0f : 0.0f;
            matrices.method_22907(class_7833.field_40718.rotationDegrees(i));
            matrices.method_22907(class_7833.field_40718.rotationDegrees(90.0f));
            float j = fs[0];
            float k = fs[1];
            float l = fs[2];
            Matrix4f matrix4f = matrices.method_23760().method_23761();
            bufferBuilder.method_1328(class_293.class_5596.field_27381, class_290.field_1576);
            bufferBuilder.method_22918(matrix4f, 0.0f, 100.0f, 0.0f).method_22915(j, k, l, fs[3]).method_1344();
            int m = 16;
            for (int n = 0; n <= 16; ++n) {
                float o = (float)n * ((float)Math.PI * 2) / 16.0f;
                float p = class_3532.method_15374((float)o);
                float q = class_3532.method_15362((float)o);
                bufferBuilder.method_22918(matrix4f, p * 120.0f, q * 120.0f, -q * 40.0f * fs[3]).method_22915(fs[0], fs[1], fs[2], 0.0f).method_1344();
            }
            class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
            matrices.method_22909();
        }
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_CONSTANT_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
        RenderSystem.depthMask((boolean)true);
    }
}

