/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.mixin.server.multidim;

import com.mojang.datafixers.util.Either;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.handler.travel.TravelHandler;
import dev.amble.ait.core.tardis.manager.ServerTardisManager;
import dev.amble.ait.core.world.TardisServerWorld;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MinecraftServer.class})
public class MultiDimLoadFix {
    @Inject(method={"getWorld"}, at={@At(value="RETURN")}, cancellable=true)
    public void getWorld(class_5321<class_1937> key, CallbackInfoReturnable<class_3218> cir) {
        if (cir.getReturnValue() != null || !TardisServerWorld.isTardisDimension(key)) {
            return;
        }
        cir.setReturnValue((Object)this.ait$loadTardisFromWorld((MinecraftServer)this, key));
    }

    @Unique
    public class_3218 ait$loadTardisFromWorld(MinecraftServer server, class_5321<class_1937> key) {
        TardisServerWorld targetWorld;
        ServerTardis tardis;
        ServerTardisManager manager = ServerTardisManager.getInstance();
        UUID id = TardisServerWorld.getTardisId(key);
        Either<ServerTardis, Exception> either = (Either<ServerTardis, Exception>)manager.lookup().get(id);
        if (either == null) {
            either = manager.loadTardis(server, id);
        }
        if ((tardis = (ServerTardis)either.map(t -> t, o -> null)) == null) {
            return null;
        }
        TravelHandler travel = tardis.travel();
        CachedDirectedGlobalPos pos = travel.position();
        TardisServerWorld loadedWorld = TardisServerWorld.load(server, tardis);
        if (TardisServerWorld.isTardisDimension((class_5321<class_1937>)pos.getDimension()) && (targetWorld = pos.getDimension().equals(key) ? loadedWorld : this.ait$loadTardisFromWorld(server, (class_5321<class_1937>)pos.getDimension())) != null) {
            pos.init(server);
        }
        return tardis.world();
    }
}

