/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.module.gun.core.item;

import dev.amble.ait.AITMod;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.AITStatusEffects;
import dev.amble.ait.module.gun.core.item.GunItems;
import dev.amble.ait.module.gun.core.item.StaserBoltMagazine;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3745;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class BaseGunItem
extends class_1811 {
    public static final class_2960 SHOOT = AITMod.id("shoot_gun");
    public static final Predicate<class_1799> GUN_PROJECTILES = itemStack -> itemStack.method_31574(GunItems.STASER_BOLT_MAGAZINE);
    public static final double MAX_AMMO = 64.0;
    public static final String AMMO_KEY = "ammo";

    public BaseGunItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1799 method_7854() {
        class_1799 stack = new class_1799((class_1935)this);
        class_2487 nbt = stack.method_7948();
        nbt.method_10549(AMMO_KEY, 0.0);
        return stack;
    }

    @Environment(value=EnvType.CLIENT)
    public static void shootGun(boolean shoot, boolean isAds) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeBoolean(shoot);
        buf.writeBoolean(isAds);
        ClientPlayNetworking.send((class_2960)SHOOT, (class_2540)buf);
    }

    @Environment(value=EnvType.CLIENT)
    public void tryShoot(class_1937 world, class_1297 entity, boolean selected) {
        if (world.method_8608() && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (selected) {
                BaseGunItem.shootGun(class_310.method_1551().field_1690.field_1886.method_1434(), class_310.method_1551().field_1690.field_1904.method_1434());
                class_310.method_1551().field_1690.field_1886.method_23481(false);
            }
        }
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        class_1657 player;
        super.method_7888(stack, world, entity, slot, selected);
        if (world.method_8608() && entity instanceof class_1657 && !(player = (class_1657)entity).method_7357().method_7904((class_1792)this)) {
            this.tryShoot(world, entity, selected);
        }
    }

    public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
        class_1792 class_17922 = otherStack.method_7909();
        if (class_17922 instanceof StaserBoltMagazine) {
            StaserBoltMagazine magazine = (StaserBoltMagazine)class_17922;
            double magazineAmmo = magazine.getCurrentFuel(otherStack);
            class_1792 class_17923 = stack.method_7909();
            if (class_17923 instanceof BaseGunItem) {
                BaseGunItem gun = (BaseGunItem)class_17923;
                double ammo = gun.getCurrentAmmo(stack);
                if (clickType == class_5536.field_27014 && gun.getCurrentAmmo(stack) < gun.getMaxAmmo()) {
                    double residual = ammo + magazineAmmo - gun.getMaxAmmo();
                    gun.setCurrentAmmo(ammo + magazineAmmo, stack);
                    magazine.setCurrentFuel(residual, otherStack);
                    return true;
                }
            }
        }
        return super.method_31566(stack, otherStack, slot, clickType, player, cursorStackReference);
    }

    public Predicate<class_1799> method_19268() {
        return GUN_PROJECTILES;
    }

    public double getCurrentAmmo(class_1799 stack) {
        if (stack.method_7909() == this) {
            return stack.method_7948().method_10574(AMMO_KEY);
        }
        return 0.0;
    }

    public void setCurrentAmmo(double var, class_1799 stack) {
        if (stack.method_7909() == this) {
            stack.method_7948().method_10549(AMMO_KEY, Math.min(var, this.getMaxAmmo()));
        }
    }

    public double getMaxAmmo() {
        return 64.0;
    }

    public float getAimDeviation(boolean isAds) {
        return isAds ? 0.2f : 1.42323f;
    }

    public int getCooldown() {
        return 20;
    }

    public int method_24792() {
        return 24;
    }

    private static void shoot(class_1937 world, class_1309 shooter, class_1268 hand, class_1799 gun, class_1799 projectile, float soundPitch, boolean creative, float speed, float divergence, float simulated) {
        if (world.field_9236) {
            return;
        }
        class_1665 projectileEntity = BaseGunItem.createBolt(world, shooter, gun, projectile);
        if (creative || simulated != 0.0f) {
            projectileEntity.field_7572 = class_1665.class_1666.field_7592;
        }
        if (shooter instanceof class_3745) {
            class_3745 crossbowUser = (class_3745)shooter;
            crossbowUser.method_18811(crossbowUser.method_5968(), gun, (class_1676)projectileEntity, simulated);
        } else {
            class_243 vec3d = shooter.method_18864(1.0f);
            Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(simulated * ((float)Math.PI / 180)), vec3d.field_1352, vec3d.field_1351, vec3d.field_1350);
            class_243 vec3d2 = shooter.method_5828(1.0f);
            Vector3f vector3f = vec3d2.method_46409().rotate((Quaternionfc)quaternionf);
            projectileEntity.method_7485((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), speed, divergence);
        }
        gun.method_7956(3, shooter, e -> e.method_20236(hand));
        projectileEntity.method_23327(shooter.method_23317(), shooter.method_23318() + (double)1.2f, shooter.method_23321());
        world.method_8649((class_1297)projectileEntity);
        world.method_43128(null, shooter.method_23317(), shooter.method_23318(), shooter.method_23321(), AITSounds.STASER, class_3419.field_15248, 0.25f, soundPitch);
    }

    private static class_1665 createBolt(class_1937 world, class_1309 entity, class_1799 gun, class_1799 bolt) {
        StaserBoltMagazine boltItem = (StaserBoltMagazine)(bolt.method_7909() instanceof StaserBoltMagazine ? bolt.method_7909() : GunItems.STASER_BOLT_MAGAZINE);
        class_1665 persistentProjectileEntity = boltItem.createStaserbolt(world, bolt, entity);
        if (entity instanceof class_1657) {
            persistentProjectileEntity.method_7439(true);
        }
        persistentProjectileEntity.method_7444(AITSounds.STASER);
        persistentProjectileEntity.method_7442(true);
        int i = class_1890.method_8225((class_1887)class_1893.field_9132, (class_1799)gun);
        if (i > 0) {
            persistentProjectileEntity.method_7451((byte)i);
        }
        return persistentProjectileEntity;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        double currentAmmo = this.getCurrentAmmo(stack);
        class_124 ammoColor = currentAmmo > this.getMaxAmmo() / 4.0 ? class_124.field_1060 : class_124.field_1061;
        tooltip.add((class_2561)class_2561.method_43469((String)"message.ait.ammo", (Object[])new Object[]{currentAmmo}).method_27692(ammoColor).method_10852((class_2561)class_2561.method_43470((String)" / ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(this.getMaxAmmo())).method_27692(class_124.field_1080)));
    }

    static {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SHOOT, (server, player, handler, buf, responseSender) -> {
            class_1792 patt0$temp;
            boolean shoot = buf.readBoolean();
            boolean isAds = buf.readBoolean();
            if (shoot && (patt0$temp = player.method_6047().method_7909()) instanceof BaseGunItem) {
                BaseGunItem gun = (BaseGunItem)patt0$temp;
                if (gun.getCurrentAmmo(player.method_6047()) <= 0.0) {
                    player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14954, class_3419.field_15248, 1.0f, 1.0f);
                    return;
                }
                BaseGunItem.shoot(player.method_37908(), (class_1309)player, class_1268.field_5808, player.method_6047(), GunItems.STASER_BOLT_MAGAZINE.method_7854(), 1.0f, false, 4.0f, player.method_6059(AITStatusEffects.ZEITON_HIGH) ? 20.0f : gun.getAimDeviation(isAds), 0.0f);
                class_2487 compound = player.method_6047().method_7948();
                double current = compound.method_10574(AMMO_KEY);
                double removableAmmo = isAds ? 2 : 1;
                player.method_7357().method_7906((class_1792)gun, gun.getCooldown());
                if (current - removableAmmo <= 0.0) {
                    compound.method_10549(AMMO_KEY, 0.0);
                } else {
                    compound.method_10549(AMMO_KEY, current - removableAmmo <= 0.0 ? 0.0 : current - removableAmmo);
                }
            }
        });
    }
}

