/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.module.planet.client.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.amble.ait.AITMod;
import dev.amble.ait.client.renderers.AITRenderLayers;
import dev.amble.ait.module.planet.client.models.CelestialBodyModel;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_758;
import net.minecraft.class_7833;
import net.minecraft.class_8251;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL11;

public class CelestialBodyRenderer {
    public static void renderFarAwayBody(class_243 targetPosition, Vector3f scale, class_2960 texture, boolean hasClouds, boolean hasAtmosphere, Vector3f atmosphereColor) {
        class_310 mc = class_310.method_1551();
        class_4184 camera = mc.field_1773.method_19418();
        class_4597.class_4598 provider = mc.method_22940().method_23000();
        class_243 cameraPos = camera.method_19326();
        class_243 targetPos = new class_243(camera.method_19326().method_10216() + targetPosition.method_10216(), camera.method_19326().method_10214() + targetPosition.method_10214(), camera.method_19326().method_10215() + targetPosition.method_10215());
        class_243 diff = targetPos.method_1020(cameraPos);
        class_4587 matrixStack = new class_4587();
        matrixStack.method_22907(class_7833.field_40714.rotationDegrees(camera.method_19329()));
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(camera.method_19330() + 180.0f));
        matrixStack.method_22904(diff.field_1352, diff.field_1351, diff.field_1350);
        matrixStack.method_22905(scale.x, scale.y, scale.z);
        class_758.method_23792();
        RenderSystem.setProjectionMatrix((Matrix4f)matrixStack.method_23760().method_23761().perspective(90.0f, 1.0f, 0.05f, 1.0E7f), (class_8251)class_8251.field_43361);
        CelestialBodyModel.getTexturedModelData().method_32109().method_22699(matrixStack, provider.getBuffer(AITRenderLayers.method_23592((class_2960)texture, (boolean)false)), 0xF000F0, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        provider.method_22993();
        if (hasAtmosphere) {
            CelestialBodyRenderer.atmosphereRenderer(matrixStack, atmosphereColor, provider, false, hasClouds);
            provider.method_22993();
        }
        provider.method_22993();
        RenderSystem.restoreProjectionMatrix();
    }

    public static void renderStarBody(boolean isTardisSkybox, class_243 targetPosition, Vector3f scale, Vector3f rotation, class_2960 texture, boolean hasAtmosphere, Vector3f atmosphereColor) {
        class_310 mc = class_310.method_1551();
        class_4184 camera = mc.field_1773.method_19418();
        class_4597.class_4598 provider = mc.method_22940().method_23000();
        class_243 cameraPos = camera.method_19326();
        class_243 targetPos = new class_243(targetPosition.method_10216(), targetPosition.method_10214(), targetPosition.method_10215());
        class_243 diff = targetPos.method_1020(cameraPos);
        class_4587 matrixStack = new class_4587();
        if (mc.field_1687 == null) {
            return;
        }
        matrixStack.method_22903();
        matrixStack.method_22907(class_7833.field_40714.rotationDegrees(camera.method_19329()));
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(camera.method_19330() + 180.0f));
        if (isTardisSkybox) {
            matrixStack.method_22907(class_7833.field_40718.rotationDegrees(mc.field_1687.method_30274(mc.method_1488()) * 360.0f));
            matrixStack.method_46416(0.0f, -4000.0f, 0.0f);
            matrixStack.method_22905(0.25f, 0.25f, 0.25f);
        }
        matrixStack.method_22904(diff.field_1352, diff.field_1351, diff.field_1350);
        matrixStack.method_22905(scale.x, scale.y, scale.z);
        class_758.method_23792();
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(rotation.y()));
        matrixStack.method_22907(class_7833.field_40714.rotationDegrees(rotation.x()));
        matrixStack.method_22907(class_7833.field_40718.rotationDegrees(rotation.z()));
        CelestialBodyModel model = new CelestialBodyModel(CelestialBodyModel.getTexturedModelData().method_32109());
        RenderSystem.depthMask((boolean)true);
        model.method_2828(matrixStack, provider.getBuffer(AITRenderLayers.method_23592((class_2960)texture, (boolean)false)), 0xF000F00, class_4608.field_21444, 1.0f - atmosphereColor.x, 1.0f - atmosphereColor.y, 1.0f - atmosphereColor.z, 1.0f);
        provider.method_22993();
        if (hasAtmosphere) {
            CelestialBodyRenderer.atmosphereRenderer(matrixStack, atmosphereColor, provider, true, false);
            provider.method_22993();
        }
        matrixStack.method_22909();
    }

    public static void renderComprehendableBody(boolean isTardisSkybox, class_243 targetPosition, Vector3f scale, Vector3f rotation, class_2960 texture, boolean isSkyRendered, boolean hasClouds, boolean hasAtmosphere, Vector3f atmosphereColor, boolean hasRings) {
        CelestialBodyRenderer.renderComprehendableBody(0.0f, isTardisSkybox, targetPosition, scale, rotation, texture, isSkyRendered, hasClouds, hasAtmosphere, atmosphereColor, hasRings);
    }

    public static void renderComprehendableBody(float skyboxRot, boolean isTardisSkybox, class_243 targetPosition, Vector3f scale, Vector3f rotation, class_2960 texture, boolean isSkyRendered, boolean hasClouds, boolean hasAtmosphere, Vector3f atmosphereColor, boolean hasRings) {
        class_310 mc = class_310.method_1551();
        class_4184 camera = mc.field_1773.method_19418();
        class_4597.class_4598 provider = mc.method_22940().method_23000();
        class_243 cameraPos = camera.method_19326();
        class_243 targetPos = new class_243(targetPosition.method_10216(), targetPosition.method_10214(), targetPosition.method_10215());
        class_243 diff = targetPos.method_1020(cameraPos);
        class_4587 matrixStack = new class_4587();
        matrixStack.method_22903();
        matrixStack.method_22907(class_7833.field_40714.rotationDegrees(camera.method_19329()));
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(camera.method_19330() + 180.0f + skyboxRot));
        if (isTardisSkybox) {
            matrixStack.method_46416(0.0f, 4000.0f, 0.0f);
            matrixStack.method_22905(0.25f, 0.25f, 0.25f);
        }
        matrixStack.method_22904(diff.field_1352, diff.field_1351, diff.field_1350);
        matrixStack.method_22905(scale.x, scale.y, scale.z);
        class_758.method_23792();
        if (isSkyRendered) {
            RenderSystem.depthMask((boolean)true);
            GL11.glEnable((int)2929);
            GL11.glDepthFunc((int)519);
        }
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(rotation.y()));
        matrixStack.method_22907(class_7833.field_40714.rotationDegrees(180.0f + rotation.x()));
        matrixStack.method_22907(class_7833.field_40718.rotationDegrees(rotation.z()));
        CelestialBodyModel celestialBodyModel = new CelestialBodyModel(CelestialBodyModel.getTexturedModelData().method_32109());
        celestialBodyModel.method_2828(matrixStack, provider.getBuffer(AITRenderLayers.method_23588((class_2960)texture)), 0xF000F0, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        if (hasRings) {
            celestialBodyModel.ring.method_22699(matrixStack, provider.getBuffer(AITRenderLayers.method_23588((class_2960)texture)), 0xF000F0, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        provider.method_22993();
        if (hasAtmosphere) {
            CelestialBodyRenderer.atmosphereRenderer(matrixStack, atmosphereColor, provider, false, hasClouds);
            provider.method_22993();
        }
        if (isSkyRendered) {
            RenderSystem.depthMask((boolean)false);
            GL11.glDepthFunc((int)514);
            GL11.glDisable((int)2929);
        }
        matrixStack.method_22909();
    }

    public static void atmosphereRenderer(class_4587 matrixStack, Vector3f color, class_4597.class_4598 provider, boolean isStar, boolean hasClouds) {
        CelestialBodyModel model = new CelestialBodyModel(CelestialBodyModel.getTexturedModelData().method_32109());
        for (int i = 0; i < 6; ++i) {
            float alpha = (float)((double)0.1f - Math.log(i + 1) * (double)0.001f);
            matrixStack.method_22903();
            float gg = 1.0f + (float)(i != 0 ? i : i + 1) * 0.025f;
            matrixStack.method_22905(gg, gg, gg);
            float delta = (class_310.method_1551().method_1488() + (float)class_310.method_1551().field_1724.field_6012) * 1.0E-5f;
            class_1921 renderLayer = AITRenderLayers.method_29379((class_2960)new class_2960("textures/environment/clouds.png"));
            class_2960 texture = AITMod.id("textures/environment/atmosphere.png");
            if (i != 1) {
                model.method_2828(matrixStack, provider.getBuffer(isStar && (i == 2 || i == 3 || i == 4) ? AITRenderLayers.method_23026((class_2960)texture) : AITRenderLayers.method_29379((class_2960)texture)), 0xF000E0, class_4608.field_21444, 1.0f + Math.min(color.x + 0.015f * (float)i, 5.0f), 1.0f + Math.min(color.y + 0.015f * (float)i, 5.0f), 1.0f + Math.min(color.z + 0.015f * (float)i, 5.0f), -1.0f + alpha);
            } else if (hasClouds) {
                model.method_2828(matrixStack, provider.getBuffer(renderLayer), 0xF000E0, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
                matrixStack.method_22905(1.01f, 1.01f, 1.01f);
                model.method_2828(matrixStack, provider.getBuffer(renderLayer), 0xF000E0, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            matrixStack.method_22909();
        }
    }
}

