/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.module.planet.core.space.planet;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.amble.ait.AITMod;
import dev.amble.ait.module.planet.core.item.SpacesuitItem;
import dev.amble.ait.module.planet.core.space.planet.PlanetRenderInfo;
import dev.amble.ait.module.planet.core.space.planet.PlanetTransition;
import dev.amble.lib.api.Identifiable;
import dev.amble.lib.util.ServerLifecycleHooks;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_7924;

public record Planet(class_2960 dimension, float gravity, boolean hasOxygen, boolean hasLandableSurface, int temperature, PlanetRenderInfo render, PlanetTransition transition) implements Identifiable
{
    public static final Codec<Planet> CODEC = class_5699.method_42114((Codec)RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("dimension").forGetter(Planet::dimension), (App)Codec.FLOAT.optionalFieldOf("gravity", (Object)Float.valueOf(-1.0f)).forGetter(Planet::gravity), (App)Codec.BOOL.fieldOf("has_oxygen").forGetter(Planet::hasOxygen), (App)Codec.BOOL.fieldOf("has_landable_surface").forGetter(Planet::hasLandableSurface), (App)Codec.INT.optionalFieldOf("temperature", (Object)288).forGetter(Planet::temperature), (App)PlanetRenderInfo.CODEC.optionalFieldOf("render", (Object)PlanetRenderInfo.EMPTY).forGetter(Planet::render), (App)PlanetTransition.CODEC.optionalFieldOf("transition", (Object)PlanetTransition.EMPTY).forGetter(Planet::transition)).apply((Applicative)instance, Planet::new)));

    public static boolean hasFullSuit(class_1309 entity) {
        return entity.method_6118(class_1304.field_6169).method_7909() instanceof SpacesuitItem && entity.method_6118(class_1304.field_6174).method_7909() instanceof SpacesuitItem && entity.method_6118(class_1304.field_6172).method_7909() instanceof SpacesuitItem && entity.method_6118(class_1304.field_6166).method_7909() instanceof SpacesuitItem;
    }

    public static double getOxygenInTank(class_1309 entity) {
        class_1799 chestplate = entity.method_6118(class_1304.field_6174);
        if (chestplate.method_7909() instanceof SpacesuitItem) {
            return chestplate.method_7948().method_10574("oxygen");
        }
        return 0.0;
    }

    public static boolean hasOxygenInTank(class_1309 entity) {
        return Planet.getOxygenInTank(entity) > 0.0;
    }

    public static Planet fromInputStream(InputStream stream) {
        return Planet.fromJson(JsonParser.parseReader((Reader)new InputStreamReader(stream)).getAsJsonObject());
    }

    public static Planet fromJson(JsonObject json) {
        AtomicReference created = new AtomicReference();
        CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).get().ifLeft(planet -> created.set((Planet)planet.getFirst())).ifRight(err -> {
            created.set(null);
            AITMod.LOGGER.error("Error decoding datapack planet: {}", err);
        });
        return (Planet)created.get();
    }

    public class_2960 id() {
        return this.dimension();
    }

    public float celsius() {
        return (float)this.temperature() - 273.15f;
    }

    public float kelvin() {
        return this.temperature();
    }

    public float fahrenheit() {
        return this.celsius() * 1.8f + 32.0f;
    }

    public boolean isFreezing() {
        return this.celsius() <= 0.0f;
    }

    public boolean zeroGravity() {
        return this.gravity() == 0.8f;
    }

    public boolean hasGravityModifier() {
        return this.gravity() >= 0.0f;
    }

    public boolean hasNoFallDamage() {
        return this.hasGravityModifier() && this.gravity() < 1.0f && this.gravity() != 0.0f;
    }

    public class_3218 toWorld() {
        return ServerLifecycleHooks.get().method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)this.dimension));
    }

    public Planet with(class_2960 dimension) {
        return new Planet(dimension, this.gravity, this.hasOxygen, this.hasLandableSurface, this.temperature, this.render, this.transition);
    }
}

